/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads;

import java.util.Collection;
import net.blay09.mods.cookingforblockheads.api.CacheHint;
import net.blay09.mods.cookingforblockheads.api.IngredientToken;
import net.blay09.mods.cookingforblockheads.api.KitchenItemProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public record ResourceHandlerKitchenItemProvider(ResourceHandler<ItemResource> itemHandler) implements KitchenItemProvider
{
    @Override
    public IngredientToken findIngredient(Ingredient ingredient, Collection<IngredientToken> ingredientTokens, CacheHint cacheHint) {
        ItemStack slotStack;
        ItemResource slotResource;
        if (cacheHint instanceof ItemHandlerIngredientToken) {
            ItemHandlerIngredientToken itemHandlerIngredientToken = (ItemHandlerIngredientToken)cacheHint;
            slotResource = (ItemResource)this.itemHandler.getResource(itemHandlerIngredientToken.slot);
            slotStack = slotResource.toStack();
            if (ingredient.test(slotStack) && this.hasUsesLeft(itemHandlerIngredientToken.slot, slotStack, ingredientTokens)) {
                return itemHandlerIngredientToken;
            }
        }
        for (int i = 0; i < this.itemHandler.size(); ++i) {
            slotResource = (ItemResource)this.itemHandler.getResource(i);
            slotStack = slotResource.toStack();
            if (!ingredient.test(slotStack) || !this.hasUsesLeft(i, slotStack, ingredientTokens)) continue;
            return new ItemHandlerIngredientToken(i);
        }
        return null;
    }

    @Override
    public IngredientToken findIngredient(ItemStack itemStack, Collection<IngredientToken> ingredientTokens, CacheHint cacheHint) {
        ItemStack slotStack;
        ItemResource slotResource;
        if (cacheHint instanceof ItemHandlerIngredientToken) {
            ItemHandlerIngredientToken itemHandlerIngredientToken = (ItemHandlerIngredientToken)cacheHint;
            slotResource = (ItemResource)this.itemHandler.getResource(itemHandlerIngredientToken.slot);
            slotStack = slotResource.toStack();
            if (ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)itemStack) && this.hasUsesLeft(itemHandlerIngredientToken.slot, slotStack, ingredientTokens)) {
                return itemHandlerIngredientToken;
            }
        }
        for (int i = 0; i < this.itemHandler.size(); ++i) {
            slotResource = (ItemResource)this.itemHandler.getResource(i);
            slotStack = slotResource.toStack();
            if (!ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)itemStack) || !this.hasUsesLeft(i, slotStack, ingredientTokens)) continue;
            return new ItemHandlerIngredientToken(i);
        }
        return null;
    }

    private boolean hasUsesLeft(int slot, ItemStack slotStack, Collection<IngredientToken> ingredientTokens) {
        int uses = slotStack.getCount();
        for (IngredientToken ingredientToken : ingredientTokens) {
            if (!(ingredientToken instanceof ItemHandlerIngredientToken)) continue;
            ItemHandlerIngredientToken itemHandlerIngredientToken = (ItemHandlerIngredientToken)ingredientToken;
            if (itemHandlerIngredientToken.slot != slot) continue;
            --uses;
        }
        return uses > 0;
    }

    @Override
    public CacheHint getCacheHint(IngredientToken ingredientToken) {
        CacheHint cacheHint;
        if (ingredientToken instanceof ItemHandlerIngredientToken) {
            ItemHandlerIngredientToken itemHandlerIngredientToken = (ItemHandlerIngredientToken)ingredientToken;
            cacheHint = itemHandlerIngredientToken;
        } else {
            cacheHint = CacheHint.NONE;
        }
        return cacheHint;
    }

    public class ItemHandlerIngredientToken
    implements IngredientToken,
    CacheHint {
        private final int slot;

        public ItemHandlerIngredientToken(int slot) {
            this.slot = slot;
        }

        @Override
        public ItemStack peek() {
            return ((ItemResource)ResourceHandlerKitchenItemProvider.this.itemHandler.getResource(this.slot)).toStack();
        }

        @Override
        public ItemStack consume() {
            ItemResource slotResource = (ItemResource)ResourceHandlerKitchenItemProvider.this.itemHandler.getResource(this.slot);
            try (Transaction transaction = Transaction.open(null);){
                int count = ResourceHandlerKitchenItemProvider.this.itemHandler.extract(this.slot, (Resource)slotResource, 1, (TransactionContext)transaction);
                transaction.commit();
                ItemStack itemStack = slotResource.toStack(count);
                return itemStack;
            }
        }

        @Override
        public ItemStack restore(ItemStack itemStack) {
            try (Transaction transaction = Transaction.open(null);){
                int restCount = ResourceHandlerKitchenItemProvider.this.itemHandler.insert(this.slot, (Resource)ItemResource.of((ItemStack)itemStack), itemStack.getCount(), (TransactionContext)transaction);
                if (restCount > 0) {
                    restCount = ResourceHandlerKitchenItemProvider.this.itemHandler.insert((Resource)ItemResource.of((ItemStack)itemStack), itemStack.getCount(), (TransactionContext)transaction);
                }
                transaction.commit();
                ItemStack itemStack2 = restCount > 0 ? itemStack.copyWithCount(restCount) : ItemStack.EMPTY;
                return itemStack2;
            }
        }
    }
}

