/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import net.blay09.mods.balm.api.block.BalmBlocks;
import net.blay09.mods.cookingforblockheads.block.CabinetBlock;
import net.blay09.mods.cookingforblockheads.block.ConnectorBlock;
import net.blay09.mods.cookingforblockheads.block.CookingTableBlock;
import net.blay09.mods.cookingforblockheads.block.CounterBlock;
import net.blay09.mods.cookingforblockheads.block.CowJarBlock;
import net.blay09.mods.cookingforblockheads.block.CuttingBoardBlock;
import net.blay09.mods.cookingforblockheads.block.DyedConnectorBlock;
import net.blay09.mods.cookingforblockheads.block.FridgeBlock;
import net.blay09.mods.cookingforblockheads.block.FruitBasketBlock;
import net.blay09.mods.cookingforblockheads.block.KitchenFloorBlock;
import net.blay09.mods.cookingforblockheads.block.MilkJarBlock;
import net.blay09.mods.cookingforblockheads.block.OvenBlock;
import net.blay09.mods.cookingforblockheads.block.SinkBlock;
import net.blay09.mods.cookingforblockheads.block.SpiceRackBlock;
import net.blay09.mods.cookingforblockheads.block.ToasterBlock;
import net.blay09.mods.cookingforblockheads.block.ToolRackBlock;
import net.blay09.mods.cookingforblockheads.component.ModComponents;
import net.blay09.mods.cookingforblockheads.component.MultiblockKitchenComponent;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class ModBlocks {
    public static CookingTableBlock[] dyedCookingTables = new CookingTableBlock[DyeColor.values().length];
    public static CounterBlock[] dyedCounters = new CounterBlock[DyeColor.values().length];
    public static CabinetBlock[] dyedCabinets = new CabinetBlock[DyeColor.values().length];
    public static OvenBlock[] ovens = new OvenBlock[DyeColor.values().length];
    public static CookingTableBlock cookingTable;
    public static Block toolRack;
    public static Block toaster;
    public static Block milkJar;
    public static Block cowJar;
    public static Block spiceRack;
    public static Block fruitBasket;
    public static Block cuttingBoard;
    public static FridgeBlock[] fridges;
    public static SinkBlock sink;
    public static SinkBlock[] dyedSinks;
    public static CounterBlock counter;
    public static CabinetBlock cabinet;
    public static Block connector;
    public static DyedConnectorBlock[] dyedConnectors;
    public static Block[] kitchenFloors;

    public static void initialize(BalmBlocks blocks) {
        String colorPrefix;
        blocks.register(identifier -> {
            toolRack = new ToolRackBlock(ModBlocks.blockProperties(identifier));
            return toolRack;
        }, (block, id) -> new BlockItem(block, ModBlocks.itemProperties(id).component((DataComponentType)ModComponents.multiblockKitchen.get(), (Object)new MultiblockKitchenComponent((Component)Component.translatable((String)"tooltip.cookingforblockheads.tool_rack.description")))), ModBlocks.id("tool_rack"));
        blocks.register(identifier -> {
            toaster = new ToasterBlock(ModBlocks.blockProperties(identifier));
            return toaster;
        }, (block, id) -> new BlockItem(block, ModBlocks.itemProperties(id).component((DataComponentType)ModComponents.multiblockKitchen.get(), (Object)new MultiblockKitchenComponent((Component)Component.translatable((String)"tooltip.cookingforblockheads.toaster.description")))), ModBlocks.id("toaster"));
        blocks.register(identifier -> {
            milkJar = new MilkJarBlock(ModBlocks.blockProperties(identifier));
            return milkJar;
        }, (block, id) -> new BlockItem(block, ModBlocks.itemProperties(id).component((DataComponentType)ModComponents.multiblockKitchen.get(), (Object)new MultiblockKitchenComponent((Component)Component.translatable((String)"tooltip.cookingforblockheads.milk_jar.description")))), ModBlocks.id("milk_jar"));
        blocks.register(identifier -> {
            cowJar = new CowJarBlock(ModBlocks.blockProperties(identifier));
            return cowJar;
        }, (block, id) -> new BlockItem(block, ModBlocks.itemProperties(id).component((DataComponentType)ModComponents.multiblockKitchen.get(), (Object)new MultiblockKitchenComponent((Component)Component.translatable((String)"tooltip.cookingforblockheads.cow_jar.description")))), ModBlocks.id("cow_jar"));
        blocks.register(identifier -> {
            spiceRack = new SpiceRackBlock(ModBlocks.blockProperties(identifier));
            return spiceRack;
        }, (block, id) -> new BlockItem(block, ModBlocks.itemProperties(id).component((DataComponentType)ModComponents.multiblockKitchen.get(), (Object)new MultiblockKitchenComponent((Component)Component.translatable((String)"tooltip.cookingforblockheads.spice_rack.description")))), ModBlocks.id("spice_rack"));
        blocks.register(identifier -> {
            fruitBasket = new FruitBasketBlock(ModBlocks.blockProperties(identifier));
            return fruitBasket;
        }, (block, id) -> new BlockItem(block, ModBlocks.itemProperties(id).component((DataComponentType)ModComponents.multiblockKitchen.get(), (Object)new MultiblockKitchenComponent((Component)Component.translatable((String)"tooltip.cookingforblockheads.fruit_basket.description")))), ModBlocks.id("fruit_basket"));
        blocks.register(identifier -> {
            cuttingBoard = new CuttingBoardBlock(ModBlocks.blockProperties(identifier));
            return cuttingBoard;
        }, (block, id) -> new BlockItem(block, ModBlocks.itemProperties(id).component((DataComponentType)ModComponents.multiblockKitchen.get(), (Object)new MultiblockKitchenComponent((Component)Component.translatable((String)"tooltip.cookingforblockheads.cutting_board.description")))), ModBlocks.id("cutting_board"));
        DyeColor[] colors = DyeColor.values();
        kitchenFloors = new Block[colors.length];
        ovens = new OvenBlock[colors.length];
        dyedCookingTables = new CookingTableBlock[colors.length];
        dyedConnectors = new DyedConnectorBlock[colors.length];
        for (DyeColor color : colors) {
            colorPrefix = color.getSerializedName() + "_";
            blocks.register(identifier -> {
                OvenBlock ovenBlock = new OvenBlock(color, ModBlocks.blockProperties(identifier));
                ModBlocks.ovens[color.ordinal()] = ovenBlock;
                return ovenBlock;
            }, (block, id) -> new BlockItem(block, ModBlocks.itemProperties(id).component((DataComponentType)ModComponents.multiblockKitchen.get(), (Object)new MultiblockKitchenComponent((Component)Component.translatable((String)"tooltip.cookingforblockheads.oven.description")))), ModBlocks.id(colorPrefix + "oven"));
        }
        for (DyeColor color : colors) {
            colorPrefix = color.getSerializedName() + "_";
            blocks.register(identifier -> {
                FridgeBlock fridgeBlock = new FridgeBlock(color, ModBlocks.blockProperties(identifier));
                ModBlocks.fridges[color.ordinal()] = fridgeBlock;
                return fridgeBlock;
            }, (block, id) -> new BlockItem(block, ModBlocks.itemProperties(id).component((DataComponentType)ModComponents.multiblockKitchen.get(), (Object)new MultiblockKitchenComponent((Component)Component.translatable((String)"tooltip.cookingforblockheads.fridge.description")))), ModBlocks.id(colorPrefix + "fridge"));
        }
        blocks.register(identifier -> {
            connector = new ConnectorBlock(ModBlocks.blockProperties(identifier));
            return connector;
        }, (block, id) -> new BlockItem(block, ModBlocks.itemProperties(id).component((DataComponentType)ModComponents.multiblockKitchen.get(), (Object)new MultiblockKitchenComponent((Component)Component.translatable((String)"tooltip.cookingforblockheads.connector.description")))), ModBlocks.id("connector"));
        for (DyeColor color : colors) {
            colorPrefix = color.getSerializedName() + "_";
            blocks.register(identifier -> {
                DyedConnectorBlock dyedConnectorBlock = new DyedConnectorBlock(color, ModBlocks.blockProperties(identifier));
                ModBlocks.dyedConnectors[color.ordinal()] = dyedConnectorBlock;
                return dyedConnectorBlock;
            }, (block, id) -> new BlockItem(block, ModBlocks.itemProperties(id).component((DataComponentType)ModComponents.multiblockKitchen.get(), (Object)new MultiblockKitchenComponent((Component)Component.translatable((String)"tooltip.cookingforblockheads.connector.description")))), ModBlocks.id(colorPrefix + "connector"));
        }
        for (DyeColor color : colors) {
            colorPrefix = color.getSerializedName() + "_";
            blocks.register(identifier -> {
                KitchenFloorBlock kitchenFloorBlock = new KitchenFloorBlock(ModBlocks.blockProperties(identifier));
                ModBlocks.kitchenFloors[color.ordinal()] = kitchenFloorBlock;
                return kitchenFloorBlock;
            }, (block, id) -> new BlockItem(block, ModBlocks.itemProperties(id).component((DataComponentType)ModComponents.multiblockKitchen.get(), (Object)new MultiblockKitchenComponent((Component)Component.translatable((String)"tooltip.cookingforblockheads.kitchen_floor.description")))), ModBlocks.id(colorPrefix + "kitchen_floor"));
        }
        blocks.register(identifier -> {
            cookingTable = new CookingTableBlock(null, ModBlocks.blockProperties(identifier));
            return cookingTable;
        }, (block, id) -> new BlockItem(block, ModBlocks.itemProperties(id).component((DataComponentType)ModComponents.multiblockKitchen.get(), (Object)new MultiblockKitchenComponent((Component)Component.translatable((String)"tooltip.cookingforblockheads.cooking_table.description")))), ModBlocks.id("cooking_table"));
        for (DyeColor color : colors) {
            colorPrefix = color.getSerializedName() + "_";
            blocks.register(identifier -> {
                CookingTableBlock cookingTableBlock = new CookingTableBlock(color, ModBlocks.blockProperties(identifier));
                ModBlocks.dyedCookingTables[color.ordinal()] = cookingTableBlock;
                return cookingTableBlock;
            }, (block, id) -> new BlockItem(block, ModBlocks.itemProperties(id).component((DataComponentType)ModComponents.multiblockKitchen.get(), (Object)new MultiblockKitchenComponent((Component)Component.translatable((String)"tooltip.cookingforblockheads.cooking_table.description")))), ModBlocks.id(colorPrefix + "cooking_table"));
        }
        blocks.register(identifier -> {
            counter = new CounterBlock(null, ModBlocks.blockProperties(identifier));
            return counter;
        }, (block, id) -> new BlockItem(block, ModBlocks.itemProperties(id).component((DataComponentType)ModComponents.multiblockKitchen.get(), (Object)new MultiblockKitchenComponent((Component)Component.translatable((String)"tooltip.cookingforblockheads.counter.description")))), ModBlocks.id("counter"));
        for (DyeColor color : colors) {
            colorPrefix = color.getSerializedName() + "_";
            blocks.register(identifier -> {
                CounterBlock counterBlock = new CounterBlock(color, ModBlocks.blockProperties(identifier));
                ModBlocks.dyedCounters[color.ordinal()] = counterBlock;
                return counterBlock;
            }, (block, id) -> new BlockItem(block, ModBlocks.itemProperties(id).component((DataComponentType)ModComponents.multiblockKitchen.get(), (Object)new MultiblockKitchenComponent((Component)Component.translatable((String)"tooltip.cookingforblockheads.counter.description")))), ModBlocks.id(colorPrefix + "counter"));
        }
        blocks.register(identifier -> {
            cabinet = new CabinetBlock(null, ModBlocks.blockProperties(identifier));
            return cabinet;
        }, (block, id) -> new BlockItem(block, ModBlocks.itemProperties(id).component((DataComponentType)ModComponents.multiblockKitchen.get(), (Object)new MultiblockKitchenComponent((Component)Component.translatable((String)"tooltip.cookingforblockheads.cabinet.description")))), ModBlocks.id("cabinet"));
        for (DyeColor color : colors) {
            colorPrefix = color.getSerializedName() + "_";
            blocks.register(identifier -> {
                CabinetBlock cabinetBlock = new CabinetBlock(color, ModBlocks.blockProperties(identifier));
                ModBlocks.dyedCabinets[color.ordinal()] = cabinetBlock;
                return cabinetBlock;
            }, (block, id) -> new BlockItem(block, ModBlocks.itemProperties(id).component((DataComponentType)ModComponents.multiblockKitchen.get(), (Object)new MultiblockKitchenComponent((Component)Component.translatable((String)"tooltip.cookingforblockheads.cabinet.description")))), ModBlocks.id(colorPrefix + "cabinet"));
        }
        blocks.register(identifier -> {
            sink = new SinkBlock(null, ModBlocks.blockProperties(identifier));
            return sink;
        }, (block, id) -> new BlockItem(block, ModBlocks.itemProperties(id).component((DataComponentType)ModComponents.multiblockKitchen.get(), (Object)new MultiblockKitchenComponent((Component)Component.translatable((String)"tooltip.cookingforblockheads.sink.description")))), ModBlocks.id("sink"));
        for (DyeColor color : colors) {
            colorPrefix = color.getSerializedName() + "_";
            blocks.register(identifier -> {
                SinkBlock sinkBlock = new SinkBlock(color, ModBlocks.blockProperties(identifier));
                ModBlocks.dyedSinks[color.ordinal()] = sinkBlock;
                return sinkBlock;
            }, (block, id) -> new BlockItem(block, ModBlocks.itemProperties(id).component((DataComponentType)ModComponents.multiblockKitchen.get(), (Object)new MultiblockKitchenComponent((Component)Component.translatable((String)"tooltip.cookingforblockheads.sink.description")))), ModBlocks.id(colorPrefix + "sink"));
        }
    }

    private static BlockBehaviour.Properties blockProperties(ResourceLocation identifier) {
        return BlockBehaviour.Properties.of().setId(ModBlocks.blockId(identifier));
    }

    private static Item.Properties itemProperties(ResourceLocation identifier) {
        return new Item.Properties().setId(ModBlocks.itemId(identifier));
    }

    private static ResourceKey<Block> blockId(ResourceLocation identifier) {
        return ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)identifier);
    }

    private static ResourceKey<Item> itemId(ResourceLocation identifier) {
        return ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)identifier);
    }

    private static BlockItem itemBlock(Block block, ResourceLocation identifier) {
        return new BlockItem(block, ModBlocks.itemProperties(identifier));
    }

    private static ResourceLocation id(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"cookingforblockheads", (String)name);
    }

    static {
        fridges = new FridgeBlock[DyeColor.values().length];
        dyedSinks = new SinkBlock[DyeColor.values().length];
        dyedConnectors = new DyedConnectorBlock[DyeColor.values().length];
        kitchenFloors = new Block[DyeColor.values().length];
    }
}

