/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client.gui.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.api.ISortButton;
import net.blay09.mods.cookingforblockheads.client.CookingForBlockheadsClient;
import net.blay09.mods.cookingforblockheads.client.gui.SortButton;
import net.blay09.mods.cookingforblockheads.crafting.CraftableWithStatus;
import net.blay09.mods.cookingforblockheads.crafting.RecipeWithStatus;
import net.blay09.mods.cookingforblockheads.menu.KitchenMenu;
import net.blay09.mods.cookingforblockheads.menu.slot.CraftMatrixFakeSlot;
import net.blay09.mods.cookingforblockheads.menu.slot.CraftableListingFakeSlot;
import net.blay09.mods.cookingforblockheads.network.message.ToggleFavoriteMessage;
import net.blay09.mods.cookingforblockheads.registry.CookingForBlockheadsRegistry;
import net.blay09.mods.cookingforblockheads.tag.ModItemTags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.display.FurnaceRecipeDisplay;
import org.joml.Matrix3x2fStack;

public class KitchenScreen
extends AbstractContainerScreen<KitchenMenu> {
    private static final float KITCHEN_FEEDBACK_HINT_TIME = 40.0f;
    private static final int SCROLLBAR_COLOR = -5592406;
    private static final int SCROLLBAR_Y = 8;
    private static final int SCROLLBAR_WIDTH = 7;
    private static final int SCROLLBAR_HEIGHT = 77;
    private static final ResourceLocation guiTexture = ResourceLocation.fromNamespaceAndPath((String)"cookingforblockheads", (String)"textures/gui/gui.png");
    private static final int VISIBLE_ROWS = 4;
    private static final int VISIBLE_COLS = 3;
    private int scrollBarScaledHeight;
    private int scrollBarXPos;
    private int scrollBarYPos;
    private int currentOffset;
    private Component kitchenFeedback;
    private float kitchenFeedbackTimeLeft;
    private double mouseClickY = -1.0;
    private int indexWhenClicked;
    private int lastNumberOfMoves;
    private Button btnNextRecipe;
    private Button btnPrevRecipe;
    private EditBox searchBar;
    private final List<SortButton> sortButtons = new ArrayList<SortButton>();
    private final String[] noIngredients = I18n.get((String)"gui.cookingforblockheads.no_ingredients", (Object[])new Object[0]).split("\\\\n");
    private final String[] noSelection = I18n.get((String)"gui.cookingforblockheads.no_selection", (Object[])new Object[0]).split("\\\\n");

    public KitchenScreen(KitchenMenu menu, Inventory playerInventory, Component displayName) {
        super((AbstractContainerMenu)menu, playerInventory, displayName);
    }

    protected void init() {
        this.imageHeight = 174;
        super.init();
        this.btnPrevRecipe = Button.builder((Component)Component.literal((String)"<"), it -> ((KitchenMenu)this.menu).nextRecipe(-1)).pos(this.width / 2 - 79, this.height / 2 - 51).size(13, 20).build();
        this.btnPrevRecipe.visible = false;
        this.addRenderableWidget((GuiEventListener)this.btnPrevRecipe);
        this.btnNextRecipe = Button.builder((Component)Component.literal((String)">"), it -> ((KitchenMenu)this.menu).nextRecipe(1)).pos(this.width / 2 - 9, this.height / 2 - 51).size(13, 20).build();
        this.btnNextRecipe.visible = false;
        this.addRenderableWidget((GuiEventListener)this.btnNextRecipe);
        this.searchBar = new EditBox(this.minecraft.font, this.leftPos + this.imageWidth - 78, this.topPos - 5, 70, 10, this.searchBar, (Component)Component.empty());
        this.setInitialFocus((GuiEventListener)this.searchBar);
        this.addRenderableWidget((GuiEventListener)this.searchBar);
        int yOffset = -80;
        this.sortButtons.clear();
        for (ISortButton sortButton : CookingForBlockheadsRegistry.getSortButtons()) {
            SortButton button = new SortButton(this.width / 2 + 87, this.height / 2 + yOffset, sortButton, it -> ((KitchenMenu)this.menu).setSortComparator(sortButton.getComparator((Player)Minecraft.getInstance().player)));
            this.addRenderableWidget((GuiEventListener)button);
            this.sortButtons.add(button);
            yOffset += 20;
        }
        this.recalculateScrollBar();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (deltaY == 0.0) {
            return false;
        }
        if (((KitchenMenu)this.menu).getSelectedRecipe() != null && mouseX >= (double)(this.leftPos + 24) && mouseY >= (double)(this.topPos + 20) && mouseX < (double)(this.leftPos + 78) && mouseY < (double)(this.topPos + 74)) {
            CraftMatrixFakeSlot fakeSlot;
            Slot slot = ((AbstractContainerScreenAccessor)this).getHoveredSlot();
            if (slot instanceof CraftMatrixFakeSlot && (fakeSlot = (CraftMatrixFakeSlot)slot).getVisibleStacks().size() > 1) {
                ItemStack lockedInput = fakeSlot.scrollDisplayListAndLock(deltaY > 0.0 ? -1 : 1);
                ((KitchenMenu)this.menu).setLockedInput(fakeSlot.getIngredientIndex(), lockedInput);
            }
        } else {
            this.setCurrentOffset(deltaY > 0.0 ? this.currentOffset - 1 : this.currentOffset + 1);
        }
        return true;
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        boolean result = super.mouseReleased(event);
        if (event.button() != -1 && this.mouseClickY != -1.0) {
            this.mouseClickY = -1.0;
            this.indexWhenClicked = 0;
            this.lastNumberOfMoves = 0;
        }
        return result;
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        Slot mouseSlot;
        if (event.button() == 1 && event.x() >= (double)this.searchBar.getX() && event.x() < (double)(this.searchBar.getX() + this.searchBar.getWidth()) && event.y() >= (double)this.searchBar.getY() && event.y() < (double)(this.searchBar.getY() + this.searchBar.getHeight())) {
            this.searchBar.setValue("");
            ((KitchenMenu)this.menu).search(null);
            ((KitchenMenu)this.menu).updateCraftableSlots();
            this.setCurrentOffset(this.currentOffset);
            return true;
        }
        if (this.searchBar.mouseClicked(event, doubleClick)) {
            this.setFocused((GuiEventListener)this.searchBar);
            return true;
        }
        if (event.x() >= (double)this.scrollBarXPos && event.x() <= (double)(this.scrollBarXPos + 7) && event.y() >= (double)this.scrollBarYPos && event.y() <= (double)(this.scrollBarYPos + this.scrollBarScaledHeight)) {
            this.mouseClickY = event.y();
            this.indexWhenClicked = this.currentOffset;
        }
        if ((mouseSlot = ((AbstractContainerScreenAccessor)this).getHoveredSlot()) instanceof CraftMatrixFakeSlot) {
            CraftMatrixFakeSlot fakeSlot = (CraftMatrixFakeSlot)mouseSlot;
            if (event.button() == 0) {
                ItemStack itemStack = mouseSlot.getItem();
                CraftableWithStatus recipe = ((KitchenMenu)this.menu).findCraftableForResultItem(itemStack);
                if (recipe != null) {
                    ((KitchenMenu)this.menu).pushHistory();
                    ((KitchenMenu)this.menu).selectCraftable(recipe);
                    this.setCurrentOffset(((KitchenMenu)this.menu).getRecipesForSelectionIndex());
                    this.setFocused(null);
                }
            } else if (event.button() == 1) {
                ItemStack lockedInput = fakeSlot.toggleLock();
                ((KitchenMenu)this.menu).setLockedInput(fakeSlot.getIngredientIndex(), lockedInput);
            }
            return true;
        }
        if (mouseSlot instanceof CraftableListingFakeSlot) {
            CraftableWithStatus recipe;
            CraftableListingFakeSlot recipeFakeSlot = (CraftableListingFakeSlot)mouseSlot;
            if (event.hasAltDown() && (recipe = recipeFakeSlot.getCraftable()) != null) {
                ItemStack itemStack = recipe.itemStack();
                ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem());
                Balm.getNetworking().sendToServer((CustomPacketPayload)new ToggleFavoriteMessage(itemId, !this.isFavoriteItem(itemStack)));
                return true;
            }
        }
        return super.mouseClicked(event, doubleClick);
    }

    public boolean charTyped(CharacterEvent event) {
        boolean result = super.charTyped(event);
        ((KitchenMenu)this.menu).search(this.searchBar.getValue());
        ((KitchenMenu)this.menu).updateCraftableSlots();
        this.setCurrentOffset(this.currentOffset);
        return result;
    }

    public boolean keyPressed(KeyEvent event) {
        if (event.isEscape()) {
            this.minecraft.player.closeContainer();
            return true;
        }
        if (!this.searchBar.isFocused() && event.key() == 259) {
            ((KitchenMenu)this.menu).popHistory();
            return true;
        }
        String previousSearch = this.searchBar.getValue();
        if (this.searchBar.keyPressed(event) || this.searchBar.isFocused()) {
            if (!this.searchBar.getValue().equals(previousSearch)) {
                ((KitchenMenu)this.menu).search(this.searchBar.getValue());
                ((KitchenMenu)this.menu).updateCraftableSlots();
                this.setCurrentOffset(this.currentOffset);
            }
            return true;
        }
        return super.keyPressed(event);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int curY;
        int numberOfFiltersMoved;
        float pixelsPerFilter;
        if (((KitchenMenu)this.menu).isScrollOffsetDirty()) {
            this.setCurrentOffset(this.currentOffset);
            ((KitchenMenu)this.menu).setScrollOffsetDirty(false);
        }
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, guiTexture, this.leftPos, this.topPos - 10, 0.0f, 0.0f, this.imageWidth, this.imageHeight + 10, 256, 256);
        if (this.mouseClickY != -1.0 && (pixelsPerFilter = (float)(77 - this.scrollBarScaledHeight) / (float)Math.max(1, (int)Math.ceil((float)((KitchenMenu)this.menu).getItemListCount() / 3.0f) - 4)) != 0.0f && (numberOfFiltersMoved = (int)(((double)mouseY - this.mouseClickY) / (double)pixelsPerFilter)) != this.lastNumberOfMoves) {
            this.setCurrentOffset(this.indexWhenClicked + numberOfFiltersMoved);
            this.lastNumberOfMoves = numberOfFiltersMoved;
        }
        this.btnPrevRecipe.visible = ((KitchenMenu)this.menu).selectionHasRecipeVariants();
        this.btnPrevRecipe.active = ((KitchenMenu)this.menu).selectionHasPreviousRecipe();
        this.btnNextRecipe.visible = ((KitchenMenu)this.menu).selectionHasRecipeVariants();
        this.btnNextRecipe.active = ((KitchenMenu)this.menu).selectionHasNextRecipe();
        boolean hasRecipes = ((KitchenMenu)this.menu).getItemListCount() > 0;
        for (Button button : this.sortButtons) {
            button.active = hasRecipes;
        }
        Font font = this.minecraft.font;
        RecipeWithStatus recipeWithStatus = ((KitchenMenu)this.menu).getSelectedRecipe();
        if (recipeWithStatus == null) {
            int n = this.noSelection.length / 2;
            Objects.requireNonNull(font);
            curY = this.topPos + 39 - n * 9;
            for (String s : this.noSelection) {
                guiGraphics.drawString(font, s, this.leftPos + 23 + 27 - font.width(s) / 2, curY, -1, true);
                Objects.requireNonNull(font);
                curY += 9 + 5;
            }
        } else if (recipeWithStatus.recipeDisplayEntry().display() instanceof FurnaceRecipeDisplay) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, guiTexture, this.leftPos + 23, this.topPos + 19, 54.0f, 184.0f, 54, 54, 256, 256);
        } else {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, guiTexture, this.leftPos + 23, this.topPos + 19, 0.0f, 184.0f, 54, 54, 256, 256);
        }
        if (recipeWithStatus != null) {
            for (CraftMatrixFakeSlot slot : ((KitchenMenu)this.menu).getMatrixSlots()) {
                if (!slot.isLocked() || slot.getVisibleStacks().size() <= 1) continue;
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, guiTexture, this.leftPos + slot.x, this.topPos + slot.y, 176.0f, 60.0f, 16, 16, 256, 256);
            }
        }
        guiGraphics.fill(this.scrollBarXPos, this.scrollBarYPos, this.scrollBarXPos + 7, this.scrollBarYPos + this.scrollBarScaledHeight, -5592406);
        if (((KitchenMenu)this.menu).getItemListCount() == 0) {
            guiGraphics.fill(this.leftPos + 97, this.topPos + 7, this.leftPos + 168, this.topPos + 85, -1440603614);
            int n = this.noIngredients.length / 2;
            Objects.requireNonNull(font);
            curY = this.topPos + 39 - n * 9;
            for (String s : this.noIngredients) {
                guiGraphics.drawString(font, s, this.leftPos + 97 + 36 - font.width(s) / 2, curY, -1, true);
                Objects.requireNonNull(font);
                curY += 9 + 5;
            }
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (CookingForBlockheadsConfig.getActive().showIngredientIcon) {
            Matrix3x2fStack poseStack = guiGraphics.pose();
            poseStack.pushMatrix();
            for (Slot slot : ((KitchenMenu)this.menu).slots) {
                CraftableWithStatus craftable;
                if (!(slot instanceof CraftableListingFakeSlot)) continue;
                CraftableListingFakeSlot fakeSlot = (CraftableListingFakeSlot)slot;
                if (slot.getItem().is(ModItemTags.INGREDIENTS)) {
                    guiGraphics.blit(RenderPipelines.GUI_TEXTURED, guiTexture, slot.x, slot.y, 176.0f, 76.0f, 16, 16, 256, 256);
                }
                if ((craftable = fakeSlot.getCraftable()) != null && craftable.missingUtensils()) {
                    guiGraphics.blit(RenderPipelines.GUI_TEXTURED, guiTexture, slot.x, slot.y, 176.0f, 92.0f, 16, 16, 256, 256);
                }
                if (craftable == null || !this.isFavoriteItem(craftable.itemStack())) continue;
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, guiTexture, slot.x, slot.y, 176.0f, 108.0f, 16, 16, 256, 256);
            }
            poseStack.popMatrix();
        }
    }

    private boolean isFavoriteItem(ItemStack itemStack) {
        return CookingForBlockheadsClient.isFavoriteItem(itemStack);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.kitchenFeedback != null && this.kitchenFeedbackTimeLeft > 0.0f) {
            float alpha = 1.0f;
            if (this.kitchenFeedbackTimeLeft < 20.0f) {
                alpha = Math.max(0.0f, this.kitchenFeedbackTimeLeft / 20.0f);
            }
            guiGraphics.drawCenteredString(this.font, this.kitchenFeedback, this.leftPos + 8 + 42, this.topPos + 18, -1);
            this.kitchenFeedbackTimeLeft -= partialTicks;
        }
        Matrix3x2fStack poseStack = guiGraphics.pose();
        poseStack.pushMatrix();
        for (Slot slot : ((KitchenMenu)this.menu).slots) {
            CraftMatrixFakeSlot fakeSlot;
            if (!(slot instanceof CraftMatrixFakeSlot) || !(fakeSlot = (CraftMatrixFakeSlot)slot).isMissing() || slot.getItem().isEmpty()) continue;
            guiGraphics.fillGradient(this.leftPos + slot.x, this.topPos + slot.y, this.leftPos + slot.x + 16, this.topPos + slot.y + 16, 0x77FF4444, 0x77FF5555);
        }
        poseStack.popMatrix();
        for (CraftMatrixFakeSlot matrixSlot : ((KitchenMenu)this.menu).getMatrixSlots()) {
            matrixSlot.updateSlot(partialTicks);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void recalculateScrollBar() {
        int scrollBarTotalHeight = 76;
        this.scrollBarScaledHeight = (int)((double)scrollBarTotalHeight * Math.min(1.0, 4.0 / Math.ceil((float)((KitchenMenu)this.menu).getItemListCount() / 3.0f)));
        this.scrollBarXPos = this.leftPos + this.imageWidth - 7 - 9;
        this.scrollBarYPos = this.topPos + 8 + (scrollBarTotalHeight - this.scrollBarScaledHeight) * this.currentOffset / Math.max(1, (int)Math.ceil((float)((KitchenMenu)this.menu).getItemListCount() / 3.0f) - 4);
    }

    private void setCurrentOffset(int currentOffset) {
        this.currentOffset = Math.max(0, Math.min(currentOffset, (int)Math.ceil((float)((KitchenMenu)this.menu).getItemListCount() / 3.0f) - 4));
        ((KitchenMenu)this.menu).setScrollOffset(this.currentOffset);
        this.recalculateScrollBar();
    }

    public List<Button> getSortingButtons() {
        return new ArrayList<Button>(this.sortButtons);
    }

    public void displayKitchenFeedback(Component component) {
        this.kitchenFeedback = component;
        this.kitchenFeedbackTimeLeft = 40.0f;
    }
}

