/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.blay09.mods.cookingforblockheads.block.FridgeBlock;
import net.blay09.mods.cookingforblockheads.block.entity.FridgeBlockEntity;
import net.blay09.mods.cookingforblockheads.client.ModModels;
import net.blay09.mods.cookingforblockheads.client.render.RenderUtils;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class FridgeRenderer
implements BlockEntityRenderer<FridgeBlockEntity, FridgeRenderState> {
    private final ItemModelResolver itemModelResolver;

    public FridgeRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelResolver = context.itemModelResolver();
    }

    public FridgeRenderState createRenderState() {
        return new FridgeRenderState();
    }

    public void extractRenderState(FridgeBlockEntity blockEntity, FridgeRenderState renderState, float delta, Vec3 vec, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        DyeColor dyeColor;
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, delta, vec, crumblingOverlay);
        Block block = renderState.blockState.getBlock();
        if (block instanceof FridgeBlock) {
            FridgeBlock fridgeBlock = (FridgeBlock)block;
            dyeColor = fridgeBlock.getColor();
        } else {
            dyeColor = DyeColor.WHITE;
        }
        renderState.dye = dyeColor;
        renderState.doorAngle = blockEntity.getDoorAnimator().getRenderAngle(delta);
        renderState.modelType = (FridgeBlock.FridgeModelType)((Object)blockEntity.getBlockState().getValue(FridgeBlock.MODEL_TYPE));
        renderState.skip = renderState.modelType == FridgeBlock.FridgeModelType.LARGE_UPPER;
        renderState.flipped = (Boolean)blockEntity.getBlockState().getValue((Property)FridgeBlock.FLIPPED);
        int id = (int)blockEntity.getBlockPos().asLong();
        renderState.items = new ArrayList<ItemStackRenderState>();
        for (int i = 0; i < blockEntity.getContainer().getContainerSize(); ++i) {
            ItemStack itemStack = blockEntity.getContainer().getItem(i);
            ItemStackRenderState itemStackRenderState = new ItemStackRenderState();
            this.itemModelResolver.updateForTopItem(itemStackRenderState, itemStack, ItemDisplayContext.FIXED, blockEntity.getLevel(), null, id + i);
            renderState.items.add(itemStackRenderState);
        }
    }

    public void submit(FridgeRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        BlockStateModel lowerModel;
        if (renderState.skip) {
            return;
        }
        boolean isLarge = renderState.modelType == FridgeBlock.FridgeModelType.LARGE_LOWER;
        poseStack.pushPose();
        RenderUtils.applyBlockAngle(poseStack, renderState.blockState);
        poseStack.translate(-0.5f, 0.0f, -0.5f);
        float originX = 0.90625f;
        float originZ = 0.09375f;
        if (renderState.flipped) {
            originX = 1.0f - originX;
        }
        poseStack.translate(originX, 0.0f, originZ);
        poseStack.mulPose((Quaternionfc)Axis.YN.rotationDegrees((float)Math.toDegrees(renderState.flipped ? (double)(-renderState.doorAngle) : (double)renderState.doorAngle)));
        poseStack.translate(-originX, 0.0f, -originZ);
        int colorIndex = renderState.dye.getId();
        BlockStateModel upperModel = null;
        if (isLarge) {
            lowerModel = renderState.flipped ? (BlockStateModel)ModModels.fridgeDoorsLargeLowerFlipped.get(colorIndex).get() : (BlockStateModel)ModModels.fridgeDoorsLargeLower.get(colorIndex).get();
            upperModel = renderState.flipped ? (BlockStateModel)ModModels.fridgeDoorsLargeUpperFlipped.get(colorIndex).get() : (BlockStateModel)ModModels.fridgeDoorsLargeUpper.get(colorIndex).get();
        } else {
            lowerModel = renderState.flipped ? (BlockStateModel)ModModels.fridgeDoorsFlipped.get(colorIndex).get() : (BlockStateModel)ModModels.fridgeDoors.get(colorIndex).get();
        }
        submitNodeCollector.submitBlockModel(poseStack, RenderType.entityCutout((ResourceLocation)TextureAtlas.LOCATION_BLOCKS), lowerModel, 1.0f, 1.0f, 1.0f, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
        if (upperModel != null) {
            poseStack.translate(0.0f, 1.0f, 0.0f);
            submitNodeCollector.submitBlockModel(poseStack, RenderType.entityCutout((ResourceLocation)TextureAtlas.LOCATION_BLOCKS), upperModel, 1.0f, 1.0f, 1.0f, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
        }
        poseStack.popPose();
        if (renderState.doorAngle > 0.0f) {
            poseStack.pushPose();
            poseStack.translate(0.0, 0.5, 0.0);
            RenderUtils.applyBlockAngle(poseStack, renderState.blockState);
            poseStack.scale(0.3f, 0.3f, 0.3f);
            float topY = renderState.modelType == FridgeBlock.FridgeModelType.LARGE_LOWER ? 3.25f : 0.45f;
            for (int i = renderState.items.size() - 1; i >= 0; --i) {
                float offsetZ;
                float offsetY;
                float offsetX;
                ItemStackRenderState itemStackRenderState = renderState.items.get(i);
                if (itemStackRenderState.isEmpty()) continue;
                if (renderState.modelType == FridgeBlock.FridgeModelType.LARGE_LOWER) {
                    rowIndex = i % 18;
                    offsetX = 0.7f - (float)(rowIndex % 9) * 0.175f;
                    offsetY = topY - (float)((int)((float)i / 18.0f)) * 1.25f;
                    offsetZ = 0.5f - (float)((int)((float)rowIndex / 9.0f)) * 0.9f;
                } else {
                    rowIndex = i % 13;
                    offsetX = 0.7f;
                    float spacing = 0.175f;
                    if (rowIndex / 9 > 0) {
                        offsetX -= 0.2f;
                        spacing *= 2.0f;
                    }
                    offsetX -= (float)(rowIndex % 9) * spacing;
                    offsetY = topY - (float)((int)((float)i / 14.0f)) * 1.25f;
                    offsetZ = 0.5f - (float)((int)((float)rowIndex / 9.0f)) * 0.9f;
                }
                poseStack.pushPose();
                poseStack.translate(offsetX, offsetY, offsetZ);
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(45.0f));
                itemStackRenderState.submit(poseStack, submitNodeCollector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
                poseStack.popPose();
            }
            poseStack.popPose();
        }
    }

    public static class FridgeRenderState
    extends BlockEntityRenderState {
        public boolean skip;
        public List<ItemStackRenderState> items = Collections.emptyList();
        public FridgeBlock.FridgeModelType modelType = FridgeBlock.FridgeModelType.SMALL;
        public DyeColor dye = DyeColor.WHITE;
        public float doorAngle;
        public boolean flipped;
    }
}

