/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.blay09.mods.cookingforblockheads.block.entity.SpiceRackBlockEntity;
import net.blay09.mods.cookingforblockheads.client.render.RenderUtils;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class SpiceRackRenderer
implements BlockEntityRenderer<SpiceRackBlockEntity, SpiceRackRenderState> {
    private final ItemModelResolver itemModelResolver;

    public SpiceRackRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelResolver = context.itemModelResolver();
    }

    public SpiceRackRenderState createRenderState() {
        return new SpiceRackRenderState();
    }

    public void extractRenderState(SpiceRackBlockEntity blockEntity, SpiceRackRenderState renderState, float delta, Vec3 vec, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, delta, vec, crumblingOverlay);
        int id = (int)blockEntity.getBlockPos().asLong();
        renderState.items = new ArrayList<ItemStackRenderState>();
        for (int i = 0; i < blockEntity.getContainer().getContainerSize(); ++i) {
            ItemStack itemStack = blockEntity.getContainer().getItem(i);
            ItemStackRenderState itemStackRenderState = new ItemStackRenderState();
            this.itemModelResolver.updateForTopItem(itemStackRenderState, itemStack, ItemDisplayContext.FIXED, blockEntity.getLevel(), null, id + i);
            renderState.items.add(itemStackRenderState);
        }
    }

    public void submit(SpiceRackRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        poseStack.pushPose();
        RenderUtils.applyBlockAngle(poseStack, renderState.blockState);
        poseStack.translate(-0.4, 0.75, 0.3);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
        poseStack.scale(0.5f, 0.5f, 0.5f);
        for (int i = 0; i < renderState.items.size(); ++i) {
            ItemStackRenderState itemStackRenderState = renderState.items.get(i);
            if (itemStackRenderState.isEmpty()) continue;
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, 0.2f * (float)i);
            poseStack.mulPose((Quaternionfc)Axis.YN.rotationDegrees(20.0f));
            itemStackRenderState.submit(poseStack, submitNodeCollector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    public static class SpiceRackRenderState
    extends BlockEntityRenderState {
        public List<ItemStackRenderState> items = Collections.emptyList();
    }
}

