package dev.bouncingelf10.timelesslib;

import dev.bouncingelf10.timelesslib.api.animation.AnimationManager;
import dev.bouncingelf10.timelesslib.api.clock.TimelessClock;
import dev.bouncingelf10.timelesslib.api.cooldown.ClientCooldownManager;
import dev.bouncingelf10.timelesslib.api.countdown.ClientCountdownManager;
import dev.bouncingelf10.timelesslib.api.scheduler.Scheduler;
import dev.bouncingelf10.timelesslib.fabric.TimelessFabricHelper;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_310;
import java.util.UUID;

public class TimelessLibClient implements ClientModInitializer {
	public static final Scheduler<class_310> clientScheduler = new Scheduler<>(TimelessFabricHelper::getClient);
	public static final ClientCountdownManager<class_310> clientCountdownManager = new ClientCountdownManager<>(TimelessFabricHelper::getClient);
	public static final ClientCooldownManager<class_310> clientCooldownManager = new ClientCooldownManager<>(TimelessFabricHelper::getClient, UUID.randomUUID());
    public static final AnimationManager clientAnimationManager = new AnimationManager();

	@Override
	public void onInitializeClient() {
		TimelessLib.LOGGER.info("TimelessLib Client Initialising");

		ClientTickEvents.END_CLIENT_TICK.register(client -> TimelessClock.update());
        ClientTickEvents.END_CLIENT_TICK.register(client -> clientAnimationManager.update());
    }

	public static Scheduler<class_310> getClientScheduler() {
		return clientScheduler;
	}
	public static ClientCountdownManager<class_310> getClientCountdownManager() {
		return clientCountdownManager;
	}
	public static ClientCooldownManager<class_310> getClientCooldownManager() {
		return clientCooldownManager;
	}
    public static AnimationManager getClientAnimationManager() {
        return clientAnimationManager;
    }
}