package dev.bouncingelf10.timelesslib.api.animation.keyframes;

import dev.bouncingelf10.timelesslib.api.animation.Interpolation;
import net.minecraft.class_243;
import dev.bouncingelf10.timelesslib.api.animation.Easing;

public class KeyframeVec3 {
    public final double timeSeconds;
    public final class_243 value;
    public final Interpolation interpolation;
    public final Easing easing;

    public KeyframeVec3(double timeSeconds, class_243 value, Interpolation interpolation, Easing easing) {
        if (timeSeconds < 0) throw new IllegalArgumentException("timeSeconds < 0");
        this.timeSeconds = timeSeconds;
        this.value = value;
        this.interpolation = interpolation;
        this.easing = easing;
    }

    public static KeyframeVec3 of(double timeSeconds, class_243 value) {
        return new KeyframeVec3(timeSeconds, value, null, null);
    }

    public static KeyframeVec3 of(double timeSeconds, class_243 value, Easing easing) {
        return new KeyframeVec3(timeSeconds, value, null, easing);
    }

    public static KeyframeVec3 of(double timeSeconds, class_243 value, Interpolation interp) {
        return new KeyframeVec3(timeSeconds, value, interp, null);
    }

    public static KeyframeVec3 of(double timeSeconds, class_243 value, Easing easing, Interpolation interp) {
        return new KeyframeVec3(timeSeconds, value, interp, easing);
    }
}
