package dev.bouncingelf10.timelesslib.fabric;

import dev.bouncingelf10.timelesslib.TimelessLib;
import dev.bouncingelf10.timelesslib.api.time.TimeFormat;
import dev.bouncingelf10.timelesslib.api.time.TimeFormatter;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import org.jetbrains.annotations.Nullable;

import java.util.UUID;

public class TimelessFabricHelper {

    // ===================== COMMON ==================

    public static boolean isClient() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    public static boolean isServer() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER;
    }

    // ===================== CLIENT ==================

    public static @Nullable class_310 getClient() {
        return isClient() ? class_310.method_1551() : null;
    }

    public static @Nullable UUID getPlayerUuid() {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) return null;

        return client.field_1724.method_5667();
    }

    public static void clientDisplayToUser(long nanosLeft) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) return;

        String msg = TimeFormatter.format(nanosLeft, TimeFormat.VERBOSE_SIMPLE) + " left";
        client.field_1724.method_7353(class_2561.method_43470(msg), true);
    }

    public static void clientDisplayToUser(long nanosLeft, TimeFormat fmt,
                                           String prefix, String suffix) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) return;

        String msg = prefix + TimeFormatter.format(nanosLeft, fmt) + suffix;
        client.field_1724.method_7353(class_2561.method_43470(msg), true);
    }

    public static boolean shouldAdvanceTime() {
        if (!isClient()) return true;

        class_310 client = class_310.method_1551();
        return !client.method_1493() && client.method_1542();
    }

    // ===================== SERVER ==================

    public static void serverDisplayToUser(long nanosLeft, class_3222 player) {
        if (!TimelessLib.isServerInitialized()) return;

        String msg = TimeFormatter.format(nanosLeft, TimeFormat.VERBOSE_SIMPLE) + " left";
        player.method_7353(class_2561.method_43470(msg), true);
    }

    public static void serverDisplayToUser(long nanosLeft, class_3222 player, TimeFormat fmt, String prefix, String suffix) {
        if (!TimelessLib.isServerInitialized()) return;

        String msg = prefix + TimeFormatter.format(nanosLeft, fmt) + suffix;
        player.method_7353(class_2561.method_43470(msg), true);
    }

    public static void serverDisplayNearbyUsers(long nanosLeft, class_243 pos, float radius) {
        if (!TimelessLib.isServerInitialized()) return;

        class_3324 list = TimelessLib.getServer().method_3760();

        for (class_3222 player : list.method_14571()) {
            if (player.method_5707(pos) <= radius * radius) {
                serverDisplayToUser(nanosLeft, player);
            }
        }
    }

    public static void serverDisplayNearbyUsers(long nanosLeft, class_243 pos, float radius, TimeFormat fmt, String prefix, String suffix) {
        if (!TimelessLib.isServerInitialized()) return;

        class_3324 list = TimelessLib.getServer().method_3760();

        for (class_3222 player : list.method_14571()) {
            if (player.method_5707(pos) <= radius * radius) {
                serverDisplayToUser(nanosLeft, player, fmt, prefix, suffix);
            }
        }
    }

    public static void serverDisplayAllUsers(long nanosLeft) {
        if (!TimelessLib.isServerInitialized()) return;

        class_3324 list = TimelessLib.getServer().method_3760();
        for (class_3222 player : list.method_14571()) {
            serverDisplayToUser(nanosLeft, player);
        }
    }

    public static void serverDisplayAllUsers(long nanosLeft, TimeFormat fmt, String prefix, String suffix) {
        if (!TimelessLib.isServerInitialized()) return;

        class_3324 list = TimelessLib.getServer().method_3760();
        for (class_3222 player : list.method_14571()) {
            serverDisplayToUser(nanosLeft, player, fmt, prefix, suffix);
        }
    }
}