/*
 * Decompiled with CFR 0.152.
 */
package lol.sylvie.rosemarylib.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import lombok.Generated;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigManager<T extends Instance> {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Logger logger;
    private T instance;
    protected File file;

    public ConfigManager(String modId, T instance) {
        this.file = FabricLoader.getInstance().getConfigDir().resolve(modId + ".json").toFile();
        this.logger = LoggerFactory.getLogger((String)("rosemarylib/" + modId));
        this.instance = instance;
        this.read(this.file);
    }

    public void read(File file) {
        try (FileReader reader = new FileReader(file);){
            this.instance = (Instance)GSON.fromJson((Reader)reader, this.instance.getClass());
        }
        catch (JsonSyntaxException | IOException readException) {
            this.logger.warn("Error while reading config:", readException);
            this.write(file);
        }
    }

    public void write(File file) {
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson(this.instance, (Appendable)writer);
        }
        catch (IOException writeException) {
            this.logger.error("Error while writing config:", (Throwable)writeException);
        }
    }

    public void addSaveShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.write(this.file)));
    }

    @Generated
    public T getInstance() {
        return this.instance;
    }

    public static class Instance {
    }
}

