/*
 * Decompiled with CFR 0.152.
 */
package lol.sylvie.rosemarylib.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import lol.sylvie.rosemarylib.Rosemary;
import lol.sylvie.rosemarylib.gui.DialogManager;
import net.minecraft.class_11416;
import net.minecraft.class_11417;
import net.minecraft.class_11419;
import net.minecraft.class_11424;
import net.minecraft.class_11426;
import net.minecraft.class_11432;
import net.minecraft.class_11434;
import net.minecraft.class_11435;
import net.minecraft.class_11437;
import net.minecraft.class_11438;
import net.minecraft.class_11440;
import net.minecraft.class_11442;
import net.minecraft.class_11444;
import net.minecraft.class_11519;
import net.minecraft.class_11520;
import net.minecraft.class_11524;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class DialogBuilder {
    private final class_3222 player;
    private final class_2561 title;
    private boolean closeOnEsc = true;
    private int columns = 1;
    private final ArrayList<class_11432> body = new ArrayList();
    private final ArrayList<class_11424> inputs = new ArrayList();
    private final ArrayList<class_11519> buttons = new ArrayList();
    private final HashMap<class_2960, Consumer<class_2487>> actions = new HashMap();

    public DialogBuilder(class_3222 player, class_2561 title) {
        this.player = player;
        this.title = title;
    }

    public DialogBuilder closeOnEsc(boolean value) {
        this.closeOnEsc = value;
        return this;
    }

    public DialogBuilder columns(int value) {
        this.columns = value;
        return this;
    }

    public DialogBuilder bodyText(class_2561 text) {
        this.body.add((class_11432)new class_11435(text, 200));
        return this;
    }

    public DialogBuilder bodyItem(class_1799 stack, class_11435 description, boolean showDecorations, boolean showTooltip, @Nullable Integer width, @Nullable Integer height) {
        this.body.add((class_11432)new class_11434(stack, Optional.ofNullable(description), showDecorations, showTooltip, width == null ? 200 : width, height == null ? 64 : height));
        return this;
    }

    public DialogBuilder bodyItem(class_1799 stack, class_2561 text, int width, int height) {
        return this.bodyItem(stack, new class_11435(text, 200), true, true, width, height);
    }

    public DialogBuilder bodyItem(class_1799 stack, boolean showDecorations, boolean showTooltip, int width, int height) {
        return this.bodyItem(stack, null, showDecorations, showTooltip, width, height);
    }

    public DialogBuilder bodyItem(class_1799 stack, int width, int height) {
        return this.bodyItem(stack, false, false, width, height);
    }

    public DialogBuilder bodyItem(class_1799 stack, boolean showDecorations, boolean showTooltip) {
        return this.bodyItem(stack, null, showDecorations, showTooltip, 16, 16);
    }

    public DialogBuilder input(String key, class_11438 control) {
        this.inputs.add(new class_11424(key, control));
        return this;
    }

    public DialogBuilder textInput(String key, int width, class_2561 label, String value, int maxLength, @Nullable class_11444.class_11508 multiline) {
        return this.input(key, (class_11438)new class_11444(width, label, !label.getString().isEmpty(), value, maxLength, Optional.ofNullable(multiline)));
    }

    public DialogBuilder textInput(String key, int width, class_2561 label, String value, int maxLength) {
        return this.textInput(key, width, label, value, maxLength, null);
    }

    public DialogBuilder checkboxInput(String key, class_2561 label, boolean value) {
        return this.input(key, (class_11438)new class_11437(label, value, null, null));
    }

    public DialogBuilder numberInput(String key, int width, class_2561 label, String format, class_11440.class_11441 range) {
        return this.input(key, (class_11438)new class_11440(width, label, format, range));
    }

    public DialogBuilder numberInput(String key, int width, class_2561 label, class_11440.class_11441 range) {
        return this.numberInput(key, width, label, "%s: %s", range);
    }

    public DialogBuilder singleOptionInput(String key, int width, class_2561 label, List<class_11442.class_11443> options) {
        return this.input(key, (class_11438)new class_11442(width, options, label, !label.getString().isEmpty()));
    }

    public DialogBuilder actionButton(class_2960 buttonId, class_2561 text, Consumer<class_2487> callback, @Nullable class_2487 extraData, @Nullable Integer buttonWidth) {
        class_11524 action = new class_11524(buttonId, Optional.ofNullable(extraData));
        class_11519 button = new class_11519(new class_11416(text, buttonWidth == null ? 310 : buttonWidth), Optional.of(action));
        this.buttons.add(button);
        if (!this.actions.containsKey(buttonId)) {
            this.actions.put(buttonId, callback);
        } else {
            Rosemary.LOGGER.warn("Action {} was added twice :(", (Object)buttonId);
        }
        return this;
    }

    public DialogBuilder actionButton(class_2960 buttonId, class_2561 text, Consumer<class_2487> callback) {
        return this.actionButton(buttonId, text, callback, null, null);
    }

    public class_11419 build() {
        for (Map.Entry<class_2960, Consumer<class_2487>> entry : this.actions.entrySet()) {
            DialogManager.register(this.player, entry.getKey(), entry.getValue());
        }
        class_11417 data = new class_11417(this.title, Optional.empty(), this.closeOnEsc, false, class_11520.field_60962, this.body, this.inputs);
        return new class_11426(data, this.buttons, Optional.empty(), this.columns);
    }

    public void buildAndOpen(class_3222 player) {
        player.method_71753((class_6880)new class_6880.class_6881((Object)this.build()));
    }
}

