/*
 * Decompiled with CFR 0.152.
 */
package github.catchaos8.levelup.event;

import com.mojang.brigadier.CommandDispatcher;
import github.catchaos8.levelup.attributes.ModAttributes;
import github.catchaos8.levelup.commands.get.GetAllStatsCommand;
import github.catchaos8.levelup.commands.get.GetClassLevelCommand;
import github.catchaos8.levelup.commands.get.GetClassXPCommand;
import github.catchaos8.levelup.commands.get.GetConCommand;
import github.catchaos8.levelup.commands.get.GetDexCommand;
import github.catchaos8.levelup.commands.get.GetEndCommand;
import github.catchaos8.levelup.commands.get.GetFreePointsCommand;
import github.catchaos8.levelup.commands.get.GetStatsCommand;
import github.catchaos8.levelup.commands.get.GetStrCommand;
import github.catchaos8.levelup.commands.get.GetVitCommand;
import github.catchaos8.levelup.commands.set.SetAllStatsCommand;
import github.catchaos8.levelup.commands.set.SetClassLevelCommand;
import github.catchaos8.levelup.commands.set.SetClassXPCommand;
import github.catchaos8.levelup.commands.set.SetConCommand;
import github.catchaos8.levelup.commands.set.SetDexCommand;
import github.catchaos8.levelup.commands.set.SetEndCommand;
import github.catchaos8.levelup.commands.set.SetFreePointsCommand;
import github.catchaos8.levelup.commands.set.SetStatsCommand;
import github.catchaos8.levelup.commands.set.SetStrCommand;
import github.catchaos8.levelup.commands.set.SetVitCommand;
import github.catchaos8.levelup.config.LevelUPCommonConfig;
import github.catchaos8.levelup.lib.DisplayLevelScoreboard;
import github.catchaos8.levelup.lib.PlayerHealedEvent;
import github.catchaos8.levelup.lib.SetStats;
import github.catchaos8.levelup.networking.ModNetwork;
import github.catchaos8.levelup.networking.packet.StatDataSyncS2CPacket;
import github.catchaos8.levelup.stats.PlayerStats;
import github.catchaos8.levelup.stats.PlayerStatsProvider;
import java.util.List;
import java.util.Random;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.command.ConfigCommand;

public class ModEvents {

    @Mod.EventBusSubscriber(modid="levelup", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEventBus {
        @SubscribeEvent
        public static void addAttributes(EntityAttributeModificationEvent event) {
            for (EntityType type : event.getTypes()) {
                if (type.m_20674_() != MobCategory.MONSTER) continue;
                event.add(type, (Attribute)ModAttributes.CONSTITUTION.get(), 0.0);
                event.add(type, (Attribute)ModAttributes.DEXTERITY.get(), 0.0);
                event.add(type, (Attribute)ModAttributes.STRENGTH.get(), 0.0);
                event.add(type, (Attribute)ModAttributes.VITALITY.get(), 0.0);
                event.add(type, (Attribute)ModAttributes.ENDURANCE.get(), 0.0);
            }
            event.add(EntityType.f_20532_, (Attribute)ModAttributes.CONSTITUTION.get(), 0.0);
            event.add(EntityType.f_20532_, (Attribute)ModAttributes.DEXTERITY.get(), 0.0);
            event.add(EntityType.f_20532_, (Attribute)ModAttributes.STRENGTH.get(), 0.0);
            event.add(EntityType.f_20532_, (Attribute)ModAttributes.VITALITY.get(), 0.0);
            event.add(EntityType.f_20532_, (Attribute)ModAttributes.ENDURANCE.get(), 0.0);
        }
    }

    @Mod.EventBusSubscriber(modid="levelup", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeEvents {
        @SubscribeEvent
        public static void commandsRegister(RegisterCommandsEvent event) {
            new GetStatsCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            new GetConCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            new GetDexCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            new GetStrCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            new GetVitCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            new GetEndCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            new GetAllStatsCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            new GetFreePointsCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            new GetClassXPCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            new GetClassLevelCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            new SetStatsCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            new SetConCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            new SetDexCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            new SetStrCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            new SetVitCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            new SetEndCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            new SetAllStatsCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            new SetFreePointsCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            new SetClassXPCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            new SetClassLevelCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            ConfigCommand.register((CommandDispatcher)event.getDispatcher());
        }

        @SubscribeEvent
        public static void onAttachCapabilitiesPlayer(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !((Entity)event.getObject()).getCapability(PlayerStatsProvider.PLAYER_STATS).isPresent()) {
                event.addCapability(new ResourceLocation("levelup", "levelup"), (ICapabilityProvider)new PlayerStatsProvider());
            }
        }

        @SubscribeEvent
        public static void onPlayerCloned(PlayerEvent.Clone event) {
            Player player;
            Player original = event.getOriginal();
            original.revive();
            Player player2 = event.getEntity();
            if (!((Boolean)LevelUPCommonConfig.RESET_POINTS.get()).booleanValue()) {
                event.getOriginal().getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(oldStore -> event.getEntity().getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(newStore -> {
                    newStore.copyFrom((PlayerStats)oldStore);
                    if (event.isWasDeath() && ((Boolean)LevelUPCommonConfig.LOSE_XP.get()).booleanValue()) {
                        float xp = newStore.getInfo(1);
                        double xpLost = (Double)LevelUPCommonConfig.XP_LOSS_PERCENT.get();
                        float level = newStore.getInfo(2);
                        int xpNeeded = (int)((Double)LevelUPCommonConfig.A_VALUE.get() * Math.pow(level, (Double)LevelUPCommonConfig.D_VALUE.get()) + (Double)LevelUPCommonConfig.B_VALUE.get() + (Double)LevelUPCommonConfig.C_VALUE.get());
                        float lostXP = (float)((double)xpNeeded * xpLost / 100.0);
                        newStore.subInfo(1, lostXP);
                        boolean loseLevels = (Boolean)LevelUPCommonConfig.LOSE_LEVELS.get();
                        do {
                            if (!loseLevels) continue;
                            ForgeEvents.loseLevel(event, newStore);
                            xpNeeded = (int)((Double)LevelUPCommonConfig.A_VALUE.get() * Math.pow(level -= 1.0f, (Double)LevelUPCommonConfig.D_VALUE.get()) + (Double)LevelUPCommonConfig.B_VALUE.get() + (Double)LevelUPCommonConfig.C_VALUE.get());
                            xp = newStore.getInfo(1);
                            newStore.addInfo(1, xpNeeded);
                        } while (loseLevels && xp - lostXP < 0.0f);
                        if (xp - lostXP < 0.0f) {
                            xp = 0.0f;
                            newStore.setInfo(1, xp);
                        }
                    }
                }));
            }
            if ((player = event.getEntity()) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                player2.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> {
                    for (int i = 0; i < stats.getLength(); ++i) {
                        SetStats.setAttributeStat(stats.getBaseStat(i), i, serverPlayer);
                    }
                    Attribute[] attributes = new Attribute[]{(Attribute)ModAttributes.CONSTITUTION.get(), (Attribute)ModAttributes.DEXTERITY.get(), (Attribute)ModAttributes.STRENGTH.get(), (Attribute)ModAttributes.VITALITY.get(), (Attribute)ModAttributes.ENDURANCE.get()};
                    for (int i = 0; i < attributes.length; ++i) {
                        double currentValue = serverPlayer.m_21133_(attributes[i]);
                        if (!(currentValue < (double)stats.getLimitedStat(i))) continue;
                        stats.setLimitedStat(i, (int)currentValue);
                    }
                    SetStats.makeAttributeMods(serverPlayer);
                    ModNetwork.sendToPlayer(new StatDataSyncS2CPacket(stats.getInfoArr(), stats.getStatsTypeArr()), serverPlayer);
                    serverPlayer.m_5634_((float)serverPlayer.m_21133_(Attributes.f_22276_));
                });
            }
        }

        static void loseLevel(PlayerEvent.Clone event, PlayerStats newStore) {
            if (((Boolean)LevelUPCommonConfig.LOSE_LEVELS.get()).booleanValue() && event.isWasDeath()) {
                float totalPoints = 0.0f;
                for (int i = 0; i < newStore.getLength(); ++i) {
                    totalPoints += newStore.getBaseStat(i);
                }
                totalPoints += newStore.getInfo(0);
                Double pointsPerLvl = (Double)LevelUPCommonConfig.FREEPOINTS_PER_LEVEL.get();
                if (newStore.getInfo(2) > 0.0f && (double)totalPoints >= pointsPerLvl) {
                    double freePointLoss = Math.min((double)newStore.getInfo(0), pointsPerLvl);
                    newStore.subInfo(0, (float)freePointLoss);
                    double lostPoints = freePointLoss;
                    Random random = new Random();
                    while (lostPoints < pointsPerLvl) {
                        int lostStat = random.nextInt(newStore.getLength());
                        if (!(newStore.getBaseStat(lostStat) > 0.0f)) continue;
                        newStore.subBaseStat(lostStat, 1.0f);
                        lostPoints += 1.0;
                    }
                    newStore.subInfo(2, 1.0f);
                }
            }
        }

        @SubscribeEvent
        public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
            event.register(PlayerStats.class);
        }

        @SubscribeEvent
        public static void onPlayerJoinWorld(EntityJoinLevelEvent event) {
            Entity entity;
            if (!event.getLevel().m_5776_() && (entity = event.getEntity()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                player.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> {
                    float level = stats.getInfo(2);
                    DisplayLevelScoreboard.updateLevel(player, level);
                    ModNetwork.sendToPlayer(new StatDataSyncS2CPacket(stats.getInfoArr(), stats.getStatsTypeArr()), player);
                });
            }
        }

        @SubscribeEvent
        public static void onPlayerPickXP(PlayerXpEvent event) {
            if (event instanceof PlayerXpEvent.PickupXp) {
                PlayerXpEvent.PickupXp pickupXpEvent = (PlayerXpEvent.PickupXp)event;
                Player player = pickupXpEvent.getEntity();
                ExperienceOrb orb = pickupXpEvent.getOrb();
                int xpAmount = orb.m_20801_();
                if (!player.m_9236_().f_46443_ && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    player.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> {
                        stats.addInfo(1, xpAmount);
                        SetStats.increaseLevel(serverPlayer);
                        ModNetwork.sendToPlayer(new StatDataSyncS2CPacket(stats.getInfoArr(), stats.getStatsTypeArr()), serverPlayer);
                    });
                }
            }
        }

        @SubscribeEvent
        public static void onLivingUpdate(LivingEvent.LivingTickEvent event) {
            Player player;
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                player = (Player)livingEntity;
                player.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> {
                    if (stats.getPrevHP() < 0.0f) {
                        stats.setPrevHP(Float.valueOf(player.m_21223_()));
                    }
                    if (stats.getPrevHP() < player.m_21223_()) {
                        float healedAmount = player.m_21223_() - stats.getPrevHP();
                        MinecraftForge.EVENT_BUS.post((Event)new PlayerHealedEvent(player, healedAmount));
                    }
                    stats.setPrevHP(Float.valueOf(player.m_21223_()));
                });
            }
            if ((livingEntity = event.getEntity()) instanceof Player) {
                player = (Player)livingEntity;
                if (player.f_19797_ % (Integer)LevelUPCommonConfig.VITALITY_TICKS_PER_REGEN.get() == 0) {
                    player.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> {
                        if (((Boolean)LevelUPCommonConfig.DO_HP_REGEN.get()).booleanValue()) {
                            float vitality = stats.getLimitedStat(3);
                            double regenMulti = (Double)LevelUPCommonConfig.VITALITY_HP_REGEN.get() * (double)((Integer)LevelUPCommonConfig.VITALITY_TICKS_PER_REGEN.get()).intValue();
                            double healingMult = (Double)LevelUPCommonConfig.VITALITY_HEALING.get() * (double)stats.getLimitedStat(3) + 1.0;
                            if (vitality > 0.0f) {
                                if (!player.m_9236_().m_6106_().m_5466_()) {
                                    player.m_5634_((float)((double)vitality * regenMulti / healingMult));
                                } else {
                                    player.m_5634_((float)((double)vitality * regenMulti / (Double)LevelUPCommonConfig.VITALITY_HARDCORE_NERF.get() / healingMult));
                                }
                            }
                        }
                    });
                }
            }
        }

        @SubscribeEvent
        public static void onHeal(PlayerHealedEvent event) {
            Player player = event.getPlayer();
            float amount = event.getHealedAmount().floatValue();
            player.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> {
                float buffedHeal = (float)((double)amount * (Double)LevelUPCommonConfig.VITALITY_HEALING.get()) * stats.getLimitedStat(3);
                player.m_5634_(buffedHeal);
            });
        }

        @SubscribeEvent
        public static void onLivingFall(LivingFallEvent event) {
            LivingEntity livingEntity;
            if (((Boolean)LevelUPCommonConfig.DO_FALL_DAMAGE_REDUCTION.get()).booleanValue() && (livingEntity = event.getEntity()) instanceof Player) {
                Player player = (Player)livingEntity;
                player.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> {
                    if (event.getDistance() > 0.0f) {
                        float constitution = stats.getLimitedStat(0);
                        double fallDMGReductionDouble = (Double)LevelUPCommonConfig.CONSTITUTION_FALL_DAMAGE_REDUCTION.get();
                        float fallDMGReduction = (float)fallDMGReductionDouble;
                        float currentDamage = event.getDamageMultiplier() * event.getDistance();
                        float newDamage = Math.max(0.0f, currentDamage - fallDMGReduction * constitution - 3.0f);
                        if (!player.m_9236_().f_46443_ && constitution > 0.0f) {
                            event.setDamageMultiplier(newDamage / event.getDistance());
                        }
                    }
                });
            }
        }

        @SubscribeEvent
        public static void onServerStart(ServerStartingEvent event) {
            DisplayLevelScoreboard.initializeScoreboard(event.getServer().m_129896_());
        }

        @SubscribeEvent
        public static void setTab(PlayerEvent.TabListNameFormat event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                player2.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> {
                    if (((Boolean)LevelUPCommonConfig.DISPLAY_LEVEL_BESIDE_NAME_IN_PLAYER_LIST.get()).booleanValue()) {
                        DisplayLevelScoreboard.setName(event);
                    }
                });
            }
        }

        @SubscribeEvent
        public static void onEquipmentChange(LivingEquipmentChangeEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                player.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> {
                    EquipmentSlot slot = event.getSlot();
                    ItemStack newItem = event.getFrom();
                    ItemStack oldItem = event.getTo();
                    record StatRecord(Attribute attribute, int modIndex) {
                    }
                    List<StatRecord> statRecordList = List.of(new StatRecord((Attribute)ModAttributes.CONSTITUTION.get(), 0), new StatRecord((Attribute)ModAttributes.DEXTERITY.get(), 1), new StatRecord((Attribute)ModAttributes.STRENGTH.get(), 2), new StatRecord((Attribute)ModAttributes.VITALITY.get(), 3), new StatRecord((Attribute)ModAttributes.ENDURANCE.get(), 4));
                    for (StatRecord info : statRecordList) {
                        int increase;
                        AttributeInstance attrInstance = player.m_21051_(info.attribute());
                        if (attrInstance == null) continue;
                        int current = (int)attrInstance.m_22135_();
                        float limited = stats.getLimitedStat(info.modIndex);
                        double[] newVals = SetStats.getAttributeValues(oldItem, info.attribute(), slot);
                        double[] oldVals = SetStats.getAttributeValues(newItem, info.attribute(), slot);
                        if (oldVals[1] == 0.0 && newVals[1] == 0.0 && (increase = (int)(newVals[0] - oldVals[0])) != 0 && ((float)current == limited || increase < 0 && (float)(current + increase) < limited)) {
                            stats.setLimitedStat(info.modIndex, current + increase);
                            SetStats.makeAttributeSingleMod(player, info.modIndex());
                        }
                        ModNetwork.sendToPlayer(new StatDataSyncS2CPacket(stats.getInfoArr(), stats.getStatsTypeArr()), player);
                    }
                });
            }
        }
    }
}

