/*
 * Decompiled with CFR 0.152.
 */
package github.catchaos8.levelup.commands.set;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import github.catchaos8.levelup.lib.DisplayLevelScoreboard;
import github.catchaos8.levelup.networking.ModNetwork;
import github.catchaos8.levelup.networking.packet.StatDataSyncS2CPacket;
import github.catchaos8.levelup.stats.PlayerStatsProvider;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class SetClassLevelCommand {
    public static final String CLASSLVL = "stat.levelup.clvl";

    public SetClassLevelCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"levelup").requires(commandSource -> commandSource.m_6761_(4))).then(Commands.m_82127_((String)"stats").then(Commands.m_82127_((String)"set").then(Commands.m_82127_((String)"classlvl").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(this::execute))))));
    }

    private int execute(CommandContext<CommandSourceStack> context) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        assert (player != null);
        if (player.m_20310_(2)) {
            player.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> {
                stats.setInfo(2, amount);
                ModNetwork.sendToPlayer(new StatDataSyncS2CPacket(stats.getInfoArr(), stats.getStatsTypeArr()), player);
                float level = stats.getInfo(2);
                DisplayLevelScoreboard.updateLevel(player, level);
                player.m_213846_((Component)Component.m_237115_((String)CLASSLVL).m_7220_((Component)Component.m_237113_((String)("" + level))));
            });
        } else {
            player.m_213846_((Component)Component.m_237115_((String)"cmd.levelup.noperms"));
        }
        return 1;
    }
}

