/*
 * Decompiled with CFR 0.152.
 */
package github.catchaos8.levelup.mixin;

import github.catchaos8.levelup.config.LevelUPCommonConfig;
import github.catchaos8.levelup.stats.PlayerStatsProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerMixin {
    @Inject(method={"causeFoodExhaustion"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyExhaustion(float exhaustion, CallbackInfo ci) {
        Player player = (Player)this;
        FoodData foodData = player.m_36324_();
        if (((Boolean)LevelUPCommonConfig.DO_HUNGER.get()).booleanValue()) {
            player.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> {
                float end = stats.getLimitedStat(4);
                if (end != 0.0f && player.m_20142_()) {
                    double hungerDecrease = (Double)LevelUPCommonConfig.ENDURANCE_HUNGER.get();
                    float totalDecrease = (float)Math.pow(1.0 - hungerDecrease, end);
                    foodData.m_38703_(exhaustion * totalDecrease);
                    ci.cancel();
                }
            });
        }
    }
}

