/*
 * Decompiled with CFR 0.152.
 */
package github.catchaos8.levelup.networking.packet;

import github.catchaos8.levelup.lib.SetStats;
import github.catchaos8.levelup.stats.PlayerStatsProvider;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class ChangeInfoC2SPacket {
    private final int type;
    private final float amount;

    public ChangeInfoC2SPacket(int type, float amount) {
        this.type = Math.max(0, type);
        this.amount = Math.max(0.0f, amount);
    }

    public ChangeInfoC2SPacket(FriendlyByteBuf buf) {
        this.type = buf.readInt();
        this.amount = buf.readFloat();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.type);
        buf.writeFloat(this.amount);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            assert (player != null);
            player.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> {
                if (this.type == 0) {
                    stats.addInfo(0, this.amount);
                } else {
                    stats.addInfo(this.type, this.amount);
                    SetStats.increaseLevel(player);
                }
            });
        });
    }
}

