/*
 * Decompiled with CFR 0.152.
 */
package github.catchaos8.levelup.stats;

import github.catchaos8.levelup.lib.StatType;
import java.util.Arrays;
import net.minecraft.nbt.CompoundTag;

public class PlayerStats {
    private final int min_stat = 0;
    private StatType[] statTypes = new StatType[]{new StatType(0.0f, 0.0f, "Constitution"), new StatType(0.0f, 0.0f, "Dexterity"), new StatType(0.0f, 0.0f, "Strength"), new StatType(0.0f, 0.0f, "Vitality"), new StatType(0.0f, 0.0f, "Endurance")};
    private float[] info = new float[]{0.0f, 0.0f, 0.0f};

    public float[] getInfoArr() {
        return this.info;
    }

    public int getLength() {
        return this.statTypes.length;
    }

    public float getInfo(int type) {
        return this.info[type];
    }

    public void addInfo(int statType, float add) {
        this.info[statType] = statType != 1 ? Math.max(this.info[statType] + add, 0.0f) : this.info[statType] + add;
    }

    public void subInfo(int statType, float sub) {
        this.info[statType] = statType != 1 ? Math.max(this.info[statType] - sub, 0.0f) : this.info[statType] - sub;
    }

    public void setInfo(int statType, float amount) {
        this.info[statType] = statType != 1 ? Math.max(amount, 0.0f) : amount;
    }

    public StatType[] getStatsTypeArr() {
        return this.statTypes;
    }

    public float[] getStatsBaseArr() {
        float[] array = new float[this.statTypes.length];
        for (int i = 0; i < this.statTypes.length; ++i) {
            array[i] = this.statTypes[i].getBase();
        }
        return array;
    }

    public float[] getStatsLimitedArr() {
        float[] array = new float[this.statTypes.length];
        for (int i = 0; i < this.statTypes.length; ++i) {
            array[i] = this.statTypes[i].getLimited();
        }
        return array;
    }

    public float getBaseStat(int type) {
        return this.statTypes[type].getBase();
    }

    public float getLimitedStat(int type) {
        return this.statTypes[type].getLimited();
    }

    public void setBaseStat(int type, float value) {
        this.statTypes[type].setBase(value);
    }

    public void setLimitedStat(int type, float value) {
        this.statTypes[type].setLimited(value);
    }

    public void addBaseStat(int type, float amount) {
        this.statTypes[type].setBase(this.statTypes[type].getBase() + amount);
    }

    public void addLimitedStat(int type, float amount) {
        this.statTypes[type].setLimited(this.statTypes[type].getLimited() + amount);
    }

    public void subBaseStat(int type, float amount) {
        this.statTypes[type].setBase(Math.max(this.statTypes[type].getBase() - amount, 0.0f));
    }

    public void subLimitedStat(int type, float amount) {
        this.statTypes[type].setLimited(Math.max(this.statTypes[type].getLimited() - amount, 0.0f));
    }

    public void copyFrom(PlayerStats source) {
        this.info = Arrays.copyOf(source.info, source.info.length);
        this.statTypes = Arrays.copyOf(source.statTypes, source.statTypes.length);
    }

    public void saveNBTData(CompoundTag nbt) {
        for (StatType stat : this.statTypes) {
            String name = stat.getName().toLowerCase();
            nbt.m_128350_(name, stat.getBase());
            nbt.m_128350_("limit_" + name, stat.getLimited());
        }
        nbt.m_128350_("freepoints", this.info[0]);
        nbt.m_128350_("classxp", this.info[1]);
        nbt.m_128350_("classLevel", this.info[2]);
    }

    public void loadNBTData(CompoundTag nbt) {
        for (StatType saved : this.statTypes) {
            String name = saved.getName().toLowerCase();
            saved.setBase(nbt.m_128457_(name));
            saved.setLimited(nbt.m_128457_("limit_" + name));
        }
        this.info[0] = nbt.m_128457_("freepoints");
        this.info[1] = nbt.m_128457_("classxp");
        this.info[2] = nbt.m_128457_("classLevel");
    }
}

