/*
 * Decompiled with CFR 0.152.
 */
package github.catchaos8.levelup.client.screen;

import github.catchaos8.levelup.attributes.ModAttributes;
import github.catchaos8.levelup.client.ClientStatData;
import github.catchaos8.levelup.lib.StatType;
import github.catchaos8.levelup.networking.ModNetwork;
import github.catchaos8.levelup.networking.packet.SetLimitedStatC2SPacket;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraftforge.client.gui.widget.ForgeSlider;
import org.jetbrains.annotations.NotNull;

public class LevelUPLimitScreen
extends Screen {
    private static final Component TITLE = Component.m_237115_((String)"gui.levelup.level_gui_limit");
    private static final Component CONSTITUTION = Component.m_237115_((String)"stat.levelup.con");
    private static final Component DEXTERITY = Component.m_237115_((String)"stat.levelup.dex");
    private static final Component STRENGTH = Component.m_237115_((String)"stat.levelup.str");
    private static final Component VITALITY = Component.m_237115_((String)"stat.levelup.vit");
    private static final Component ENDURANCE = Component.m_237115_((String)"stat.levelup.end");
    private static final ResourceLocation GUI_LOCATION = new ResourceLocation("levelup", "textures/gui/container/levelup_gui.png");
    private final int imageWidth;
    private final int imageHeight;
    private int leftPos;
    private int topPos;

    public LevelUPLimitScreen() {
        super(TITLE);
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        if (this.f_96541_ == null) {
            return;
        }
        ClientLevel level = this.f_96541_.f_91073_;
        if (level == null) {
            return;
        }
        StatType constitution = this.getStatTypes(0);
        StatType dexterity = this.getStatTypes(1);
        StatType strength = this.getStatTypes(2);
        StatType vitality = this.getStatTypes(3);
        StatType endurance = this.getStatTypes(4);
        this.m_142416_((GuiEventListener)new ForgeSlider(this.leftPos + 8, this.topPos + 18, 160, 20, CONSTITUTION, (Component)Component.m_237119_(), 0.0, this.getAttribute(0), constitution.getLimited(), true){

            public void m_7691_(double mouseX, double mouseY) {
                super.m_7691_(mouseX, mouseY);
                LevelUPLimitScreen.this.setLimitedStat(0, (float)this.getValue());
            }

            public void m_7212_(double mouseX, double mouseY, double deltaX, double deltaY) {
                super.m_7212_(mouseX, mouseY, deltaX, deltaY);
                LevelUPLimitScreen.this.setLimitedStat(0, (float)this.getValue());
            }
        });
        this.m_142416_((GuiEventListener)new ForgeSlider(this.leftPos + 8, this.topPos + 46, 160, 20, DEXTERITY, (Component)Component.m_237119_(), 0.0, this.getAttribute(1), dexterity.getLimited(), true){

            public void m_7691_(double mouseX, double mouseY) {
                super.m_7691_(mouseX, mouseY);
                LevelUPLimitScreen.this.setLimitedStat(1, (float)this.getValue());
            }

            public void m_7212_(double mouseX, double mouseY, double deltaX, double deltaY) {
                super.m_7212_(mouseX, mouseY, deltaX, deltaY);
                LevelUPLimitScreen.this.setLimitedStat(1, (float)this.getValue());
            }
        });
        this.m_142416_((GuiEventListener)new ForgeSlider(this.leftPos + 8, this.topPos + 72, 160, 20, STRENGTH, (Component)Component.m_237119_(), 0.0, this.getAttribute(2), strength.getLimited(), true){

            public void m_7691_(double mouseX, double mouseY) {
                super.m_7691_(mouseX, mouseY);
                LevelUPLimitScreen.this.setLimitedStat(2, (float)this.getValue());
            }

            public void m_7212_(double mouseX, double mouseY, double deltaX, double deltaY) {
                super.m_7212_(mouseX, mouseY, deltaX, deltaY);
                LevelUPLimitScreen.this.setLimitedStat(2, (float)this.getValue());
            }
        });
        this.m_142416_((GuiEventListener)new ForgeSlider(this.leftPos + 8, this.topPos + 100, 160, 20, VITALITY, (Component)Component.m_237119_(), 0.0, this.getAttribute(3), vitality.getLimited(), true){

            public void m_7691_(double mouseX, double mouseY) {
                super.m_7691_(mouseX, mouseY);
                LevelUPLimitScreen.this.setLimitedStat(3, (float)this.getValue());
            }

            public void m_7212_(double mouseX, double mouseY, double deltaX, double deltaY) {
                super.m_7212_(mouseX, mouseY, deltaX, deltaY);
                LevelUPLimitScreen.this.setLimitedStat(3, (float)this.getValue());
            }
        });
        this.m_142416_((GuiEventListener)new ForgeSlider(this.leftPos + 8, this.topPos + 128, 160, 20, ENDURANCE, (Component)Component.m_237119_(), 0.0, this.getAttribute(4), endurance.getLimited(), true){

            public void m_7691_(double mouseX, double mouseY) {
                super.m_7691_(mouseX, mouseY);
                LevelUPLimitScreen.this.setLimitedStat(4, (float)this.getValue());
            }

            public void m_7212_(double mouseX, double mouseY, double deltaX, double deltaY) {
                super.m_7212_(mouseX, mouseY, deltaX, deltaY);
                LevelUPLimitScreen.this.setLimitedStat(4, (float)this.getValue());
            }
        });
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        graphics.m_280218_(GUI_LOCATION, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        graphics.m_280614_(this.f_96547_, TITLE, this.leftPos + 8, this.topPos + 8, 0x404040, false);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    private StatType getStatTypes(int type) {
        StatType[] statTypes = ClientStatData.getStatTypes();
        return statTypes[type];
    }

    private float getAttribute(int type) {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            LocalPlayer player = this.f_96541_.f_91074_;
            return switch (type) {
                case 0 -> (float)player.m_21133_((Attribute)ModAttributes.CONSTITUTION.get());
                case 1 -> (float)player.m_21133_((Attribute)ModAttributes.DEXTERITY.get());
                case 2 -> (float)player.m_21133_((Attribute)ModAttributes.STRENGTH.get());
                case 3 -> (float)player.m_21133_((Attribute)ModAttributes.VITALITY.get());
                case 4 -> (float)player.m_21133_((Attribute)ModAttributes.ENDURANCE.get());
                default -> 0.0f;
            };
        }
        return 0.0f;
    }

    private void setLimitedStat(int type, float amount) {
        ModNetwork.sendToServer(new SetLimitedStatC2SPacket(type, amount));
    }

    public boolean m_7043_() {
        return false;
    }
}

