/*
 * Decompiled with CFR 0.152.
 */
package github.catchaos8.levelup.client.screen;

import github.catchaos8.levelup.attributes.ModAttributes;
import github.catchaos8.levelup.client.ClientStatData;
import github.catchaos8.levelup.client.screen.ClientHooks;
import github.catchaos8.levelup.config.LevelUPClientConfig;
import github.catchaos8.levelup.config.LevelUPCommonConfig;
import github.catchaos8.levelup.lib.StatType;
import github.catchaos8.levelup.networking.ModNetwork;
import github.catchaos8.levelup.networking.packet.IncreaseBaseStatC2SPacket;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import org.jetbrains.annotations.NotNull;

public class LevelUPScreen
extends Screen {
    private static final Component TITLE = Component.m_237115_((String)"gui.levelup.level_gui");
    private static final Component CONSTITUTION = Component.m_237115_((String)"stat.levelup.con");
    private static final Component DEXTERITY = Component.m_237115_((String)"stat.levelup.dex");
    private static final Component STRENGTH = Component.m_237115_((String)"stat.levelup.str");
    private static final Component VITALITY = Component.m_237115_((String)"stat.levelup.vit");
    private static final Component ENDURANCE = Component.m_237115_((String)"stat.levelup.end");
    private static final Component FREEPOINTS = Component.m_237115_((String)"stat.levelup.fp");
    private static final Component PLUS = Component.m_237115_((String)"gui.levelup.plus");
    private static final Component MINUS = Component.m_237115_((String)"gui.levelup.minus");
    private static final Component INFO = Component.m_237115_((String)"gui.levelup.info");
    private static final Component LIMIT = Component.m_237115_((String)"gui.levelup.limit");
    private static final ResourceLocation GUI_LOCATION = new ResourceLocation("levelup", "textures/gui/container/levelup_gui.png");
    private static final ResourceLocation XP_BAR_BG = new ResourceLocation("levelup", "textures/gui/sprites/levelup/experience_bar_background.png");
    private static final ResourceLocation XP_BAR_FULL = new ResourceLocation("levelup", "textures/gui/sprites/levelup/experience_bar_progress.png");
    private static final int increase_button_x = 158;
    private static final int info_button_x = 8;
    private static final int text_x = 28;
    private final int imageWidth;
    private final int imageHeight;
    private int leftPos;
    private int topPos;
    private Button constitutionInfo;
    private Button dexterityInfo;
    private Button strengthInfo;
    private Button vitalityInfo;
    private Button enduranceInfo;

    public LevelUPScreen() {
        super(TITLE);
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        if (this.f_96541_ == null) {
            return;
        }
        ClientLevel level = this.f_96541_.f_91073_;
        if (level == null) {
            return;
        }
        this.m_142416_((GuiEventListener)ImageButton.m_253074_((Component)PLUS, this::handleConButton).m_252987_(this.leftPos + 158, this.topPos + 38, 10, 10).m_253136_());
        this.m_142416_((GuiEventListener)ImageButton.m_253074_((Component)PLUS, this::handleDexButton).m_252987_(this.leftPos + 158, this.topPos + 58, 10, 10).m_253136_());
        this.m_142416_((GuiEventListener)ImageButton.m_253074_((Component)PLUS, this::handleStrButton).m_252987_(this.leftPos + 158, this.topPos + 78, 10, 10).m_253136_());
        this.m_142416_((GuiEventListener)ImageButton.m_253074_((Component)PLUS, this::handleVitButton).m_252987_(this.leftPos + 158, this.topPos + 98, 10, 10).m_253136_());
        this.m_142416_((GuiEventListener)ImageButton.m_253074_((Component)PLUS, this::handleEndButton).m_252987_(this.leftPos + 158, this.topPos + 118, 10, 10).m_253136_());
        this.m_142416_((GuiEventListener)ImageButton.m_253074_((Component)LIMIT, this::handleLimitButton).m_252987_(this.leftPos + 108, this.topPos + 137, 60, 12).m_253136_());
        LocalPlayer player = this.f_96541_.f_91074_;
        assert (player != null);
        this.constitutionInfo = (Button)this.m_169394_((Renderable)ImageButton.m_253074_((Component)INFO, this::handleInfoButton).m_252987_(this.leftPos + 8, this.topPos + 38, 12, 12).m_257505_(Tooltip.m_257550_((Component)Component.m_237119_())).m_253136_());
        this.dexterityInfo = (Button)this.m_169394_((Renderable)ImageButton.m_253074_((Component)INFO, this::handleInfoButton).m_252987_(this.leftPos + 8, this.topPos + 58, 12, 12).m_257505_(Tooltip.m_257550_((Component)Component.m_237119_())).m_253136_());
        this.strengthInfo = (Button)this.m_169394_((Renderable)ImageButton.m_253074_((Component)INFO, this::handleInfoButton).m_252987_(this.leftPos + 8, this.topPos + 78, 12, 12).m_257505_(Tooltip.m_257550_((Component)Component.m_237119_())).m_253136_());
        this.vitalityInfo = (Button)this.m_169394_((Renderable)ImageButton.m_253074_((Component)INFO, this::handleInfoButton).m_252987_(this.leftPos + 8, this.topPos + 98, 12, 12).m_257505_(Tooltip.m_257550_((Component)Component.m_237119_())).m_253136_());
        this.enduranceInfo = (Button)this.m_169394_((Renderable)ImageButton.m_253074_((Component)INFO, this::handleInfoButton).m_252987_(this.leftPos + 8, this.topPos + 118, 12, 12).m_257505_(Tooltip.m_257550_((Component)Component.m_237119_())).m_253136_());
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        graphics.m_280218_(GUI_LOCATION, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        assert (this.f_96541_ != null);
        LocalPlayer player = this.f_96541_.f_91074_;
        assert (player != null);
        StatType constitution = this.getStat(0);
        StatType dexterity = this.getStat(1);
        StatType strength = this.getStat(2);
        StatType vitality = this.getStat(3);
        StatType endurance = this.getStat(4);
        this.drawXpBar(graphics, this.imageWidth - 14);
        graphics.m_280056_(this.f_96547_, CONSTITUTION.getString() + "%.0f".formatted(Float.valueOf((float)player.m_21133_((Attribute)ModAttributes.CONSTITUTION.get()))), this.leftPos + 28, this.topPos + 40, 0x404040, false);
        graphics.m_280056_(this.f_96547_, DEXTERITY.getString() + "%.0f".formatted(Float.valueOf((float)player.m_21133_((Attribute)ModAttributes.DEXTERITY.get()))), this.leftPos + 28, this.topPos + 60, 0x404040, false);
        graphics.m_280056_(this.f_96547_, STRENGTH.getString() + "%.0f".formatted(Float.valueOf((float)player.m_21133_((Attribute)ModAttributes.STRENGTH.get()))), this.leftPos + 28, this.topPos + 80, 0x404040, false);
        graphics.m_280056_(this.f_96547_, VITALITY.getString() + "%.0f".formatted(Float.valueOf((float)player.m_21133_((Attribute)ModAttributes.VITALITY.get()))), this.leftPos + 28, this.topPos + 100, 0x404040, false);
        graphics.m_280056_(this.f_96547_, ENDURANCE.getString() + "%.0f".formatted(Float.valueOf((float)player.m_21133_((Attribute)ModAttributes.ENDURANCE.get()))), this.leftPos + 28, this.topPos + 120, 0x404040, false);
        graphics.m_280056_(this.f_96547_, FREEPOINTS.getString() + "%.2f".formatted(Float.valueOf(this.getInfo(0))), this.leftPos + 8, this.topPos + 140, 0x404040, false);
        MutableComponent DO_HP = Component.m_237119_();
        MutableComponent DO_FALL = Component.m_237119_();
        MutableComponent CON_INFO = Component.m_237115_((String)"gui.levelup.con_description").m_130946_(String.valueOf((float)player.m_21133_((Attribute)ModAttributes.CONSTITUTION.get()))).m_7220_((Component)Component.m_237115_((String)"gui.levelup.newline")).m_7220_((Component)Component.m_237115_((String)"gui.levelup.base")).m_130946_(String.valueOf(constitution.getBase())).m_7220_((Component)Component.m_237115_((String)"gui.levelup.newline")).m_7220_((Component)Component.m_237115_((String)"gui.levelup.items")).m_130946_(String.valueOf((float)player.m_21133_((Attribute)ModAttributes.CONSTITUTION.get()) - constitution.getBase())).m_7220_((Component)Component.m_237115_((String)"gui.levelup.newline")).m_7220_((Component)Component.m_237115_((String)"gui.levelup.line"));
        if (((Boolean)LevelUPCommonConfig.DO_HP.get()).booleanValue()) {
            DO_HP = Component.m_237115_((String)"gui.levelup.newline").m_130946_(PLUS.getString() + (Double)LevelUPCommonConfig.CONSTITUTION_HP.get() * 100.0 * (double)constitution.getLimited() + Component.m_237115_((String)"gui.levelup.percent_hp").getString());
        } else if (((Boolean)LevelUPClientConfig.DISPLAY_DISABLED_STAT_INCREASE.get()).booleanValue()) {
            DO_HP = Component.m_237115_((String)"gui.levelup.newline").m_130946_(PLUS.getString() + (Double)LevelUPCommonConfig.CONSTITUTION_HP.get() * 100.0 * (double)constitution.getLimited() + Component.m_237115_((String)"gui.levelup.percent_hp").getString()).m_130940_(ChatFormatting.RED);
        }
        if (((Boolean)LevelUPCommonConfig.DO_FALL_DAMAGE_REDUCTION.get()).booleanValue()) {
            DO_FALL = Component.m_237115_((String)"gui.levelup.newline").m_130946_(PLUS.getString() + (Double)LevelUPCommonConfig.CONSTITUTION_FALL_DAMAGE_REDUCTION.get() * (double)constitution.getLimited() + Component.m_237115_((String)"gui.levelup.max_fall_height").getString());
        } else if (((Boolean)LevelUPClientConfig.DISPLAY_DISABLED_STAT_INCREASE.get()).booleanValue()) {
            DO_FALL = Component.m_237115_((String)"gui.levelup.newline").m_130946_(PLUS.getString() + (Double)LevelUPCommonConfig.CONSTITUTION_FALL_DAMAGE_REDUCTION.get() * (double)constitution.getLimited() + Component.m_237115_((String)"gui.levelup.max_fall_height").getString()).m_130940_(ChatFormatting.RED);
        }
        CON_INFO.m_7220_((Component)DO_HP).m_7220_((Component)DO_FALL);
        this.constitutionInfo.m_257544_(Tooltip.m_257550_((Component)CON_INFO));
        MutableComponent DEX_INFO = Component.m_237115_((String)"gui.levelup.dex_description").m_130946_(String.valueOf((float)player.m_21133_((Attribute)ModAttributes.DEXTERITY.get()))).m_7220_((Component)Component.m_237115_((String)"gui.levelup.newline")).m_7220_((Component)Component.m_237115_((String)"gui.levelup.base")).m_130946_(String.valueOf(dexterity.getBase())).m_7220_((Component)Component.m_237115_((String)"gui.levelup.newline")).m_7220_((Component)Component.m_237115_((String)"gui.levelup.items")).m_130946_(String.valueOf((float)player.m_21133_((Attribute)ModAttributes.DEXTERITY.get()) - dexterity.getBase())).m_7220_((Component)Component.m_237115_((String)"gui.levelup.newline")).m_7220_((Component)Component.m_237115_((String)"gui.levelup.line"));
        MutableComponent DO_SPEED = Component.m_237119_();
        MutableComponent DO_ATTACK_SPEED = Component.m_237119_();
        MutableComponent DO_SWIM_SPEED = Component.m_237119_();
        if (((Boolean)LevelUPCommonConfig.DO_SPEED.get()).booleanValue()) {
            DO_SPEED = Component.m_237115_((String)"gui.levelup.newline").m_130946_(PLUS.getString() + (Double)LevelUPCommonConfig.DEXTERITY_SPEED.get() * 100.0 * (double)dexterity.getLimited() + Component.m_237115_((String)"gui.levelup.speed").getString());
        } else if (((Boolean)LevelUPClientConfig.DISPLAY_DISABLED_STAT_INCREASE.get()).booleanValue()) {
            DO_SPEED = Component.m_237115_((String)"gui.levelup.newline").m_130946_(PLUS.getString() + (Double)LevelUPCommonConfig.DEXTERITY_SPEED.get() * 100.0 * (double)dexterity.getLimited() + Component.m_237115_((String)"gui.levelup.speed").getString()).m_130940_(ChatFormatting.RED);
        }
        if (((Boolean)LevelUPCommonConfig.DO_ATTACK_SPEED.get()).booleanValue()) {
            DO_ATTACK_SPEED = Component.m_237115_((String)"gui.levelup.newline").m_130946_(PLUS.getString() + (Double)LevelUPCommonConfig.DEXTERITY_ATTACK_SPEED.get() * 100.0 * (double)dexterity.getLimited() + Component.m_237115_((String)"gui.levelup.attack_speed").getString());
        } else if (((Boolean)LevelUPClientConfig.DISPLAY_DISABLED_STAT_INCREASE.get()).booleanValue()) {
            DO_ATTACK_SPEED = Component.m_237115_((String)"gui.levelup.newline").m_130946_(PLUS.getString() + (Double)LevelUPCommonConfig.DEXTERITY_ATTACK_SPEED.get() * 100.0 * (double)dexterity.getLimited() + Component.m_237115_((String)"gui.levelup.attack_speed").getString()).m_130940_(ChatFormatting.RED);
        }
        if (((Boolean)LevelUPCommonConfig.DO_SWIM_SPEED.get()).booleanValue()) {
            DO_SWIM_SPEED = Component.m_237115_((String)"gui.levelup.newline").m_130946_(PLUS.getString() + (Double)LevelUPCommonConfig.DEXTERITY_SWIM_SPEED.get() * 100.0 * (double)dexterity.getLimited() + Component.m_237115_((String)"gui.levelup.swim_speed").getString());
        } else if (((Boolean)LevelUPClientConfig.DISPLAY_DISABLED_STAT_INCREASE.get()).booleanValue()) {
            DO_SWIM_SPEED = Component.m_237115_((String)"gui.levelup.newline").m_130946_(PLUS.getString() + (Double)LevelUPCommonConfig.DEXTERITY_SWIM_SPEED.get() * 100.0 * (double)dexterity.getLimited() + Component.m_237115_((String)"gui.levelup.swim_speed").getString()).m_130940_(ChatFormatting.RED);
        }
        DEX_INFO.m_7220_((Component)DO_SPEED).m_7220_((Component)DO_ATTACK_SPEED).m_7220_((Component)DO_SWIM_SPEED);
        this.dexterityInfo.m_257544_(Tooltip.m_257550_((Component)DEX_INFO));
        MutableComponent STR_INFO = Component.m_237115_((String)"gui.levelup.str_description").m_130946_(String.valueOf((float)player.m_21133_((Attribute)ModAttributes.STRENGTH.get()))).m_7220_((Component)Component.m_237115_((String)"gui.levelup.newline")).m_7220_((Component)Component.m_237115_((String)"gui.levelup.base")).m_130946_(String.valueOf(strength.getBase())).m_7220_((Component)Component.m_237115_((String)"gui.levelup.newline")).m_7220_((Component)Component.m_237115_((String)"gui.levelup.items")).m_130946_(String.valueOf((float)player.m_21133_((Attribute)ModAttributes.STRENGTH.get()) - strength.getBase())).m_7220_((Component)Component.m_237115_((String)"gui.levelup.newline")).m_7220_((Component)Component.m_237115_((String)"gui.levelup.line"));
        MutableComponent DO_DAMAGE = Component.m_237119_();
        MutableComponent DO_KNOCKBACK = Component.m_237119_();
        if (((Boolean)LevelUPCommonConfig.DO_DAMAGE.get()).booleanValue()) {
            DO_DAMAGE = Component.m_237115_((String)"gui.levelup.newline").m_130946_(PLUS.getString() + (Double)LevelUPCommonConfig.STRENGTH_DAMAGE.get() * 100.0 * (double)strength.getLimited() + Component.m_237115_((String)"gui.levelup.damage").getString());
        } else if (((Boolean)LevelUPClientConfig.DISPLAY_DISABLED_STAT_INCREASE.get()).booleanValue()) {
            DO_DAMAGE = Component.m_237115_((String)"gui.levelup.newline").m_130946_(PLUS.getString() + (Double)LevelUPCommonConfig.STRENGTH_DAMAGE.get() * 100.0 * (double)strength.getLimited() + Component.m_237115_((String)"gui.levelup.damage").getString()).m_130940_(ChatFormatting.RED);
        }
        if (((Boolean)LevelUPCommonConfig.DO_KNOCKBACK.get()).booleanValue()) {
            DO_KNOCKBACK = Component.m_237115_((String)"gui.levelup.newline").m_130946_(PLUS.getString() + (Double)LevelUPCommonConfig.STRENGTH_KNOCKBACK.get() * 100.0 * (double)strength.getLimited() + Component.m_237115_((String)"gui.levelup.knockback").getString());
        } else if (((Boolean)LevelUPClientConfig.DISPLAY_DISABLED_STAT_INCREASE.get()).booleanValue()) {
            DO_KNOCKBACK = Component.m_237115_((String)"gui.levelup.newline").m_130946_(PLUS.getString() + (Double)LevelUPCommonConfig.STRENGTH_KNOCKBACK.get() * 100.0 * (double)strength.getLimited() + Component.m_237115_((String)"gui.levelup.knockback").getString()).m_130940_(ChatFormatting.RED);
        }
        STR_INFO.m_7220_((Component)DO_DAMAGE).m_7220_((Component)DO_KNOCKBACK);
        this.strengthInfo.m_257544_(Tooltip.m_257550_((Component)STR_INFO));
        if (this.f_96541_ == null) {
            return;
        }
        ClientLevel level = this.f_96541_.f_91073_;
        if (level == null) {
            return;
        }
        MutableComponent VIT_INFO = Component.m_237115_((String)"gui.levelup.vit_description").m_130946_(String.valueOf((float)player.m_21133_((Attribute)ModAttributes.VITALITY.get()))).m_7220_((Component)Component.m_237115_((String)"gui.levelup.newline")).m_7220_((Component)Component.m_237115_((String)"gui.levelup.base")).m_130946_(String.valueOf(vitality.getBase())).m_7220_((Component)Component.m_237115_((String)"gui.levelup.newline")).m_7220_((Component)Component.m_237115_((String)"gui.levelup.items")).m_130946_(String.valueOf((float)player.m_21133_((Attribute)ModAttributes.VITALITY.get()) - vitality.getBase())).m_7220_((Component)Component.m_237115_((String)"gui.levelup.newline")).m_7220_((Component)Component.m_237115_((String)"gui.levelup.line"));
        MutableComponent DO_HP_REGEN = Component.m_237119_();
        MutableComponent DO_ARMOR = Component.m_237119_();
        if (((Boolean)LevelUPCommonConfig.DO_HP_REGEN.get()).booleanValue()) {
            if (level.m_6106_().m_5466_()) {
                hpRegenThing = Math.round((Double)LevelUPCommonConfig.VITALITY_HP_REGEN.get() * (double)vitality.getLimited() * 20.0 * 1000.0);
                DO_HP_REGEN = Component.m_237115_((String)"gui.levelup.newline").m_130946_(PLUS.getString() + hpRegenThing / 1000.0 / (Double)LevelUPCommonConfig.VITALITY_HARDCORE_NERF.get() + Component.m_237115_((String)"gui.levelup.heal").getString());
            } else {
                hpRegenThing = Math.round((Double)LevelUPCommonConfig.VITALITY_HP_REGEN.get() * (double)vitality.getLimited() * 20.0 * 1000.0);
                DO_HP_REGEN = Component.m_237115_((String)"gui.levelup.newline").m_130946_(PLUS.getString() + hpRegenThing / 1000.0 + Component.m_237115_((String)"gui.levelup.heal").getString());
            }
        } else if (((Boolean)LevelUPClientConfig.DISPLAY_DISABLED_STAT_INCREASE.get()).booleanValue()) {
            if (level.m_6106_().m_5466_()) {
                hpRegenThing = Math.round((Double)LevelUPCommonConfig.VITALITY_HP_REGEN.get() * (double)vitality.getLimited() * 20.0 * 1000.0);
                DO_HP_REGEN = Component.m_237115_((String)"gui.levelup.newline").m_130946_(PLUS.getString() + hpRegenThing / 1000.0 / (Double)LevelUPCommonConfig.VITALITY_HARDCORE_NERF.get() + Component.m_237115_((String)"gui.levelup.heal").getString()).m_130940_(ChatFormatting.RED);
            } else {
                hpRegenThing = Math.round((Double)LevelUPCommonConfig.VITALITY_HP_REGEN.get() * (double)vitality.getLimited() * 20.0 * 1000.0);
                DO_HP_REGEN = Component.m_237115_((String)"gui.levelup.newline").m_130946_(PLUS.getString() + hpRegenThing / 1000.0 + Component.m_237115_((String)"gui.levelup.heal").getString()).m_130940_(ChatFormatting.RED);
            }
        }
        if (((Boolean)LevelUPCommonConfig.DO_ARMOR.get()).booleanValue()) {
            DO_ARMOR = Component.m_237115_((String)"gui.levelup.newline").m_130946_(PLUS.getString() + (Double)LevelUPCommonConfig.VITALITY_ARMOR.get() * 100.0 * (double)vitality.getLimited() + Component.m_237115_((String)"gui.levelup.armor").getString());
        } else if (((Boolean)LevelUPClientConfig.DISPLAY_DISABLED_STAT_INCREASE.get()).booleanValue()) {
            DO_ARMOR = Component.m_237115_((String)"gui.levelup.newline").m_130946_(PLUS.getString() + (Double)LevelUPCommonConfig.VITALITY_ARMOR.get() * 100.0 * (double)vitality.getLimited() + Component.m_237115_((String)"gui.levelup.armor").getString()).m_130940_(ChatFormatting.RED);
        }
        VIT_INFO.m_7220_((Component)DO_HP_REGEN).m_7220_((Component)DO_ARMOR);
        this.vitalityInfo.m_257544_(Tooltip.m_257550_((Component)VIT_INFO));
        MutableComponent DO_ARMOR_TOUGHNESS = Component.m_237119_();
        MutableComponent DO_KB_RES = Component.m_237119_();
        MutableComponent DO_HUNGER = Component.m_237119_();
        MutableComponent END_INFO = Component.m_237115_((String)"gui.levelup.end_description").m_130946_(String.valueOf((float)player.m_21133_((Attribute)ModAttributes.ENDURANCE.get()))).m_7220_((Component)Component.m_237115_((String)"gui.levelup.newline")).m_7220_((Component)Component.m_237115_((String)"gui.levelup.base")).m_130946_(String.valueOf(endurance.getBase())).m_7220_((Component)Component.m_237115_((String)"gui.levelup.newline")).m_7220_((Component)Component.m_237115_((String)"gui.levelup.items")).m_130946_(String.valueOf((float)player.m_21133_((Attribute)ModAttributes.ENDURANCE.get()) - endurance.getBase())).m_7220_((Component)Component.m_237115_((String)"gui.levelup.newline")).m_7220_((Component)Component.m_237115_((String)"gui.levelup.line"));
        if (((Boolean)LevelUPCommonConfig.DO_ARMOR_TOUGHNESS.get()).booleanValue()) {
            armorThoughnessThing = Math.round((Double)LevelUPCommonConfig.ENDURANCE_ARMOR_TOUGHNESS.get() * (double)endurance.getLimited() * 1000.0);
            DO_ARMOR_TOUGHNESS = Component.m_237115_((String)"gui.levelup.newline").m_130946_(PLUS.getString() + armorThoughnessThing / 1000.0 + Component.m_237115_((String)"gui.levelup.toughness").getString());
        } else if (((Boolean)LevelUPClientConfig.DISPLAY_DISABLED_STAT_INCREASE.get()).booleanValue()) {
            armorThoughnessThing = Math.round((Double)LevelUPCommonConfig.ENDURANCE_ARMOR_TOUGHNESS.get() * (double)endurance.getLimited() * 1000.0);
            DO_ARMOR_TOUGHNESS = Component.m_237115_((String)"gui.levelup.newline").m_130946_(PLUS.getString() + armorThoughnessThing / 1000.0 + Component.m_237115_((String)"gui.levelup.toughness").getString()).m_130940_(ChatFormatting.RED);
        }
        if (((Boolean)LevelUPCommonConfig.DO_KB_RES.get()).booleanValue()) {
            DO_KB_RES = Component.m_237115_((String)"gui.levelup.newline").m_130946_(PLUS.getString() + (Double)LevelUPCommonConfig.ENDURANCE_KNOCKBACK_RESISTANCE.get() * 100.0 * (double)endurance.getLimited() + Component.m_237115_((String)"gui.levelup.knockback_resistance").getString());
        } else if (((Boolean)LevelUPClientConfig.DISPLAY_DISABLED_STAT_INCREASE.get()).booleanValue()) {
            DO_KB_RES = Component.m_237115_((String)"gui.levelup.newline").m_130946_(PLUS.getString() + (Double)LevelUPCommonConfig.ENDURANCE_KNOCKBACK_RESISTANCE.get() * 100.0 * (double)endurance.getLimited() + Component.m_237115_((String)"gui.levelup.knockback_resistance").getString()).m_130940_(ChatFormatting.RED);
        }
        if (((Boolean)LevelUPCommonConfig.DO_HUNGER.get()).booleanValue()) {
            hungerThing = Math.round((100.0 - Math.pow(1.0 - (Double)LevelUPCommonConfig.ENDURANCE_HUNGER.get(), endurance.getLimited()) * 100.0) * 1000.0);
            DO_HUNGER = Component.m_237115_((String)"gui.levelup.newline").m_130946_(MINUS.getString() + hungerThing / 1000.0 + Component.m_237115_((String)"gui.levelup.hunger").getString());
        } else if (((Boolean)LevelUPClientConfig.DISPLAY_DISABLED_STAT_INCREASE.get()).booleanValue()) {
            hungerThing = Math.round((100.0 - Math.pow(1.0 - (Double)LevelUPCommonConfig.ENDURANCE_HUNGER.get(), endurance.getLimited()) * 100.0) * 1000.0);
            DO_HUNGER = Component.m_237115_((String)"gui.levelup.newline").m_130946_(MINUS.getString() + hungerThing / 1000.0 + Component.m_237115_((String)"gui.levelup.hunger").getString()).m_130940_(ChatFormatting.RED);
        }
        END_INFO.m_7220_((Component)DO_ARMOR_TOUGHNESS).m_7220_((Component)DO_KB_RES).m_7220_((Component)DO_HUNGER);
        this.enduranceInfo.m_257544_(Tooltip.m_257550_((Component)END_INFO));
    }

    private void handleConButton(Button increase) {
        ModNetwork.sendToServer(new IncreaseBaseStatC2SPacket(0, 1.0f));
    }

    private void handleDexButton(Button increase) {
        ModNetwork.sendToServer(new IncreaseBaseStatC2SPacket(1, 1.0f));
    }

    private void handleStrButton(Button increase) {
        ModNetwork.sendToServer(new IncreaseBaseStatC2SPacket(2, 1.0f));
    }

    private void handleVitButton(Button increase) {
        ModNetwork.sendToServer(new IncreaseBaseStatC2SPacket(3, 1.0f));
    }

    private void handleEndButton(Button increase) {
        ModNetwork.sendToServer(new IncreaseBaseStatC2SPacket(4, 1.0f));
    }

    private void handleLimitButton(Button button) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> ClientHooks::openLevelUPLimitGUI);
    }

    private void handleInfoButton(Button info) {
    }

    private float getInfo(int type) {
        float[] info = ClientStatData.getPlayerInfo();
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            return info[type];
        }
        return 0.0f;
    }

    private StatType getStat(int type) {
        StatType[] statTypes = ClientStatData.getStatTypes();
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            return statTypes[type];
        }
        return new StatType(0.0f, 0.0f, "Null");
    }

    private void drawXpBar(@NotNull GuiGraphics graphics, int width) {
        float currentXp = this.getInfo(1);
        float level = this.getInfo(2);
        int maxXp = (int)((Double)LevelUPCommonConfig.A_VALUE.get() * (double)(level * level) + (Double)LevelUPCommonConfig.B_VALUE.get() * (double)level + (Double)LevelUPCommonConfig.C_VALUE.get());
        int filledWidth = (int)(currentXp / (float)maxXp * (float)width);
        int adjustedX = 7 + this.leftPos;
        int adjustedY = 20 + this.topPos;
        graphics.m_280163_(XP_BAR_BG, adjustedX, adjustedY - 10, 0.0f, 0.0f, width, 5, 162, 5);
        graphics.m_280163_(XP_BAR_FULL, adjustedX, adjustedY - 10, 0.0f, 0.0f, filledWidth, 5, 162, 5);
        graphics.m_280056_(this.f_96547_, "Level %.0f - XP: %.0f / %d".formatted(Float.valueOf(level), Float.valueOf(currentXp), maxXp), adjustedX + width / 2 - this.f_96547_.m_92895_("Level %.0f - XP: %.0f / %d".formatted(Float.valueOf(level), Float.valueOf(currentXp), maxXp)) / 2, adjustedY, 0x404040, false);
    }

    public boolean m_7043_() {
        return false;
    }
}

