/*
 * Decompiled with CFR 0.152.
 */
package github.catchaos8.levelup.mixin;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import github.catchaos8.levelup.lib.SetStats;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public class ItemStackAttributeMods {
    @Inject(method={"getAttributeModifiers"}, at={@At(value="RETURN")}, cancellable=true)
    private void addCustomAttributes(EquipmentSlot slot, CallbackInfoReturnable<Multimap<Attribute, AttributeModifier>> cir) {
        ItemStack item = (ItemStack)this;
        Multimap original = (Multimap)cir.getReturnValue();
        HashMultimap modifiers = HashMultimap.create((Multimap)original);
        Item item2 = item.m_41720_();
        if (item2 instanceof ArmorItem) {
            int uuidSuffix;
            ArmorItem armor = (ArmorItem)item2;
            switch (armor.m_40402_()) {
                case HEAD: {
                    int n = 1;
                    break;
                }
                case CHEST: {
                    int n = 2;
                    break;
                }
                case LEGS: {
                    int n = 3;
                    break;
                }
                case FEET: {
                    int n = 4;
                    break;
                }
                default: {
                    int n = uuidSuffix = 0;
                }
            }
            if (armor.m_40402_() == slot) {
                SetStats.applyEnchantModifiers((Multimap<Attribute, AttributeModifier>)modifiers, item, uuidSuffix);
            }
        } else if ((item.m_41720_() instanceof SwordItem || item.m_41720_() instanceof AxeItem) && slot == EquipmentSlot.MAINHAND) {
            int uuidSuffix = item.m_41720_() instanceof SwordItem ? 5 : 6;
            SetStats.applyEnchantModifiers((Multimap<Attribute, AttributeModifier>)modifiers, item, uuidSuffix);
        }
        cir.setReturnValue((Object)modifiers);
    }
}

