/*
 * Decompiled with CFR 0.152.
 */
package github.catchaos8.levelup.networking.packet;

import github.catchaos8.levelup.attributes.ModAttributes;
import github.catchaos8.levelup.config.LevelUPCommonConfig;
import github.catchaos8.levelup.lib.SetStats;
import github.catchaos8.levelup.networking.ModNetwork;
import github.catchaos8.levelup.networking.packet.StatDataSyncS2CPacket;
import github.catchaos8.levelup.stats.PlayerStatsProvider;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraftforge.network.NetworkEvent;

public class IncreaseBaseStatC2SPacket {
    private final int type;
    private final float amount;

    public IncreaseBaseStatC2SPacket(int type, float amount) {
        this.type = Math.max(0, type);
        this.amount = Math.max(0.0f, amount);
    }

    public IncreaseBaseStatC2SPacket(FriendlyByteBuf buf) {
        this.type = buf.readInt();
        this.amount = buf.readFloat();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.type);
        buf.writeFloat(this.amount);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            assert (player != null);
            player.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> {
                if (stats.getInfo(0) >= this.amount && stats.getBaseStat(this.type) < (float)((Integer)LevelUPCommonConfig.STAT_CAP.get()).intValue()) {
                    Attribute attribute;
                    System.out.println("Increasing");
                    stats.addBaseStat(this.type, this.amount);
                    switch (this.type) {
                        case 0: {
                            Attribute attribute2 = (Attribute)ModAttributes.CONSTITUTION.get();
                            break;
                        }
                        case 1: {
                            Attribute attribute2 = (Attribute)ModAttributes.DEXTERITY.get();
                            break;
                        }
                        case 2: {
                            Attribute attribute2 = (Attribute)ModAttributes.STRENGTH.get();
                            break;
                        }
                        case 3: {
                            Attribute attribute2 = (Attribute)ModAttributes.VITALITY.get();
                            break;
                        }
                        case 4: {
                            Attribute attribute2 = (Attribute)ModAttributes.ENDURANCE.get();
                            break;
                        }
                        default: {
                            Attribute attribute2 = attribute = null;
                        }
                    }
                    if (attribute != null && player.m_21133_(attribute) >= (double)stats.getLimitedStat(this.type)) {
                        System.out.println("Increased");
                        stats.addLimitedStat(this.type, this.amount);
                    }
                    stats.subInfo(0, this.amount);
                    SetStats.makeAttributeSingleMod(player, this.type);
                    SetStats.setAttributeStat(stats.getBaseStat(this.type), this.type, player);
                }
                ModNetwork.sendToPlayer(new StatDataSyncS2CPacket(stats.getInfoArr(), stats.getStatsTypeArr()), player);
            });
        });
    }
}

