/*
 * Decompiled with CFR 0.152.
 */
package github.catchaos8.levelup.networking.packet;

import github.catchaos8.levelup.attributes.ModAttributes;
import github.catchaos8.levelup.config.LevelUPCommonConfig;
import github.catchaos8.levelup.lib.DisplayLevelScoreboard;
import github.catchaos8.levelup.lib.SetStats;
import github.catchaos8.levelup.networking.ModNetwork;
import github.catchaos8.levelup.networking.packet.StatDataSyncS2CPacket;
import github.catchaos8.levelup.stats.PlayerStatsProvider;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraftforge.network.NetworkEvent;

public class IncreaseStatC2SPacket {
    private final int type;
    private final int amount;

    public IncreaseStatC2SPacket(int type, int amount) {
        this.type = Math.max(0, Math.min(12, type));
        this.amount = Math.max(0, amount);
    }

    public IncreaseStatC2SPacket(FriendlyByteBuf buf) {
        this.type = buf.readInt();
        this.amount = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.type);
        buf.writeInt(this.amount);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (this.type <= 4) {
                assert (player != null);
                player.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> {
                    if (stats.getStat(5) >= this.amount && stats.getStat(this.type) < (Integer)LevelUPCommonConfig.STAT_CAP.get()) {
                        stats.addStat(this.type, this.amount);
                        if (this.type == 0) {
                            if (player.m_21133_((Attribute)ModAttributes.CONSTITUTION.get()) == (double)stats.getStat(this.type + 8)) {
                                stats.addStat(this.type + 8, this.amount);
                            }
                        } else if (this.type == 1) {
                            if (player.m_21133_((Attribute)ModAttributes.DEXTERITY.get()) == (double)stats.getStat(this.type + 8)) {
                                stats.addStat(this.type + 8, this.amount);
                            }
                        } else if (this.type == 2) {
                            if (player.m_21133_((Attribute)ModAttributes.STRENGTH.get()) == (double)stats.getStat(this.type + 8)) {
                                stats.addStat(this.type + 8, this.amount);
                            }
                        } else if (this.type == 3) {
                            if (player.m_21133_((Attribute)ModAttributes.VITALITY.get()) == (double)stats.getStat(this.type + 8)) {
                                stats.addStat(this.type + 8, this.amount);
                            }
                        } else if (this.type == 4 && player.m_21133_((Attribute)ModAttributes.ENDURANCE.get()) == (double)stats.getStat(this.type + 8)) {
                            stats.addStat(this.type + 8, this.amount);
                        }
                        stats.subStat(5, this.amount);
                        SetStats.makeAttributeMods((ServerPlayer)player, (int)this.type);
                        SetStats.setAttributeStat((int)stats.getStat(this.type), (int)this.type, (ServerPlayer)player);
                    }
                });
            } else if (this.type <= 7) {
                assert (player != null);
                player.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> {
                    if (this.type == 6) {
                        stats.addStat(this.type, this.amount);
                        SetStats.increaseLevel(player);
                    } else {
                        stats.addStat(this.type, this.amount);
                    }
                });
            } else {
                assert (player != null);
                player.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> {
                    stats.setStat(this.type, this.amount);
                    SetStats.makeAttributeMods((ServerPlayer)player, (int)(this.type - 8));
                });
            }
            player.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> {
                ModNetwork.sendToPlayer(new StatDataSyncS2CPacket(stats.getStatArr()), player);
                int level = stats.getStat(7);
                DisplayLevelScoreboard.updateLevel((ServerPlayer)player, (int)level);
            });
        });
    }
}

