/*
 * Decompiled with CFR 0.152.
 */
package github.catchaos8.levelup.networking.packet;

import github.catchaos8.levelup.client.ClientStatData;
import github.catchaos8.levelup.lib.StatType;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class StatDataSyncS2CPacket {
    private float[] info;
    private StatType[] statTypes;

    public StatDataSyncS2CPacket(float[] info, StatType[] statTypes) {
        this.info = info;
        this.statTypes = statTypes;
    }

    public StatDataSyncS2CPacket(FriendlyByteBuf buf) {
        int infoLength = buf.m_130242_();
        this.info = new float[infoLength];
        for (int i = 0; i < infoLength; ++i) {
            this.info[i] = buf.readFloat();
        }
        int statCount = buf.m_130242_();
        this.statTypes = new StatType[statCount];
        for (int i = 0; i < statCount; ++i) {
            float base = buf.readFloat();
            float limited = buf.readFloat();
            String name = buf.m_130277_();
            this.statTypes[i] = new StatType(base, limited, name);
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130130_(this.info.length);
        for (float f : this.info) {
            buf.writeFloat(f);
        }
        buf.m_130130_(this.statTypes.length);
        for (StatType stat : this.statTypes) {
            buf.writeFloat(stat.getBase());
            buf.writeFloat(stat.getLimited());
            buf.m_130070_(stat.getName());
        }
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ClientStatData.setPlayerInfo(this.info);
            ClientStatData.setStatTypes(this.statTypes);
        });
        context.setPacketHandled(true);
    }
}

