/*
 * Decompiled with CFR 0.152.
 */
package github.catchaos8.levelup.lib;

import com.google.common.collect.Multimap;
import github.catchaos8.levelup.attributes.ModAttributes;
import github.catchaos8.levelup.config.LevelUPCommonConfig;
import github.catchaos8.levelup.enchants.ModEnchants;
import github.catchaos8.levelup.lib.DisplayLevelScoreboard;
import github.catchaos8.levelup.stats.PlayerStatsProvider;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.ForgeMod;

public class SetStats {
    private static final Attribute[] ATTRIBUTES = new Attribute[]{(Attribute)ModAttributes.CONSTITUTION.get(), (Attribute)ModAttributes.DEXTERITY.get(), (Attribute)ModAttributes.STRENGTH.get(), (Attribute)ModAttributes.VITALITY.get(), (Attribute)ModAttributes.ENDURANCE.get()};

    public static void setAttributeStat(float amount, int type, ServerPlayer player) {
        UUID uuid = UUID.fromString("d7663cf7-09d3-48a9-9e22-bc0f495a96b8");
        player.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> {
            Attribute attributeType;
            AttributeInstance attributeInstance;
            if (type >= 0 && type < ATTRIBUTES.length && (attributeInstance = player.m_21051_(attributeType = ATTRIBUTES[type])) != null) {
                attributeInstance.m_22100_((double)amount);
            }
        });
    }

    public static void makeAttributeMod(int baseStat, double modifierPerStat, AttributeModifier.Operation attributeModOperation, ServerPlayer player, UUID uuid, Attribute attributeName) {
        player.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> {
            AttributeModifier modifier = new AttributeModifier(uuid, "boost from player stats", modifierPerStat * (double)stats.getLimitedStat(baseStat), attributeModOperation);
            AttributeInstance attribute = player.m_21051_(attributeName);
            if (attribute != null) {
                attribute.m_22120_(uuid);
                attribute.m_22125_(modifier);
            }
        });
    }

    public static void increaseLevel(ServerPlayer player) {
        player.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> {
            float xp = stats.getInfo(1);
            float level = stats.getInfo(2);
            int xpNeeded = (int)((Double)LevelUPCommonConfig.A_VALUE.get() * Math.pow(level, (Double)LevelUPCommonConfig.D_VALUE.get()) + (Double)LevelUPCommonConfig.B_VALUE.get() * (double)level + (Double)LevelUPCommonConfig.C_VALUE.get());
            double freepointsGiven = (Double)LevelUPCommonConfig.FREEPOINTS_PER_LEVEL.get();
            int maxLevel = (Integer)LevelUPCommonConfig.LEVEL_CAP.get();
            if (xp >= (float)xpNeeded && level < (float)maxLevel) {
                stats.addInfo(2, 1.0f);
                stats.subInfo(1, xpNeeded);
                stats.addInfo(0, (float)freepointsGiven);
                MutableComponent msg1 = Component.m_237115_((String)"text.levelup.levelupmsg.1");
                MutableComponent msg2 = Component.m_237115_((String)"text.levelup.levelupmsg.2");
                MutableComponent msg = Component.m_237113_((String)(msg1.getString() + (int)(level + 1.0f) + msg2.getString()));
                player.m_213846_((Component)msg);
                xp = stats.getInfo(1);
                level = stats.getInfo(2);
                xpNeeded = (int)(0.2 * (double)(level * level) + 0.25 * (double)level + 10.0);
                DisplayLevelScoreboard.updateLevel(player, level);
                if (xp >= (float)xpNeeded) {
                    SetStats.increaseLevel(player);
                }
            }
        });
    }

    public static void makeAttributeSingleMod(ServerPlayer player, int type) {
        UUID STATS_MOD_UUID = UUID.fromString("d7663cf7-09d3-48a9-9e22-bc0f495a96b8");
        if ((type == 0 || type == 99) && ((Boolean)LevelUPCommonConfig.DO_HP.get()).booleanValue()) {
            SetStats.makeAttributeMod(type, (Double)LevelUPCommonConfig.CONSTITUTION_HP.get(), AttributeModifier.Operation.MULTIPLY_BASE, player, STATS_MOD_UUID, Attributes.f_22276_);
        }
        if (type == 1 || type == 99) {
            if (((Boolean)LevelUPCommonConfig.DO_SPEED.get()).booleanValue()) {
                SetStats.makeAttributeMod(type, (Double)LevelUPCommonConfig.DEXTERITY_SPEED.get(), AttributeModifier.Operation.MULTIPLY_BASE, player, STATS_MOD_UUID, Attributes.f_22279_);
            }
            if (((Boolean)LevelUPCommonConfig.DO_ATTACK_SPEED.get()).booleanValue()) {
                SetStats.makeAttributeMod(type, (Double)LevelUPCommonConfig.DEXTERITY_ATTACK_SPEED.get(), AttributeModifier.Operation.MULTIPLY_BASE, player, STATS_MOD_UUID, Attributes.f_22283_);
            }
            if (((Boolean)LevelUPCommonConfig.DO_SWIM_SPEED.get()).booleanValue()) {
                SetStats.makeAttributeMod(type, (Double)LevelUPCommonConfig.DEXTERITY_SWIM_SPEED.get(), AttributeModifier.Operation.MULTIPLY_BASE, player, STATS_MOD_UUID, (Attribute)ForgeMod.SWIM_SPEED.get());
            }
        }
        if (type == 2 || type == 99) {
            if (((Boolean)LevelUPCommonConfig.DO_DAMAGE.get()).booleanValue()) {
                SetStats.makeAttributeMod(type, (Double)LevelUPCommonConfig.STRENGTH_DAMAGE.get(), AttributeModifier.Operation.MULTIPLY_BASE, player, STATS_MOD_UUID, Attributes.f_22281_);
            }
            if (((Boolean)LevelUPCommonConfig.DO_KNOCKBACK.get()).booleanValue()) {
                SetStats.makeAttributeMod(type, (Double)LevelUPCommonConfig.STRENGTH_KNOCKBACK.get(), AttributeModifier.Operation.MULTIPLY_BASE, player, STATS_MOD_UUID, Attributes.f_22282_);
            }
        }
        if (type == 3 || type == 99) {
            // empty if block
        }
        if (type == 4 || type == 99) {
            if (((Boolean)LevelUPCommonConfig.DO_ARMOR_TOUGHNESS.get()).booleanValue()) {
                SetStats.makeAttributeMod(type, (Double)LevelUPCommonConfig.ENDURANCE_ARMOR_TOUGHNESS.get(), AttributeModifier.Operation.ADDITION, player, STATS_MOD_UUID, Attributes.f_22285_);
            }
            if (((Boolean)LevelUPCommonConfig.DO_KB_RES.get()).booleanValue()) {
                SetStats.makeAttributeMod(type, (Double)LevelUPCommonConfig.ENDURANCE_KNOCKBACK_RESISTANCE.get(), AttributeModifier.Operation.MULTIPLY_BASE, player, STATS_MOD_UUID, Attributes.f_22278_);
            }
            if (((Boolean)LevelUPCommonConfig.DO_ARMOR.get()).booleanValue()) {
                SetStats.makeAttributeMod(type, (Double)LevelUPCommonConfig.ENDURANCE_ARMOR.get(), AttributeModifier.Operation.MULTIPLY_BASE, player, STATS_MOD_UUID, Attributes.f_22284_);
            }
        }
    }

    public static void makeAttributeMods(ServerPlayer player) {
        UUID STATS_MOD_UUID = UUID.fromString("d7663cf7-09d3-48a9-9e22-bc0f495a96b8");
        if (((Boolean)LevelUPCommonConfig.DO_HP.get()).booleanValue()) {
            SetStats.makeAttributeMod(0, (Double)LevelUPCommonConfig.CONSTITUTION_HP.get(), AttributeModifier.Operation.MULTIPLY_BASE, player, STATS_MOD_UUID, Attributes.f_22276_);
        }
        if (((Boolean)LevelUPCommonConfig.DO_SPEED.get()).booleanValue()) {
            SetStats.makeAttributeMod(1, (Double)LevelUPCommonConfig.DEXTERITY_SPEED.get(), AttributeModifier.Operation.MULTIPLY_BASE, player, STATS_MOD_UUID, Attributes.f_22279_);
        }
        if (((Boolean)LevelUPCommonConfig.DO_ATTACK_SPEED.get()).booleanValue()) {
            SetStats.makeAttributeMod(1, (Double)LevelUPCommonConfig.DEXTERITY_ATTACK_SPEED.get(), AttributeModifier.Operation.MULTIPLY_BASE, player, STATS_MOD_UUID, Attributes.f_22283_);
        }
        if (((Boolean)LevelUPCommonConfig.DO_SWIM_SPEED.get()).booleanValue()) {
            SetStats.makeAttributeMod(1, (Double)LevelUPCommonConfig.DEXTERITY_SWIM_SPEED.get(), AttributeModifier.Operation.MULTIPLY_BASE, player, STATS_MOD_UUID, (Attribute)ForgeMod.SWIM_SPEED.get());
        }
        if (((Boolean)LevelUPCommonConfig.DO_DAMAGE.get()).booleanValue()) {
            SetStats.makeAttributeMod(2, (Double)LevelUPCommonConfig.STRENGTH_DAMAGE.get(), AttributeModifier.Operation.MULTIPLY_BASE, player, STATS_MOD_UUID, Attributes.f_22281_);
        }
        if (((Boolean)LevelUPCommonConfig.DO_KNOCKBACK.get()).booleanValue()) {
            SetStats.makeAttributeMod(2, (Double)LevelUPCommonConfig.STRENGTH_KNOCKBACK.get(), AttributeModifier.Operation.MULTIPLY_BASE, player, STATS_MOD_UUID, Attributes.f_22282_);
        }
        if (((Boolean)LevelUPCommonConfig.DO_ARMOR_TOUGHNESS.get()).booleanValue()) {
            SetStats.makeAttributeMod(4, (Double)LevelUPCommonConfig.ENDURANCE_ARMOR_TOUGHNESS.get(), AttributeModifier.Operation.ADDITION, player, STATS_MOD_UUID, Attributes.f_22285_);
        }
        if (((Boolean)LevelUPCommonConfig.DO_KB_RES.get()).booleanValue()) {
            SetStats.makeAttributeMod(4, (Double)LevelUPCommonConfig.ENDURANCE_KNOCKBACK_RESISTANCE.get(), AttributeModifier.Operation.MULTIPLY_BASE, player, STATS_MOD_UUID, Attributes.f_22278_);
        }
        if (((Boolean)LevelUPCommonConfig.DO_ARMOR.get()).booleanValue()) {
            SetStats.makeAttributeMod(3, (Double)LevelUPCommonConfig.ENDURANCE_ARMOR.get(), AttributeModifier.Operation.MULTIPLY_BASE, player, STATS_MOD_UUID, Attributes.f_22284_);
        }
    }

    public static double[] getAttributeValues(ItemStack itemStack, Attribute attribute, EquipmentSlot slot) {
        Multimap attributes = itemStack.m_41638_(slot);
        for (Map.Entry entry : attributes.entries()) {
            if (!((Attribute)entry.getKey()).equals(attribute)) continue;
            AttributeModifier.Operation operation = ((AttributeModifier)entry.getValue()).m_22217_();
            double op = 0.0;
            if (operation == AttributeModifier.Operation.ADDITION) {
                op = 0.0;
            } else if (operation == AttributeModifier.Operation.MULTIPLY_BASE) {
                op = 1.0;
            } else if (operation == AttributeModifier.Operation.MULTIPLY_TOTAL) {
                op = 2.0;
            }
            return new double[]{((AttributeModifier)entry.getValue()).m_22218_(), op};
        }
        return new double[]{0.0, 0.0};
    }

    public static void applyEnchantModifiers(Multimap<Attribute, AttributeModifier> modifiers, ItemStack item, int uuidSuffix) {
        Map<Attribute, Integer> attributeLevels = Map.of((Attribute)ModAttributes.CONSTITUTION.get(), EnchantmentHelper.m_44831_((ItemStack)item).getOrDefault(ModEnchants.FORTIFYING.get(), 0), (Attribute)ModAttributes.DEXTERITY.get(), EnchantmentHelper.m_44831_((ItemStack)item).getOrDefault(ModEnchants.REFLEX.get(), 0), (Attribute)ModAttributes.STRENGTH.get(), EnchantmentHelper.m_44831_((ItemStack)item).getOrDefault(ModEnchants.STRENGTHENING.get(), 0), (Attribute)ModAttributes.VITALITY.get(), EnchantmentHelper.m_44831_((ItemStack)item).getOrDefault(ModEnchants.INNER_STRENGTH.get(), 0), (Attribute)ModAttributes.ENDURANCE.get(), EnchantmentHelper.m_44831_((ItemStack)item).getOrDefault(ModEnchants.UNYIELDING.get(), 0));
        for (Map.Entry<Attribute, Integer> entry : attributeLevels.entrySet()) {
            if (entry.getValue() <= 0) continue;
            AttributeModifier modifier = new AttributeModifier(UUID.fromString("2a1f767a-e617-44e9-9922-0000000000" + uuidSuffix), "enchant " + entry.getKey().m_22087_() + " modifier", (double)(entry.getValue() * (Integer)LevelUPCommonConfig.STAT_INCREASE_PER_ENCHANT_LVL.get()), AttributeModifier.Operation.ADDITION);
            modifiers.put((Object)entry.getKey(), (Object)modifier);
        }
    }
}

