/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.jetboom;

import com.tencent.jetboom.command.JetBoomCommand;
import com.tencent.jetboom.command.JetBoomTabCompleter;
import com.tencent.jetboom.listener.PlayerListener;
import com.tencent.jetboom.manager.ConfigManager;
import com.tencent.jetboom.manager.CooldownManager;
import com.tencent.jetboom.manager.ItemManager;
import com.tencent.jetboom.manager.MessageManager;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class JetBoom
extends JavaPlugin {
    private static JetBoom instance;
    private ConfigManager configManager;
    private CooldownManager cooldownManager;
    private ItemManager itemManager;
    private MessageManager messageManager;

    public void onEnable() {
        instance = this;
        this.configManager = new ConfigManager(this);
        this.cooldownManager = new CooldownManager(this);
        this.itemManager = new ItemManager(this.configManager);
        this.messageManager = new MessageManager(this);
        this.getCommand("jetboom").setExecutor((CommandExecutor)new JetBoomCommand(this));
        this.getCommand("jetboom").setTabCompleter((TabCompleter)new JetBoomTabCompleter());
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        this.getLogger().info("JetBoom has been enabled!");
    }

    public void onDisable() {
        this.getLogger().info("JetBoom has been disabled!");
    }

    public void reloadPlugin() {
        this.configManager.reloadConfig();
        this.itemManager.initializeItem();
        this.messageManager.loadMessages();
        this.getLogger().info("JetBoom configuration reloaded.");
    }

    public static JetBoom getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public CooldownManager getCooldownManager() {
        return this.cooldownManager;
    }

    public ItemManager getItemManager() {
        return this.itemManager;
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }
}

