/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.jetboom.listener;

import com.tencent.jetboom.JetBoom;
import com.tencent.jetboom.manager.CooldownManager;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class PlayerListener
implements Listener {
    private final JetBoom plugin;

    public PlayerListener(JetBoom plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (!this.plugin.getItemManager().isThruster(item)) {
            return;
        }
        if (!player.hasPermission("jetboom.use")) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("no-permission", "\u00a7cYou do not have permission to use the JetBoom thruster."));
            return;
        }
        CooldownManager cooldownManager = this.plugin.getCooldownManager();
        if (cooldownManager.isOnCooldown(player)) {
            cooldownManager.sendCooldownMessage(player);
            return;
        }
        double force = this.plugin.getConfigManager().getPropulsionForce();
        Vector direction = player.getLocation().getDirection().multiply(force);
        player.setVelocity(player.getVelocity().add(direction));
        double explosionRadius = this.plugin.getConfigManager().getExplosionRadius();
        player.getWorld().spawnParticle(Particle.EXPLOSION, player.getLocation(), (int)(20.0 * explosionRadius), explosionRadius / 2.0, explosionRadius / 2.0, explosionRadius / 2.0, 0.0);
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_GENERIC_EXPLODE, 1.0f, 1.0f);
        cooldownManager.setCooldown(player, this.plugin.getConfigManager().getCooldownSeconds());
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        if (this.plugin.getItemManager().isThruster(event.getItemInHand())) {
            event.setCancelled(true);
            event.getPlayer().sendMessage(this.plugin.getMessageManager().getMessage("cannot-place", "\u00a7cYou cannot place the JetBoom thruster!"));
        }
    }
}

