/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.jetboom.manager;

import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigManager {
    private final JavaPlugin plugin;
    private FileConfiguration config;

    public ConfigManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.loadConfig();
    }

    private void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.config = this.plugin.getConfig();
    }

    public void reloadConfig() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public double getPropulsionForce() {
        return this.config.getDouble("propulsion-force", 1.5);
    }

    public int getCooldownSeconds() {
        return this.config.getInt("cooldown-seconds", 5);
    }

    public double getExplosionRadius() {
        return this.config.getDouble("explosion-radius", 3.0);
    }

    public String getItemName() {
        return this.config.getString("item-name", "\u00a7bJetBoom Thruster");
    }

    public List<String> getItemLore() {
        return this.config.getStringList("item-lore");
    }

    public int getItemDurability() {
        return this.config.getInt("item-durability", 100);
    }

    public String getLanguage() {
        return this.config.getString("language", "en");
    }
}

