/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.jetboom.manager;

import com.tencent.jetboom.JetBoom;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.entity.Player;

public class CooldownManager {
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private final JetBoom plugin;

    public CooldownManager(JetBoom plugin) {
        this.plugin = plugin;
    }

    public void setCooldown(Player player, int seconds) {
        this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis() + (long)seconds * 1000L);
    }

    public boolean isOnCooldown(Player player) {
        return this.cooldowns.containsKey(player.getUniqueId()) && System.currentTimeMillis() < this.cooldowns.get(player.getUniqueId());
    }

    public long getRemainingCooldown(Player player) {
        if (!this.isOnCooldown(player)) {
            return 0L;
        }
        long millis = this.cooldowns.get(player.getUniqueId()) - System.currentTimeMillis();
        return TimeUnit.MILLISECONDS.toSeconds(millis) + 1L;
    }

    public void sendCooldownMessage(Player player) {
        long remainingTime = this.getRemainingCooldown(player);
        if (remainingTime > 0L) {
            player.sendMessage(this.plugin.getMessageManager().getFormattedMessage("cooldown", "\u00a7cYou must wait {time} seconds before using this again.", "time", String.valueOf(remainingTime)));
        }
    }
}

