/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.jetboom.manager;

import com.tencent.jetboom.manager.ConfigManager;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemManager {
    private final ConfigManager configManager;
    private ItemStack thrusterItem;

    public ItemManager(ConfigManager configManager) {
        this.configManager = configManager;
        this.initializeItem();
    }

    public void initializeItem() {
        this.thrusterItem = new ItemStack(Material.PISTON);
        ItemMeta meta = this.thrusterItem.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(this.configManager.getItemName().replace("&", "\u00a7"));
            List lore = this.configManager.getItemLore().stream().map(line -> line.replace("&", "\u00a7")).collect(Collectors.toList());
            meta.setLore(lore);
            this.thrusterItem.setItemMeta(meta);
        }
    }

    public ItemStack getThrusterItem() {
        return this.thrusterItem.clone();
    }

    public boolean isThruster(ItemStack item) {
        if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasDisplayName()) {
            return false;
        }
        return item.getItemMeta().getDisplayName().equals(this.thrusterItem.getItemMeta().getDisplayName());
    }
}

