/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.jetboom.manager;

import com.tencent.jetboom.JetBoom;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.bukkit.ChatColor;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class MessageManager {
    private final JetBoom plugin;
    private FileConfiguration langConfig;
    private String prefix;

    public MessageManager(JetBoom plugin) {
        this.plugin = plugin;
        this.loadMessages();
    }

    public void loadMessages() {
        String lang = this.plugin.getConfigManager().getLanguage();
        File langFile = new File(this.plugin.getDataFolder(), "lang/" + lang + ".yml");
        if (!langFile.exists()) {
            this.plugin.saveResource("lang/" + lang + ".yml", false);
        }
        this.langConfig = YamlConfiguration.loadConfiguration((File)langFile);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream defStream = this.plugin.getResource("lang/" + lang + ".yml");){
                if (defStream != null) {
                    this.langConfig.setDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defStream, StandardCharsets.UTF_8)));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Could not load language file: " + lang + ".yml");
            e.printStackTrace();
        }
        this.prefix = this.getMessage("prefix", "&8[&bJetBoom&8] &r");
    }

    public String getMessage(String path, String def) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.langConfig.getString(path, def));
    }

    public String getPrefixedMessage(String path, String def) {
        return this.prefix + this.getMessage(path, def);
    }

    public String getFormattedMessage(String path, String def, String ... replacements) {
        String message = this.getMessage(path, def);
        int i = 0;
        while (i < replacements.length) {
            if (i + 1 < replacements.length) {
                message = message.replace("{" + replacements[i] + "}", replacements[i + 1]);
            }
            i += 2;
        }
        return this.prefix + message;
    }
}

