/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.jetboom;

import com.tencent.jetboom.command.JetBoomCommand;
import com.tencent.jetboom.command.JetBoomTabCompleter;
import com.tencent.jetboom.listener.ConnectionListener;
import com.tencent.jetboom.listener.PlayerListener;
import com.tencent.jetboom.manager.ConfigManager;
import com.tencent.jetboom.manager.CooldownManager;
import com.tencent.jetboom.manager.CosmeticManager;
import com.tencent.jetboom.manager.GuiManager;
import com.tencent.jetboom.manager.ItemManager;
import com.tencent.jetboom.manager.MessageManager;
import com.tencent.jetboom.manager.SkinManager;
import java.io.File;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class JetBoom
extends JavaPlugin {
    private static JetBoom instance;
    private ConfigManager configManager;
    private CooldownManager cooldownManager;
    private ItemManager itemManager;
    private MessageManager messageManager;
    private CosmeticManager cosmeticManager;
    private GuiManager guiManager;
    private SkinManager skinManager;

    public void onEnable() {
        instance = this;
        this.saveDefaultLanguageFiles();
        this.configManager = new ConfigManager(this);
        this.messageManager = new MessageManager(this);
        this.cooldownManager = new CooldownManager(this);
        this.itemManager = new ItemManager(this);
        this.cosmeticManager = new CosmeticManager(this);
        this.skinManager = new SkinManager(this);
        this.guiManager = new GuiManager(this);
        this.configManager.loadConfig();
        this.messageManager.loadMessages();
        this.cosmeticManager.loadCosmetics();
        this.skinManager.loadSkins();
        this.getCommand("jetboom").setExecutor((CommandExecutor)new JetBoomCommand(this));
        this.getCommand("jetboom").setTabCompleter((TabCompleter)new JetBoomTabCompleter());
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ConnectionListener(this), (Plugin)this);
        this.getLogger().info("JetBoom has been enabled!");
    }

    public void onDisable() {
        this.getLogger().info("JetBoom has been disabled!");
    }

    private void saveDefaultLanguageFiles() {
        File langFolder = new File(this.getDataFolder(), "lang");
        if (!langFolder.exists()) {
            langFolder.mkdirs();
        }
        this.saveResource("lang/en.yml", false);
        this.saveResource("lang/zh.yml", false);
    }

    public void reloadPlugin() {
        this.configManager.reloadConfig();
        this.itemManager.initializeItem();
        this.messageManager.loadMessages();
        for (Player player : this.getServer().getOnlinePlayers()) {
            this.updatePlayerThrusters(player);
        }
        this.getLogger().info("JetBoom configuration reloaded.");
    }

    public void updatePlayerThrusters(Player player) {
        ItemStack[] contents = player.getInventory().getContents();
        for (int i = 0; i < contents.length; ++i) {
            ItemStack item = contents[i];
            if (item == null || !this.itemManager.isThruster(item)) continue;
            ItemStack updatedItem = this.itemManager.updateThrusterItem(item);
            player.getInventory().setItem(i, updatedItem);
        }
    }

    public static JetBoom getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public CooldownManager getCooldownManager() {
        return this.cooldownManager;
    }

    public ItemManager getItemManager() {
        return this.itemManager;
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    public CosmeticManager getCosmeticManager() {
        return this.cosmeticManager;
    }

    public GuiManager getGuiManager() {
        return this.guiManager;
    }

    public SkinManager getSkinManager() {
        return this.skinManager;
    }
}

