/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.jetboom.command;

import com.tencent.jetboom.JetBoom;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class JetBoomCommand
implements CommandExecutor {
    private final JetBoom plugin;

    public JetBoomCommand(JetBoom plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0 || args.length > 0 && args[0].equalsIgnoreCase("help")) {
            if (sender.hasPermission("jetboom.admin")) {
                sender.sendMessage(this.plugin.getMessageManager().getMessage("help-admin-title", ""));
                sender.sendMessage(this.plugin.getMessageManager().getMessage("help-admin-give", ""));
                sender.sendMessage(this.plugin.getMessageManager().getMessage("help-admin-reload", ""));
                sender.sendMessage(this.plugin.getMessageManager().getMessage("help-admin-repair", ""));
                sender.sendMessage(this.plugin.getMessageManager().getMessage("help-admin-gui", ""));
                sender.sendMessage(this.plugin.getMessageManager().getMessage("help-admin-help", ""));
            } else {
                sender.sendMessage(this.plugin.getMessageManager().getMessage("help-user-title", ""));
                sender.sendMessage(this.plugin.getMessageManager().getMessage("help-user-use", ""));
                sender.sendMessage(this.plugin.getMessageManager().getMessage("help-user-obtain", ""));
                sender.sendMessage(this.plugin.getMessageManager().getMessage("help-user-cooldown", ""));
                sender.sendMessage(this.plugin.getMessageManager().getMessage("help-user-durability", ""));
                sender.sendMessage(this.plugin.getMessageManager().getMessage("help-user-help", ""));
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("gui")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.plugin.getMessageManager().getMessage("player-only", "\u00a7cThis command can only be run by a player."));
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("jetboom.gui")) {
                sender.sendMessage(this.plugin.getMessageManager().getMessage("no-permission", "\u00a7cYou do not have permission to use this command."));
                return true;
            }
            this.plugin.getGuiManager().openMainGui(player);
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (sender.hasPermission("jetboom.reload")) {
                this.plugin.reloadPlugin();
                sender.sendMessage(this.plugin.getMessageManager().getMessage("reloaded", "\u00a7aJetBoom configuration reloaded."));
            } else {
                sender.sendMessage(this.plugin.getMessageManager().getMessage("no-permission", "\u00a7cYou do not have permission to use this command."));
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("give")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                if (player.hasPermission("jetboom.give")) {
                    player.getInventory().addItem(new ItemStack[]{this.plugin.getItemManager().getThrusterItem()});
                    player.sendMessage(this.plugin.getMessageManager().getMessage("give-success", "\u00a7aYou have received a JetBoom Thruster!"));
                } else {
                    sender.sendMessage(this.plugin.getMessageManager().getMessage("no-permission", "\u00a7cYou do not have permission to use this command."));
                }
            } else {
                sender.sendMessage(this.plugin.getMessageManager().getMessage("player-only", "\u00a7cThis command can only be run by a player."));
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("skin")) {
            if (!sender.hasPermission("jetboom.admin")) {
                sender.sendMessage(this.plugin.getMessageManager().getMessage("no-permission", "\u00a7cYou do not have permission to use this command."));
                return true;
            }
            if (args.length < 2) {
                sender.sendMessage(this.plugin.getMessageManager().getMessage("skin-usage", "\u00a7cUsage: /jetboom skin <skin_id>"));
                String availableSkins = String.join((CharSequence)", ", this.plugin.getSkinManager().getAvailableSkinIds());
                sender.sendMessage(this.plugin.getMessageManager().getMessage("available-skins", "\u00a7aAvailable skins: " + availableSkins));
                return true;
            }
            String skinId = args[1].toLowerCase();
            if (!this.plugin.getSkinManager().getAvailableSkinIds().contains(skinId)) {
                sender.sendMessage(this.plugin.getMessageManager().getMessage("skin-not-found", "\u00a7cSkin not found: " + skinId));
                String availableSkins = String.join((CharSequence)", ", this.plugin.getSkinManager().getAvailableSkinIds());
                sender.sendMessage(this.plugin.getMessageManager().getMessage("available-skins", "\u00a7aAvailable skins: " + availableSkins));
                return true;
            }
            this.plugin.getSkinManager().setGlobalSkin(skinId);
            sender.sendMessage(this.plugin.getMessageManager().getMessage("skin-set-success", "\u00a7aGlobal thruster skin set to: " + skinId));
            return true;
        }
        if (args[0].equalsIgnoreCase("repair")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.plugin.getMessageManager().getMessage("player-only", "\u00a7cThis command can only be run by a player."));
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("jetboom.repair")) {
                sender.sendMessage(this.plugin.getMessageManager().getMessage("no-permission", "\u00a7cYou do not have permission to use this command."));
                return true;
            }
            ItemStack itemInHand = player.getInventory().getItemInMainHand();
            if (this.plugin.getItemManager().isBroken(itemInHand)) {
                player.getInventory().setItemInMainHand(this.plugin.getItemManager().getThrusterItem());
                player.sendMessage(this.plugin.getMessageManager().getMessage("repair-success", "\u00a7aYour thruster has been repaired!"));
            } else {
                player.sendMessage(this.plugin.getMessageManager().getMessage("not-broken", "\u00a7cThe item in your hand is not a broken thruster."));
            }
            return true;
        }
        sender.sendMessage(this.plugin.getMessageManager().getMessage("unknown-command", "\u00a7cUnknown command. Use /jetboom help for a list of commands."));
        return true;
    }
}

