/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.jetboom.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.util.StringUtil;

public class JetBoomTabCompleter
implements TabCompleter {
    private static final List<String> ALL_COMMANDS = Arrays.asList("give", "reload", "help", "repair", "gui", "skin");

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            List filteredCommands = ALL_COMMANDS.stream().filter(cmd -> this.hasPermissionForCommand(sender, (String)cmd)).collect(Collectors.toList());
            StringUtil.copyPartialMatches((String)args[0], filteredCommands, completions);
            return completions;
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("skin") && sender.hasPermission("jetboom.admin")) {
            List<String> skinIds = Arrays.asList("default", "firework", "trident", "elytra", "wind_charge", "ender_pearl");
            return (List)StringUtil.copyPartialMatches((String)args[1], skinIds, new ArrayList());
        }
        return null;
    }

    private boolean hasPermissionForCommand(CommandSender sender, String command) {
        switch (command.toLowerCase()) {
            case "give": {
                return sender.hasPermission("jetboom.give");
            }
            case "reload": {
                return sender.hasPermission("jetboom.reload");
            }
            case "repair": {
                return sender.hasPermission("jetboom.repair");
            }
            case "gui": 
            case "skin": {
                return sender.hasPermission("jetboom.admin");
            }
        }
        return true;
    }
}

