/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.jetboom.listener;

import com.tencent.jetboom.JetBoom;
import com.tencent.jetboom.manager.ConfigManager;
import com.tencent.jetboom.manager.CooldownManager;
import com.tencent.jetboom.manager.CosmeticManager;
import com.tencent.jetboom.model.ParticleCosmetic;
import com.tencent.jetboom.model.SoundCosmetic;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class PlayerListener
implements Listener {
    private final JetBoom plugin;

    public PlayerListener(JetBoom plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && (this.plugin.getItemManager().isThruster(item) || this.plugin.getItemManager().isBroken(item))) {
            event.setCancelled(true);
        }
        if (this.plugin.getItemManager().isBroken(item)) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("thruster-broken", "\u00a7cThis thruster is broken and needs to be repaired."));
            return;
        }
        if (!this.plugin.getItemManager().isThruster(item)) {
            return;
        }
        event.setCancelled(true);
        if (!player.hasPermission("jetboom.use")) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("no-permission", "\u00a7cYou do not have permission to use the JetBoom thruster."));
            return;
        }
        CooldownManager cooldownManager = this.plugin.getCooldownManager();
        if (cooldownManager.isOnCooldown(player)) {
            cooldownManager.sendCooldownMessage(player);
            return;
        }
        double force = this.plugin.getConfigManager().getPropulsionForce();
        Vector direction = player.getLocation().getDirection().multiply(force);
        player.setVelocity(player.getVelocity().add(direction));
        this.playEffects(player);
        int cooldownSeconds = this.plugin.getConfigManager().getCooldownSeconds();
        cooldownManager.setCooldown(player, cooldownSeconds);
        player.setCooldown(item.getType(), cooldownSeconds * 20);
        int maxDurability = this.plugin.getConfigManager().getItemDurability();
        if (maxDurability > 0) {
            int currentDurability = this.plugin.getItemManager().getDurability(item);
            int newDurability = currentDurability - 1;
            if (newDurability <= 0) {
                player.getInventory().setItemInMainHand(this.plugin.getItemManager().getBrokenThrusterItem());
                player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
                player.sendMessage(this.plugin.getMessageManager().getMessage("thruster-broke", "\u00a7cYour thruster broke!"));
            } else {
                this.plugin.getItemManager().setDurability(item, newDurability);
            }
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        if (this.plugin.getItemManager().isThruster(event.getItemInHand()) || this.plugin.getItemManager().isBroken(event.getItemInHand())) {
            event.setCancelled(true);
            event.getPlayer().sendMessage(this.plugin.getMessageManager().getMessage("cannot-place", "\u00a7cYou cannot place the JetBoom thruster!"));
        }
    }

    private void playEffects(Player player) {
        double z;
        Optional<SoundCosmetic> soundOpt;
        ConfigManager configManager = this.plugin.getConfigManager();
        CosmeticManager cosmeticManager = this.plugin.getCosmeticManager();
        Particle particle = Particle.FLAME;
        Sound sound = Sound.ENTITY_GENERIC_EXPLODE;
        float volume = 1.0f;
        float pitch = 1.2f;
        Optional<ParticleCosmetic> particleOpt = cosmeticManager.getParticle(configManager.getGlobalParticleId());
        if (particleOpt.isPresent()) {
            try {
                particle = Particle.valueOf((String)particleOpt.get().getParticleName().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid particle name in cosmetics.yml: " + particleOpt.get().getParticleName());
            }
        }
        if ((soundOpt = cosmeticManager.getSound(configManager.getGlobalSoundId())).isPresent()) {
            try {
                SoundCosmetic s = soundOpt.get();
                sound = Sound.valueOf((String)s.getSoundName().toUpperCase());
                volume = s.getVolume();
                pitch = s.getPitch();
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid sound name in cosmetics.yml: " + soundOpt.get().getSoundName());
            }
        }
        Location center = player.getLocation().add(0.0, 1.0, 0.0);
        int particleCount = 150;
        double power = 0.7;
        for (int i = 0; i < particleCount; ++i) {
            double phi = Math.acos(1.0 - 2.0 * ((double)i + 0.5) / (double)particleCount);
            double theta = Math.PI * (1.0 + Math.sqrt(5.0)) * ((double)i + 0.5);
            double x = Math.cos(theta) * Math.sin(phi);
            double y = Math.sin(theta) * Math.sin(phi);
            z = Math.cos(phi);
            center.getWorld().spawnParticle(particle, center, 0, x, y, z, power);
        }
        int ringParticles = 75;
        double ringRadius = configManager.getExplosionRadius();
        Location feetLoc = player.getLocation();
        for (int i = 0; i < ringParticles; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)ringParticles;
            double x = Math.cos(angle) * ringRadius;
            z = Math.sin(angle) * ringRadius;
            Location particleLoc = feetLoc.clone().add(x, 0.1, z);
            feetLoc.getWorld().spawnParticle(Particle.CRIT, particleLoc, 1, 0.0, 0.0, 0.0, 0.0);
        }
        player.getWorld().playSound(player.getLocation(), sound, volume, pitch);
    }
}

