/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.jetboom.manager;

import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigManager {
    private final JavaPlugin plugin;
    private FileConfiguration config;

    public ConfigManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.loadConfig();
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.config = this.plugin.getConfig();
    }

    public void reloadConfig() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public double getPropulsionForce() {
        return this.config.getDouble("propulsion-force", 1.5);
    }

    public int getCooldownSeconds() {
        return this.config.getInt("cooldown-seconds", 5);
    }

    public double getExplosionRadius() {
        return this.config.getDouble("explosion-radius", 3.0);
    }

    public String getCustomItemName() {
        return this.config.getString("item-name", "");
    }

    public List<String> getCustomItemLore() {
        return this.config.getStringList("item-lore");
    }

    public String getCustomBrokenItemName() {
        return this.config.getString("broken-item-name", "");
    }

    public List<String> getCustomBrokenItemLore() {
        return this.config.getStringList("broken-item-lore");
    }

    public int getItemDurability() {
        return this.config.getInt("item-durability", 100);
    }

    public String getLanguage() {
        return this.config.getString("language", "en");
    }

    public String getGlobalParticleId() {
        return this.config.getString("cosmetics.global-particle", "");
    }

    public String getGlobalSoundId() {
        return this.config.getString("cosmetics.global-sound", "");
    }

    public String getGlobalSkinId() {
        return this.config.getString("cosmetics.global-skin", "");
    }

    public void set(String path, Object value) {
        this.config.set(path, value);
    }

    public void saveConfig() {
        this.plugin.saveConfig();
    }
}

