/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.jetboom.manager;

import com.tencent.jetboom.JetBoom;
import com.tencent.jetboom.model.Cosmetic;
import com.tencent.jetboom.model.ParticleCosmetic;
import com.tencent.jetboom.model.SkinCosmetic;
import com.tencent.jetboom.model.SoundCosmetic;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class CosmeticManager {
    private final JetBoom plugin;
    private final Map<String, ParticleCosmetic> particles = new HashMap<String, ParticleCosmetic>();
    private final Map<String, SoundCosmetic> sounds = new HashMap<String, SoundCosmetic>();
    private final Map<String, SkinCosmetic> skins = new HashMap<String, SkinCosmetic>();

    public CosmeticManager(JetBoom plugin) {
        this.plugin = plugin;
        this.loadCosmetics();
    }

    public void loadCosmetics() {
        ConfigurationSection skinSection;
        ConfigurationSection soundSection;
        YamlConfiguration config;
        ConfigurationSection particleSection;
        this.particles.clear();
        this.sounds.clear();
        this.skins.clear();
        File cosmeticsFile = new File(this.plugin.getDataFolder(), "cosmetics.yml");
        if (!cosmeticsFile.exists()) {
            this.plugin.saveResource("cosmetics.yml", false);
        }
        if ((particleSection = (config = YamlConfiguration.loadConfiguration((File)cosmeticsFile)).getConfigurationSection("particles")) != null) {
            for (Object key : particleSection.getKeys(false)) {
                try {
                    String path = "particles." + (String)key;
                    String name = particleSection.getString(path + ".display-name", (String)key);
                    String perm = particleSection.getString(path + ".permission", "jetboom.cosmetic.particle." + (String)key);
                    String particleName = particleSection.getString(path + ".value", "SMOKE").toUpperCase();
                    Particle.valueOf((String)particleName);
                    this.particles.put((String)key, new ParticleCosmetic((String)key, name, perm, particleName));
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getLogger().warning("Invalid particle type in cosmetics.yml for key '" + (String)key + "'. Skipping.");
                }
            }
        }
        if ((soundSection = config.getConfigurationSection("sounds")) != null) {
            for (String key : soundSection.getKeys(false)) {
                try {
                    String path = "sounds." + key;
                    String name = soundSection.getString(path + ".display-name", key);
                    String perm = soundSection.getString(path + ".permission", "jetboom.cosmetic.sound." + key);
                    String soundName = soundSection.getString(path + ".value", "ENTITY_GENERIC_EXPLODE").toUpperCase();
                    float volume = (float)soundSection.getDouble(path + ".volume", 1.0);
                    float pitch = (float)soundSection.getDouble(path + ".pitch", 1.0);
                    Sound.valueOf((String)soundName);
                    this.sounds.put(key, new SoundCosmetic(key, name, perm, soundName, volume, pitch));
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getLogger().warning("Invalid sound type in cosmetics.yml for key '" + key + "'. Skipping.");
                }
            }
        }
        if ((skinSection = config.getConfigurationSection("skins")) != null) {
            for (String key : skinSection.getKeys(false)) {
                try {
                    String path = "skins." + key;
                    String name = skinSection.getString(path + ".display-name", key);
                    String perm = skinSection.getString(path + ".permission", "jetboom.cosmetic.skin." + key);
                    String materialName = skinSection.getString(path + ".value", "PISTON").toUpperCase();
                    Material material = Material.valueOf((String)materialName);
                    this.skins.put(key, new SkinCosmetic(key, name, perm, material));
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getLogger().warning("Invalid material type in cosmetics.yml for skin key '" + key + "'. Skipping.");
                }
            }
        }
        this.plugin.getLogger().info("Loaded " + this.particles.size() + " particles, " + this.sounds.size() + " sounds, and " + this.skins.size() + " skins.");
    }

    private <T extends Cosmetic> Collection<T> getUnlockedCosmetics(Player player, Map<String, T> cosmeticMap) {
        return cosmeticMap.values().stream().filter(cosmetic -> player.hasPermission(cosmetic.getPermission())).collect(Collectors.toList());
    }

    public Collection<ParticleCosmetic> getUnlockedParticles(Player player) {
        return this.getUnlockedCosmetics(player, this.particles);
    }

    public Collection<SoundCosmetic> getUnlockedSounds(Player player) {
        return this.getUnlockedCosmetics(player, this.sounds);
    }

    public Collection<SkinCosmetic> getUnlockedSkins(Player player) {
        return this.getUnlockedCosmetics(player, this.skins);
    }

    public Optional<ParticleCosmetic> getParticle(String id) {
        return Optional.ofNullable(this.particles.get(id));
    }

    public Optional<SoundCosmetic> getSound(String id) {
        return Optional.ofNullable(this.sounds.get(id));
    }

    public Optional<SkinCosmetic> getSkin(String id) {
        return Optional.ofNullable(this.skins.get(id));
    }

    public Collection<ParticleCosmetic> getAllParticles() {
        return this.particles.values();
    }

    public Collection<SoundCosmetic> getAllSounds() {
        return this.sounds.values();
    }

    public Collection<SkinCosmetic> getAllSkins() {
        return this.skins.values();
    }
}

