/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.jetboom.manager;

import com.tencent.jetboom.JetBoom;
import com.tencent.jetboom.manager.ConfigManager;
import com.tencent.jetboom.manager.MessageManager;
import com.tencent.jetboom.manager.SkinManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class GuiManager
implements Listener {
    private final JetBoom plugin;
    private final MessageManager msg;

    public GuiManager(JetBoom plugin) {
        this.plugin = plugin;
        this.msg = plugin.getMessageManager();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void openMainGui(Player player) {
        if (!player.hasPermission("jetboom.admin")) {
            player.sendMessage(this.msg.getMessage("no-permission", ""));
            return;
        }
        this.openAdminSettingsGui(player);
    }

    public void openSkinGui(Player player) {
        if (!player.hasPermission("jetboom.admin")) {
            player.sendMessage(this.msg.getMessage("no-permission", "\u00a7cYou do not have permission."));
            return;
        }
        SkinManager skinManager = this.plugin.getSkinManager();
        Set<String> allSkinIds = skinManager.getAvailableSkinIds();
        int inventorySize = (int)(Math.ceil((double)allSkinIds.size() / 9.0) + 1.0) * 9;
        inventorySize = Math.max(27, Math.min(54, inventorySize));
        Inventory gui = Bukkit.createInventory(null, (int)inventorySize, (String)this.msg.getMessage("gui-skins-title", "\u00a78Skins"));
        String currentSkinId = skinManager.getCurrentSkinId();
        for (String skinId : allSkinIds) {
            SkinManager.SkinData skinData = skinManager.getSkinData(skinId);
            if (skinData == null) continue;
            boolean isSelected = skinData.getId().equals(currentSkinId);
            Material material = skinData.getMaterial();
            String name = (isSelected ? "\u00a7a" : "\u00a7f") + this.msg.getMessage(skinData.getNameKey(), skinData.getId());
            ArrayList<Object> lore = new ArrayList<Object>();
            String description = this.msg.getMessage(skinData.getDescKey(), "");
            if (!description.isEmpty()) {
                lore.add("\u00a77" + description);
                lore.add("");
            }
            lore.add(isSelected ? this.msg.getMessage("gui-selected-lore", "\u00a7aSelected") : this.msg.getMessage("gui-select-lore", "\u00a7eClick to select"));
            ItemStack item = this.createGuiItem(material, name, lore.toArray(new String[0]));
            gui.addItem(new ItemStack[]{item});
        }
        gui.setItem(inventorySize - 9, this.createGuiItem(Material.ARROW, this.msg.getMessage("gui-back", "\u00a7cBack"), new String[0]));
        player.openInventory(gui);
    }

    public void openAdminSettingsGui(Player player) {
        Inventory gui = Bukkit.createInventory(null, (int)36, (String)this.msg.getMessage("gui-admin-title", "\u00a78Admin Settings"));
        ConfigManager cfg = this.plugin.getConfigManager();
        gui.setItem(10, this.createGuiItem(Material.IRON_BOOTS, this.msg.getMessage("gui-admin-force-name", "\u00a7ePropulsion Force"), this.msg.getMessage("gui-admin-force-current", "\u00a77Current: {value}").replace("{value}", String.valueOf(cfg.getPropulsionForce())), this.msg.getMessage("gui-admin-force-lore1", "\u00a7eLeft-click to increase by 0.1"), this.msg.getMessage("gui-admin-force-lore2", "\u00a7eRight-click to decrease by 0.1")));
        gui.setItem(11, this.createGuiItem(Material.CLOCK, this.msg.getMessage("gui-admin-cooldown-name", "\u00a7eCooldown Time"), this.msg.getMessage("gui-admin-cooldown-current", "\u00a77Current: {value}s").replace("{value}", String.valueOf(cfg.getCooldownSeconds())), this.msg.getMessage("gui-admin-cooldown-lore1", "\u00a7eLeft-click to increase by 1s"), this.msg.getMessage("gui-admin-cooldown-lore2", "\u00a7eRight-click to decrease by 1s")));
        gui.setItem(12, this.createGuiItem(Material.TNT, this.msg.getMessage("gui-admin-radius-name", "\u00a7eExplosion Radius"), this.msg.getMessage("gui-admin-radius-current", "\u00a77Current: {value}").replace("{value}", String.valueOf(cfg.getExplosionRadius())), this.msg.getMessage("gui-admin-radius-lore1", "\u00a7eLeft-click to increase by 0.5"), this.msg.getMessage("gui-admin-radius-lore2", "\u00a7eRight-click to decrease by 0.5")));
        gui.setItem(13, this.createGuiItem(Material.ANVIL, this.msg.getMessage("gui-admin-durability-name", "\u00a7eItem Durability"), this.msg.getMessage("gui-admin-durability-current", "\u00a77Current: {value}").replace("{value}", String.valueOf(cfg.getItemDurability())), this.msg.getMessage("gui-admin-durability-lore1", "\u00a7eClick: +/- 10"), this.msg.getMessage("gui-admin-durability-lore2", "\u00a7eShift+Click: +/- 100")));
        gui.setItem(20, this.createGuiItem(Material.ARMOR_STAND, this.msg.getMessage("gui-skins-name", "\u00a7eSkins"), this.msg.getMessage("gui-skins-lore", "\u00a77Click to change global skin")));
        gui.setItem(25, this.createGuiItem(Material.BOOK, this.msg.getMessage("gui-admin-language-name", "\u00a7eLanguage"), this.msg.getMessage("gui-admin-language-current", "\u00a77Current: {value}").replace("{value}", cfg.getLanguage()), this.msg.getMessage("gui-admin-language-lore", "\u00a7eClick to switch")));
        player.openInventory(gui);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        String viewTitle = event.getView().getTitle();
        Player player = (Player)event.getWhoClicked();
        if (viewTitle.equals(this.msg.getMessage("gui-admin-title", "\u00a78Admin Settings"))) {
            this.handleAdminGuiClick(event, player);
        } else if (viewTitle.equals(this.msg.getMessage("gui-skins-title", "\u00a78Skins"))) {
            this.handleSkinGuiClick(event, player);
        }
    }

    private void handleAdminGuiClick(InventoryClickEvent event, Player player) {
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        ConfigManager cfg = this.plugin.getConfigManager();
        boolean isLeftClick = event.isLeftClick();
        boolean isShiftClick = event.isShiftClick();
        switch (clickedItem.getType()) {
            case IRON_BOOTS: {
                double force = cfg.getPropulsionForce();
                cfg.set("propulsion-force", (double)Math.round((force += isLeftClick ? 0.1 : -0.1) * 10.0) / 10.0);
                break;
            }
            case CLOCK: {
                int cooldown = cfg.getCooldownSeconds();
                cfg.set("cooldown-seconds", Math.max(0, cooldown += isLeftClick ? 1 : -1));
                break;
            }
            case TNT: {
                double radius = cfg.getExplosionRadius();
                cfg.set("explosion-radius", Math.max(0.0, (double)Math.round((radius += isLeftClick ? 0.5 : -0.5) * 10.0) / 10.0));
                break;
            }
            case ANVIL: {
                int durability = cfg.getItemDurability();
                int change = isShiftClick ? 100 : 10;
                cfg.set("item-durability", Math.max(0, durability += isLeftClick ? change : -change));
                break;
            }
            case BOOK: {
                String currentLang = cfg.getLanguage();
                String newLang = currentLang.equals("en") ? "zh" : "en";
                cfg.set("language", newLang);
                break;
            }
            case ARMOR_STAND: {
                this.openSkinGui(player);
                return;
            }
            default: {
                return;
            }
        }
        this.plugin.getConfigManager().saveConfig();
        this.plugin.reloadPlugin();
        this.openAdminSettingsGui(player);
    }

    private void handleSkinGuiClick(InventoryClickEvent event, Player player) {
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        if (clickedItem.getType() == Material.ARROW) {
            this.openAdminSettingsGui(player);
            return;
        }
        SkinManager skinManager = this.plugin.getSkinManager();
        skinManager.getAvailableSkinIds().stream().map(skinManager::getSkinData).filter(skinData -> skinData != null && skinData.getMaterial() == clickedItem.getType()).findFirst().ifPresent(skinData -> {
            skinManager.setGlobalSkin(skinData.getId());
            String skinName = this.msg.getMessage(skinData.getNameKey(), skinData.getId());
            player.sendMessage(this.msg.getMessage("gui-skin-selected", "\u00a7aGlobal skin set to: {skin}").replace("{skin}", skinName));
            this.openSkinGui(player);
        });
    }

    private ItemStack createGuiItem(Material material, String name, String ... lore) {
        ItemStack item = new ItemStack(material, 1);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            meta.setLore(Arrays.asList(lore));
            item.setItemMeta(meta);
        }
        return item;
    }
}

