/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.jetboom.manager;

import com.tencent.jetboom.JetBoom;
import com.tencent.jetboom.manager.ConfigManager;
import com.tencent.jetboom.manager.MessageManager;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ItemManager {
    private final JetBoom plugin;
    private final ConfigManager configManager;
    private ItemStack thrusterItem;
    private ItemStack brokenThrusterItem;
    private final NamespacedKey isThrusterKey;
    private final NamespacedKey durabilityKey;
    private final NamespacedKey maxDurabilityKey;
    private final NamespacedKey uniqueIdKey;

    public ItemManager(JetBoom plugin) {
        this.plugin = plugin;
        this.configManager = plugin.getConfigManager();
        this.isThrusterKey = new NamespacedKey((Plugin)plugin, "is_jetboom_thruster");
        this.durabilityKey = new NamespacedKey((Plugin)plugin, "jetboom_durability");
        this.maxDurabilityKey = new NamespacedKey((Plugin)plugin, "jetboom_max_durability");
        this.uniqueIdKey = new NamespacedKey((Plugin)plugin, "jetboom_unique_id");
        this.initializeItem();
    }

    public void initializeItem() {
        MessageManager msg = this.plugin.getMessageManager();
        ConfigManager cfg = this.plugin.getConfigManager();
        this.brokenThrusterItem = new ItemStack(Material.PISTON);
        ItemMeta brokenMeta = this.brokenThrusterItem.getItemMeta();
        if (brokenMeta != null) {
            String customBrokenName = cfg.getCustomBrokenItemName();
            brokenMeta.setDisplayName(!customBrokenName.isEmpty() ? customBrokenName.replace("&", "\u00a7") : msg.getMessage("broken-item-name", ""));
            List<String> customBrokenLore = cfg.getCustomBrokenItemLore();
            brokenMeta.setLore(!customBrokenLore.isEmpty() ? customBrokenLore.stream().map(l -> l.replace("&", "\u00a7")).collect(Collectors.toList()) : msg.getMessageList("broken-item-lore"));
            this.brokenThrusterItem.setItemMeta(brokenMeta);
        }
    }

    private Material getThrusterMaterial() {
        return this.plugin.getSkinManager().getCurrentSkinMaterial();
    }

    public ItemStack getThrusterItem() {
        Material thrusterMaterial = this.getThrusterMaterial();
        ItemStack newItem = new ItemStack(thrusterMaterial);
        ItemMeta meta = newItem.getItemMeta();
        if (meta == null) {
            return newItem;
        }
        ConfigManager cfg = this.plugin.getConfigManager();
        MessageManager msg = this.plugin.getMessageManager();
        String customName = cfg.getCustomItemName();
        meta.setDisplayName(!customName.isEmpty() ? customName.replace("&", "\u00a7") : msg.getMessage("item-name", ""));
        PersistentDataContainer data = meta.getPersistentDataContainer();
        data.set(this.isThrusterKey, PersistentDataType.BYTE, (Object)1);
        data.set(this.uniqueIdKey, PersistentDataType.STRING, (Object)UUID.randomUUID().toString());
        int maxDurability = this.configManager.getItemDurability();
        if (maxDurability > 0) {
            data.set(this.durabilityKey, PersistentDataType.INTEGER, (Object)maxDurability);
            data.set(this.maxDurabilityKey, PersistentDataType.INTEGER, (Object)maxDurability);
            newItem.setItemMeta(meta);
            return this.updateLore(newItem);
        }
        List<String> customLore = this.configManager.getCustomItemLore();
        meta.setLore(!customLore.isEmpty() ? customLore.stream().map(l -> l.replace("&", "\u00a7")).collect(Collectors.toList()) : this.plugin.getMessageManager().getMessageList("item-lore"));
        newItem.setItemMeta(meta);
        return newItem;
    }

    public ItemStack getBrokenThrusterItem() {
        return this.brokenThrusterItem.clone();
    }

    private ItemStack updateLore(ItemStack item) {
        if (item == null || item.getItemMeta() == null) {
            return item;
        }
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer data = meta.getPersistentDataContainer();
        if (data.has(this.durabilityKey, PersistentDataType.INTEGER)) {
            int current = (Integer)data.get(this.durabilityKey, PersistentDataType.INTEGER);
            int max = (Integer)data.get(this.maxDurabilityKey, PersistentDataType.INTEGER);
            List<String> customLore = this.configManager.getCustomItemLore();
            List<String> baseLore = !customLore.isEmpty() ? customLore.stream().map(l -> l.replace("&", "\u00a7")).collect(Collectors.toList()) : this.plugin.getMessageManager().getMessageList("item-lore");
            String durabilityFormat = this.plugin.getMessageManager().getMessage("lore-durability", "");
            baseLore.add(durabilityFormat.replace("{current}", String.valueOf(current)).replace("{max}", String.valueOf(max)).replace("&", "\u00a7"));
            meta.setLore(baseLore);
            item.setItemMeta(meta);
        }
        return item;
    }

    public boolean isThruster(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        return item.getItemMeta().getPersistentDataContainer().has(this.isThrusterKey, PersistentDataType.BYTE);
    }

    public boolean isBroken(ItemStack item) {
        if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasDisplayName()) {
            return false;
        }
        return item.getItemMeta().getDisplayName().equals(this.brokenThrusterItem.getItemMeta().getDisplayName());
    }

    public int getDurability(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return 0;
        }
        return (Integer)item.getItemMeta().getPersistentDataContainer().getOrDefault(this.durabilityKey, PersistentDataType.INTEGER, (Object)0);
    }

    public ItemStack setDurability(ItemStack item, int durability) {
        if (item == null || !item.hasItemMeta() || !item.getItemMeta().getPersistentDataContainer().has(this.durabilityKey, PersistentDataType.INTEGER)) {
            return item;
        }
        ItemMeta meta = item.getItemMeta();
        meta.getPersistentDataContainer().set(this.durabilityKey, PersistentDataType.INTEGER, (Object)durability);
        item.setItemMeta(meta);
        return this.updateLore(item);
    }

    public ItemStack updateThrusterItem(ItemStack item) {
        ItemStack newItem;
        ItemMeta meta;
        if (item == null || !this.isThruster(item)) {
            return item;
        }
        Material newMaterial = this.getThrusterMaterial();
        ItemMeta oldMeta = item.getItemMeta();
        int amount = item.getAmount();
        Integer currentDurability = null;
        Integer maxDurability = null;
        String uniqueId = null;
        if (oldMeta != null) {
            PersistentDataContainer oldData = oldMeta.getPersistentDataContainer();
            if (oldData.has(this.durabilityKey, PersistentDataType.INTEGER)) {
                currentDurability = (Integer)oldData.get(this.durabilityKey, PersistentDataType.INTEGER);
                maxDurability = (Integer)oldData.get(this.maxDurabilityKey, PersistentDataType.INTEGER);
            }
            if (oldData.has(this.uniqueIdKey, PersistentDataType.STRING)) {
                uniqueId = (String)oldData.get(this.uniqueIdKey, PersistentDataType.STRING);
            }
        }
        if ((meta = (newItem = new ItemStack(newMaterial, amount)).getItemMeta()) == null) {
            return item;
        }
        MessageManager msg = this.plugin.getMessageManager();
        ConfigManager cfg = this.plugin.getConfigManager();
        String customName = cfg.getCustomItemName();
        meta.setDisplayName(!customName.isEmpty() ? customName.replace("&", "\u00a7") : msg.getMessage("item-name", ""));
        PersistentDataContainer data = meta.getPersistentDataContainer();
        data.set(this.isThrusterKey, PersistentDataType.BYTE, (Object)1);
        if (uniqueId != null) {
            data.set(this.uniqueIdKey, PersistentDataType.STRING, (Object)uniqueId);
        }
        if (currentDurability != null && maxDurability != null) {
            data.set(this.durabilityKey, PersistentDataType.INTEGER, (Object)currentDurability);
            data.set(this.maxDurabilityKey, PersistentDataType.INTEGER, (Object)maxDurability);
        }
        newItem.setItemMeta(meta);
        return this.updateLore(newItem);
    }
}

