/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.jetboom.manager;

import com.tencent.jetboom.JetBoom;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class MessageManager {
    private final JetBoom plugin;
    private FileConfiguration messages;

    public MessageManager(JetBoom plugin) {
        this.plugin = plugin;
        this.loadMessages();
    }

    public void loadMessages() {
        String lang = this.plugin.getConfigManager().getLanguage();
        File langFile = new File(this.plugin.getDataFolder(), "lang/" + lang + ".yml");
        if (!langFile.exists()) {
            this.plugin.getLogger().warning("Language file '" + lang + ".yml' not found. Falling back to 'en.yml'.");
            lang = "en";
            langFile = new File(this.plugin.getDataFolder(), "lang/" + lang + ".yml");
        }
        this.messages = YamlConfiguration.loadConfiguration((File)langFile);
        try (InputStream defStream = this.plugin.getResource("lang/" + lang + ".yml");){
            if (defStream != null) {
                this.messages.setDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defStream, StandardCharsets.UTF_8)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getMessage(String key, String defaultValue) {
        String message = this.messages.getString(key, defaultValue);
        return message.replace("&", "\u00a7");
    }

    public List<String> getMessageList(String key) {
        return this.messages.getStringList(key).stream().map(line -> line.replace("&", "\u00a7")).collect(Collectors.toList());
    }

    public String getFormattedMessage(String key, String defaultValue, String ... replacements) {
        String message = this.getMessage(key, defaultValue);
        for (int i = 0; i < replacements.length; i += 2) {
            message = message.replace("{" + replacements[i] + "}", replacements[i + 1]);
        }
        return message;
    }
}

