/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.jetboom.manager;

import com.tencent.jetboom.JetBoom;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class SkinManager {
    private final JetBoom plugin;
    private final Map<String, SkinData> availableSkins;

    public SkinManager(JetBoom plugin) {
        this.plugin = plugin;
        this.availableSkins = new HashMap<String, SkinData>();
        this.initializeSkins();
    }

    private void initializeSkins() {
        this.availableSkins.put("default", new SkinData("default", Material.PISTON, "gui-skin-default-name", "gui-skin-default-desc"));
        this.availableSkins.put("firework", new SkinData("firework", Material.FIREWORK_ROCKET, "gui-skin-firework-name", "gui-skin-firework-desc"));
        this.availableSkins.put("trident", new SkinData("trident", Material.TRIDENT, "gui-skin-trident-name", "gui-skin-trident-desc"));
        this.availableSkins.put("elytra", new SkinData("elytra", Material.ELYTRA, "gui-skin-elytra-name", "gui-skin-elytra-desc"));
        this.availableSkins.put("wind_charge", new SkinData("wind_charge", Material.BLAZE_ROD, "gui-skin-wind-charge-name", "gui-skin-wind-charge-desc"));
        this.availableSkins.put("ender_pearl", new SkinData("ender_pearl", Material.ENDER_PEARL, "gui-skin-ender-pearl-name", "gui-skin-ender-pearl-desc"));
    }

    public void loadSkins() {
        this.availableSkins.clear();
        this.initializeSkins();
        this.plugin.getLogger().info("Loaded " + this.availableSkins.size() + " skins");
    }

    public Material getCurrentSkinMaterial() {
        String currentSkinId = this.plugin.getConfigManager().getGlobalSkinId();
        if (currentSkinId == null || currentSkinId.isEmpty()) {
            return Material.PISTON;
        }
        SkinData skinData = this.availableSkins.get(currentSkinId);
        return skinData != null ? skinData.getMaterial() : Material.PISTON;
    }

    public void setGlobalSkin(String skinId) {
        if (this.availableSkins.containsKey(skinId)) {
            this.plugin.getConfigManager().set("cosmetics.global-skin", skinId);
            this.plugin.getConfigManager().saveConfig();
            for (Player player : this.plugin.getServer().getOnlinePlayers()) {
                this.updatePlayerThrusters(player);
            }
            this.plugin.getLogger().info("Global skin changed to: " + skinId);
        }
    }

    public void updatePlayerThrusters(Player player) {
        Material newMaterial = this.getCurrentSkinMaterial();
        ItemStack[] contents = player.getInventory().getContents();
        for (int i = 0; i < contents.length; ++i) {
            ItemStack item = contents[i];
            if (item == null || !this.plugin.getItemManager().isThruster(item)) continue;
            ItemStack newItem = this.convertThrusterSkin(item, newMaterial);
            player.getInventory().setItem(i, newItem);
        }
        ItemStack mainHand = player.getInventory().getItemInMainHand();
        if (this.plugin.getItemManager().isThruster(mainHand)) {
            player.getInventory().setItemInMainHand(this.convertThrusterSkin(mainHand, newMaterial));
        }
        ItemStack offHand = player.getInventory().getItemInOffHand();
        if (this.plugin.getItemManager().isThruster(offHand)) {
            player.getInventory().setItemInOffHand(this.convertThrusterSkin(offHand, newMaterial));
        }
    }

    private ItemStack convertThrusterSkin(ItemStack originalItem, Material newMaterial) {
        ItemMeta newMeta;
        if (originalItem == null || originalItem.getType() == newMaterial) {
            return originalItem;
        }
        ItemMeta originalMeta = originalItem.getItemMeta();
        int amount = originalItem.getAmount();
        ItemStack newItem = new ItemStack(newMaterial, amount);
        if (originalMeta != null && (newMeta = newItem.getItemMeta()) != null) {
            if (originalMeta.hasDisplayName()) {
                newMeta.setDisplayName(originalMeta.getDisplayName());
            }
            if (originalMeta.hasLore()) {
                newMeta.setLore(originalMeta.getLore());
            }
            PersistentDataContainer originalData = originalMeta.getPersistentDataContainer();
            PersistentDataContainer newData = newMeta.getPersistentDataContainer();
            for (NamespacedKey key : originalData.getKeys()) {
                if (originalData.has(key, PersistentDataType.BYTE)) {
                    newData.set(key, PersistentDataType.BYTE, (Object)((Byte)originalData.get(key, PersistentDataType.BYTE)));
                    continue;
                }
                if (originalData.has(key, PersistentDataType.INTEGER)) {
                    newData.set(key, PersistentDataType.INTEGER, (Object)((Integer)originalData.get(key, PersistentDataType.INTEGER)));
                    continue;
                }
                if (!originalData.has(key, PersistentDataType.STRING)) continue;
                newData.set(key, PersistentDataType.STRING, (Object)((String)originalData.get(key, PersistentDataType.STRING)));
            }
            newItem.setItemMeta(newMeta);
        }
        return newItem;
    }

    public Set<String> getAvailableSkinIds() {
        return this.availableSkins.keySet();
    }

    public SkinData getSkinData(String skinId) {
        return this.availableSkins.get(skinId);
    }

    public String getCurrentSkinId() {
        String skinId = this.plugin.getConfigManager().getGlobalSkinId();
        return skinId == null || skinId.isEmpty() ? "default" : skinId;
    }

    public static class SkinData {
        private final String id;
        private final Material material;
        private final String nameKey;
        private final String descKey;

        public SkinData(String id, Material material, String nameKey, String descKey) {
            this.id = id;
            this.material = material;
            this.nameKey = nameKey;
            this.descKey = descKey;
        }

        public String getId() {
            return this.id;
        }

        public Material getMaterial() {
            return this.material;
        }

        public String getNameKey() {
            return this.nameKey;
        }

        public String getDescKey() {
            return this.descKey;
        }
    }
}

