/*
 * Decompiled with CFR 0.152.
 */
package TCOTS;

import TCOTS.items.HerbalMixture;
import TCOTS.items.components.RecipeTeacherComponent;
import TCOTS.recipes.AlchemyTableRecipe;
import TCOTS.recipes.HerbalTableRecipe;
import TCOTS.registry.TCOTS_Blocks;
import TCOTS.registry.TCOTS_Items;
import TCOTS.registry.TCOTS_ItemsMaterials;
import TCOTS.screen.HerbalTableScreen;
import dev.architectury.platform.Platform;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModInfoRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.Translator;
import mezz.jei.library.plugins.vanilla.crafting.CategoryRecipeValidator;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3956;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class TCOTS_JEIPlugin
implements IModPlugin {
    public static final Supplier<RecipeType<class_8786<AlchemyTableRecipe>>> ALCHEMY_TABLE = Platform.isFabric() ? () -> RecipeType.createFromVanilla((class_3956)AlchemyTableRecipe.Type.INSTANCE) : RecipeType.createFromDeferredVanilla(() -> AlchemyTableRecipe.Type.INSTANCE);
    public static final Supplier<RecipeType<class_8786<HerbalTableRecipe>>> HERBAL_TABLE = Platform.isFabric() ? () -> RecipeType.createFromVanilla((class_3956)HerbalTableRecipe.Type.INSTANCE) : RecipeType.createFromDeferredVanilla(() -> HerbalTableRecipe.Type.INSTANCE);
    @Nullable
    private IRecipeCategory<class_8786<AlchemyTableRecipe>> alchemyTableCategory;
    @Nullable
    private IRecipeCategory<class_8786<HerbalTableRecipe>> herbalTableCategory;

    @NotNull
    public class_2960 getPluginUid() {
        return class_2960.method_60655((String)"tcots_witcher", (String)"jei-witcher");
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((class_1792)TCOTS_Items.ALCHEMY_FORMULA.get(), (ISubtypeInterpreter)AlchemyFormulaInterpreter.INSTANCE);
    }

    public void registerCategories(@NotNull IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        IRecipeCategory[] iRecipeCategoryArray = new IRecipeCategory[2];
        this.alchemyTableCategory = new AlchemyTableRecipeCategory(guiHelper);
        iRecipeCategoryArray[0] = this.alchemyTableCategory;
        this.herbalTableCategory = new HerbalTableRecipeCategory(guiHelper);
        iRecipeCategoryArray[1] = this.herbalTableCategory;
        registration.addRecipeCategories(iRecipeCategoryArray);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ErrorUtil.checkNotNull(this.alchemyTableCategory, (String)"alchemyTableCategory");
        ErrorUtil.checkNotNull(this.herbalTableCategory, (String)"herbalTableCategory");
        IIngredientManager ingredientManager = registration.getIngredientManager();
        TCOTSRecipes TCOTSRecipes2 = new TCOTSRecipes(ingredientManager);
        IVanillaRecipeFactory vanillaRecipeFactory = registration.getVanillaRecipeFactory();
        registration.addRecipes(ALCHEMY_TABLE.get(), TCOTSRecipes2.getAlchemyTableRecipes(this.alchemyTableCategory));
        registration.addRecipes(HERBAL_TABLE.get(), TCOTSRecipes2.getHerbalTableRecipes(this.herbalTableCategory));
        registration.addRecipes(RecipeTypes.ANVIL, RepairDataMaker.getAnvilRecipes(vanillaRecipeFactory));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new class_1799((class_1935)TCOTS_Blocks.AlchemyTable()), new RecipeType[]{ALCHEMY_TABLE.get()});
        registration.addRecipeCatalyst(new class_1799((class_1935)TCOTS_Blocks.HerbalTable()), new RecipeType[]{HERBAL_TABLE.get()});
    }

    public void registerModInfo(IModInfoRegistration registration) {
        registration.addModAliases("tcots_witcher", new String[]{"tcots", "witcher"});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(HerbalTableScreen.class, 102, 48, 22, 15, new RecipeType[]{HERBAL_TABLE.get()});
    }

    public static class AlchemyFormulaInterpreter
    implements ISubtypeInterpreter<class_1799> {
        public static final AlchemyFormulaInterpreter INSTANCE = new AlchemyFormulaInterpreter();

        private AlchemyFormulaInterpreter() {
        }

        @Nullable
        public Object getSubtypeData(class_1799 ingredient, @NotNull UidContext context) {
            return ingredient.method_57824(TCOTS_Items.RecipeTeacher());
        }

        @NotNull
        public String getLegacyStringSubtypeInfo(class_1799 ingredient, @NotNull UidContext context) {
            if (!ingredient.method_57826(TCOTS_Items.RecipeTeacher())) {
                return "";
            }
            RecipeTeacherComponent recipeTeacher = (RecipeTeacherComponent)ingredient.method_57824(TCOTS_Items.RecipeTeacher());
            String formulaString = null;
            if (recipeTeacher != null) {
                formulaString = recipeTeacher.recipeName();
            }
            return Objects.requireNonNullElse(formulaString, "");
        }
    }

    private static class AlchemyTableRecipeCategory
    implements IRecipeCategory<class_8786<AlchemyTableRecipe>> {
        private final IDrawable background;
        private final IDrawable icon;

        public AlchemyTableRecipeCategory(IGuiHelper guiHelper) {
            this.background = guiHelper.drawableBuilder(class_2960.method_60655((String)"tcots_witcher", (String)"textures/gui/alchemy_table_jei.png"), 0, 0, 118, 100).setTextureSize(118, 100).build();
            this.icon = guiHelper.createDrawableItemStack(new class_1799((class_1935)TCOTS_Blocks.AlchemyTable()));
        }

        public int getHeight() {
            return 100;
        }

        public int getWidth() {
            return 118;
        }

        @NotNull
        public RecipeType<class_8786<AlchemyTableRecipe>> getRecipeType() {
            return ALCHEMY_TABLE.get();
        }

        @NotNull
        public class_2561 getTitle() {
            return TCOTS_Blocks.AlchemyTable().method_9518();
        }

        @NotNull
        public IDrawable getIcon() {
            return this.icon;
        }

        public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull class_8786<AlchemyTableRecipe> recipe, @NotNull IFocusGroup focuses) {
            List<class_1799> potionInputs = ((AlchemyTableRecipe)recipe.comp_1933()).returnItemStackWithQuantity();
            class_1799 baseItem = ((AlchemyTableRecipe)recipe.comp_1933()).getBaseItem();
            class_1799 result = ((AlchemyTableRecipe)recipe.comp_1933()).method_8110(null);
            for (int i = 0; i < potionInputs.size(); ++i) {
                int xPosition = 51;
                int yPosition = 22;
                switch (i) {
                    case 1: {
                        xPosition = 27;
                        yPosition = 13;
                        break;
                    }
                    case 2: {
                        xPosition = 75;
                        yPosition = 13;
                        break;
                    }
                    case 3: {
                        xPosition = 3;
                        break;
                    }
                    case 4: {
                        xPosition = 99;
                        break;
                    }
                }
                builder.addSlot(RecipeIngredientRole.INPUT, xPosition, yPosition).addItemStack(potionInputs.get(i));
            }
            builder.addSlot(RecipeIngredientRole.INPUT, 51, 52).addItemStack(baseItem);
            builder.addSlot(RecipeIngredientRole.OUTPUT, 51, 81).addItemStack(result);
        }

        public void draw(@NotNull class_8786<AlchemyTableRecipe> recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull class_332 guiGraphics, double mouseX, double mouseY) {
            class_310 minecraft = class_310.method_1551();
            this.background.draw(guiGraphics);
            if (minecraft.field_1724 != null && minecraft.field_1724.method_3130().method_14878(recipe)) {
                return;
            }
            String text = Translator.translateToLocalFormatted((String)"gui.jei.tcots_witcher.requires_recipe", (Object[])new Object[0]);
            class_327 font = minecraft.field_1772;
            guiGraphics.method_51433(font, text, 0, 0, 0xFF5555, true);
        }
    }

    private static class HerbalTableRecipeCategory
    implements IRecipeCategory<class_8786<HerbalTableRecipe>> {
        private final IDrawable background;
        private final IDrawable icon;

        public HerbalTableRecipeCategory(IGuiHelper guiHelper) {
            this.background = guiHelper.drawableBuilder(class_2960.method_60655((String)"tcots_witcher", (String)"textures/gui/herbal_table_jei.png"), 0, 0, 157, 32).setTextureSize(157, 32).addPadding(10, 0, 0, 0).build();
            this.icon = guiHelper.createDrawableItemStack(new class_1799((class_1935)TCOTS_Blocks.HerbalTable()));
        }

        public int getWidth() {
            return 157;
        }

        public int getHeight() {
            return 42;
        }

        @NotNull
        public RecipeType<class_8786<HerbalTableRecipe>> getRecipeType() {
            return HERBAL_TABLE.get();
        }

        @NotNull
        public class_2561 getTitle() {
            return TCOTS_Blocks.HerbalTable().method_9518();
        }

        @NotNull
        public IDrawable getIcon() {
            return this.icon;
        }

        public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull class_8786<HerbalTableRecipe> recipeEntry, @NotNull IFocusGroup focuses) {
            HerbalTableRecipe recipe = (HerbalTableRecipe)recipeEntry.comp_1933();
            class_1799 herb = new class_1799((class_1935)recipe.getHerb().method_7909(), 1);
            class_1799 bottle = recipe.getBasePotion() == 1 ? class_1844.method_57400((class_1792)class_1802.field_8574, (class_6880)class_1847.field_8967) : (recipe.getBasePotion() == 2 ? class_1844.method_57400((class_1792)class_1802.field_8574, (class_6880)class_1847.field_8985) : class_1844.method_57400((class_1792)class_1802.field_8574, (class_6880)class_1847.field_8991));
            ArrayList<class_1293> totalEffectsFirst = new ArrayList<class_1293>();
            recipe.getEffects().forEach(effect -> {
                if (!((class_1291)effect.comp_349()).method_5573()) {
                    totalEffectsFirst.add(new class_1293(effect, ((class_1291)effect.comp_349()).method_5561() ? 1 : recipe.getTickEffectTime(), recipe.getBadAmplifier()));
                } else {
                    totalEffectsFirst.add(new class_1293(effect, ((class_1291)effect.comp_349()).method_5561() ? 1 : recipe.getTickEffectTime()));
                }
            });
            class_1799 result = recipe.method_8110(null);
            result = HerbalMixture.writeEffects(result.method_7972(), totalEffectsFirst);
            builder.addSlot(RecipeIngredientRole.INPUT, 17, 18).addItemStack(herb);
            builder.addSlot(RecipeIngredientRole.INPUT, 66, 18).addItemStack(bottle);
            builder.addSlot(RecipeIngredientRole.OUTPUT, 124, 18).addItemStack(result);
        }

        public void draw(@NotNull class_8786<HerbalTableRecipe> recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull class_332 guiGraphics, double mouseX, double mouseY) {
            super.draw(recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
            class_310 minecraft = class_310.method_1551();
            String text = Translator.translateToLocalFormatted((String)"gui.jei.tcots_witcher.for_herb", (Object[])new Object[]{((HerbalTableRecipe)recipe.comp_1933()).getTickEffectTime() / 20});
            class_327 font = minecraft.field_1772;
            guiGraphics.method_51433(font, text, 0, 2, 43520, true);
            this.background.draw(guiGraphics);
        }
    }

    private static class TCOTSRecipes {
        private final class_1863 recipeManager;
        private final IIngredientManager ingredientManager;

        public TCOTSRecipes(IIngredientManager ingredientManager) {
            class_310 minecraft = class_310.method_1551();
            ErrorUtil.checkNotNull((Object)minecraft, (String)"minecraft");
            class_638 world = minecraft.field_1687;
            ErrorUtil.checkNotNull((Object)world, (String)"minecraft world");
            this.recipeManager = world.method_8433();
            this.ingredientManager = ingredientManager;
        }

        public List<class_8786<AlchemyTableRecipe>> getAlchemyTableRecipes(IRecipeCategory<class_8786<AlchemyTableRecipe>> alchemyTableCategory) {
            CategoryRecipeValidator validator = new CategoryRecipeValidator(alchemyTableCategory, this.ingredientManager, 6);
            return TCOTSRecipes.getValidAlchemyTableRecipes(this.recipeManager, AlchemyTableRecipe.Type.INSTANCE, (CategoryRecipeValidator<AlchemyTableRecipe>)validator);
        }

        public List<class_8786<HerbalTableRecipe>> getHerbalTableRecipes(IRecipeCategory<class_8786<HerbalTableRecipe>> herbalTableCategory) {
            CategoryRecipeValidator validator = new CategoryRecipeValidator(herbalTableCategory, this.ingredientManager, 2);
            return TCOTSRecipes.getValidHandledRecipes(this.recipeManager, HerbalTableRecipe.Type.INSTANCE, validator);
        }

        private static <C extends class_9695, T extends class_1860<C>> List<class_8786<T>> getValidHandledRecipes(class_1863 recipeManager, class_3956<T> recipeType, CategoryRecipeValidator<T> validator) {
            return recipeManager.method_30027(recipeType).stream().filter(r -> validator.isRecipeValid(r) && validator.isRecipeHandled(r)).toList();
        }

        private static List<class_8786<AlchemyTableRecipe>> getValidAlchemyTableRecipes(class_1863 recipeManager, class_3956<AlchemyTableRecipe> recipeType, CategoryRecipeValidator<AlchemyTableRecipe> validator) {
            return recipeManager.method_30027(recipeType).stream().filter(r -> validator.isRecipeValid(r) && validator.isRecipeHandled(r)).sorted(Comparator.comparing(recipeEntry -> Float.valueOf(((AlchemyTableRecipe)recipeEntry.comp_1933()).getOrder()))).toList();
        }
    }

    private static class RepairDataMaker {
        private RepairDataMaker() {
        }

        public static List<IJeiAnvilRecipe> getAnvilRecipes(IVanillaRecipeFactory vanillaRecipeFactory) {
            return RepairDataMaker.getRepairData().flatMap(repairData -> RepairDataMaker.getRepairRecipes(repairData, vanillaRecipeFactory)).toList();
        }

        private static Stream<RepairData> getRepairData() {
            return Stream.of(new RepairData(TCOTS_ItemsMaterials.Gvalchir().method_8023(), new class_1799((class_1935)TCOTS_Items.GVALCHIR.get())), new RepairData(TCOTS_ItemsMaterials.Moonblade().method_8023(), new class_1799((class_1935)TCOTS_Items.MOONBLADE.get())), new RepairData(TCOTS_ItemsMaterials.Dyaebl().method_8023(), new class_1799((class_1935)TCOTS_Items.DYAEBL.get())), new RepairData(TCOTS_ItemsMaterials.WintersBlade().method_8023(), new class_1799((class_1935)TCOTS_Items.WINTERS_BLADE.get())), new RepairData(TCOTS_ItemsMaterials.Ardaenye().method_8023(), new class_1799((class_1935)TCOTS_Items.ARDAENYE.get())), new RepairData(TCOTS_ItemsMaterials.Anchor().method_8023(), new class_1799((class_1935)TCOTS_Items.GIANT_ANCHOR.get())), new RepairData((class_1856)((class_1741)TCOTS_ItemsMaterials.Manticore().comp_349()).comp_2301().get(), new class_1799((class_1935)TCOTS_Items.MANTICORE_ARMOR.get()), new class_1799((class_1935)TCOTS_Items.MANTICORE_TROUSERS.get()), new class_1799((class_1935)TCOTS_Items.MANTICORE_BOOTS.get())), new RepairData((class_1856)((class_1741)TCOTS_ItemsMaterials.WarriorsLeather().comp_349()).comp_2301().get(), new class_1799((class_1935)TCOTS_Items.WARRIORS_LEATHER_JACKET.get()), new class_1799((class_1935)TCOTS_Items.WARRIORS_LEATHER_TROUSERS.get()), new class_1799((class_1935)TCOTS_Items.WARRIORS_LEATHER_BOOTS.get())), new RepairData((class_1856)((class_1741)TCOTS_ItemsMaterials.Raven().comp_349()).comp_2301().get(), new class_1799((class_1935)TCOTS_Items.RAVENS_ARMOR.get()), new class_1799((class_1935)TCOTS_Items.RAVENS_TROUSERS.get()), new class_1799((class_1935)TCOTS_Items.RAVENS_BOOTS.get())));
        }

        private static Stream<IJeiAnvilRecipe> getRepairRecipes(RepairData repairData, IVanillaRecipeFactory vanillaRecipeFactory) {
            class_1856 repairIngredient = repairData.getRepairIngredient();
            List<class_1799> repairable = repairData.getRepairable();
            List<class_1799> repairMaterials = List.of(repairIngredient.method_8105());
            return repairable.stream().mapMulti((itemStack, consumer) -> {
                class_1799 damagedThreeQuarters = itemStack.method_7972();
                damagedThreeQuarters.method_7974(damagedThreeQuarters.method_7936() * 3 / 4);
                class_1799 damagedHalf = itemStack.method_7972();
                damagedHalf.method_7974(damagedHalf.method_7936() / 2);
                IJeiAnvilRecipe repairWithSame = vanillaRecipeFactory.createAnvilRecipe(List.of(damagedThreeQuarters), List.of(damagedThreeQuarters), List.of(damagedHalf));
                consumer.accept(repairWithSame);
                if (!repairMaterials.isEmpty()) {
                    class_1799 damagedFully = itemStack.method_7972();
                    damagedFully.method_7974(damagedFully.method_7936());
                    IJeiAnvilRecipe repairWithMaterial = vanillaRecipeFactory.createAnvilRecipe(List.of(damagedFully), repairMaterials, List.of(damagedThreeQuarters));
                    consumer.accept(repairWithMaterial);
                }
            });
        }

        private static class RepairData {
            private final class_1856 repairIngredient;
            private final List<class_1799> repairable;

            public RepairData(class_1856 repairIngredient, class_1799 ... repairable) {
                this.repairIngredient = repairIngredient;
                this.repairable = List.of(repairable);
            }

            public class_1856 getRepairIngredient() {
                return this.repairIngredient;
            }

            public List<class_1799> getRepairable() {
                return this.repairable;
            }
        }
    }
}

