/*
 * Decompiled with CFR 0.152.
 */
package TCOTS.blocks.plants;

import TCOTS.registry.TCOTS_Blocks;
import TCOTS.registry.TCOTS_Items;
import TCOTS.registry.TCOTS_Sounds;
import com.mojang.serialization.MapCodec;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1584;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3830;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_9062;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrowsEyeFern
extends class_2320
implements class_2256 {
    public static final MapCodec<CrowsEyeFern> CODEC = CrowsEyeFern.method_54094(CrowsEyeFern::new);
    public static final class_2758 AGE = class_2741.field_37654;
    private static final class_265 GROWN_UPPER_OUTLINE_SHAPE = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0);
    private static final class_265 GROWN_LOWER_OUTLINE_SHAPE = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final class_265 AGE_0_SHAPE = class_2248.method_9541((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0);
    private static final class_265[] UPPER_OUTLINE_SHAPES = new class_265[]{class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0), GROWN_UPPER_OUTLINE_SHAPE};
    private static final class_265[] LOWER_OUTLINE_SHAPES = new class_265[]{AGE_0_SHAPE, class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)9.0, (double)13.0), GROWN_LOWER_OUTLINE_SHAPE, GROWN_LOWER_OUTLINE_SHAPE, GROWN_LOWER_OUTLINE_SHAPE};

    @NotNull
    public MapCodec<CrowsEyeFern> method_53969() {
        return CODEC;
    }

    public CrowsEyeFern(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)AGE, (Comparable)Integer.valueOf(0))).method_11657((class_2769)field_10929, (Comparable)class_2756.field_12607));
    }

    @NotNull
    public class_1799 method_9574(@NotNull class_4538 world, @NotNull class_2338 pos, @NotNull class_2680 state) {
        return new class_1799(TCOTS_Items.CROWS_EYE);
    }

    @NotNull
    public class_265 method_9530(class_2680 state, @NotNull class_1922 world, @NotNull class_2338 pos, @NotNull class_3726 context) {
        class_243 offset = state.method_26226(world, pos);
        return state.method_11654((class_2769)field_10929) == class_2756.field_12609 ? UPPER_OUTLINE_SHAPES[Math.min(Math.abs(4 - ((Integer)state.method_11654((class_2769)AGE) + 1)), UPPER_OUTLINE_SHAPES.length - 1)].method_1096(offset.field_1352, offset.field_1351, offset.field_1350) : LOWER_OUTLINE_SHAPES[(Integer)state.method_11654((class_2769)AGE)].method_1096(offset.field_1352, offset.field_1351, offset.field_1350);
    }

    @NotNull
    public class_2680 method_9559(class_2680 state, @NotNull class_2350 direction, @NotNull class_2680 neighborState, @NotNull class_1936 world, @NotNull class_2338 pos, @NotNull class_2338 neighborPos) {
        if (CrowsEyeFern.isDoubleTallAtAge((Integer)state.method_11654((class_2769)AGE))) {
            return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
        }
        return state.method_26184((class_4538)world, pos) ? state : class_2246.field_10124.method_9564();
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{AGE});
        super.method_9515(builder);
    }

    public void method_9548(@NotNull class_2680 state, @NotNull class_1937 world, @NotNull class_2338 pos, @NotNull class_1297 entity) {
        if (entity instanceof class_1584 && world.method_8450().method_8355(class_1928.field_19388)) {
            world.method_8651(pos, true, entity);
        }
        super.method_9548(state, world, pos, entity);
    }

    public void method_9567(@NotNull class_1937 world, @NotNull class_2338 pos, @NotNull class_2680 state, @NotNull class_1309 placer, @NotNull class_1799 itemStack) {
    }

    public boolean method_9542(class_2680 state) {
        return state.method_11654((class_2769)field_10929) == class_2756.field_12607 && !this.isFullyGrown(state);
    }

    private boolean isFullyGrown(class_2680 state) {
        return (Integer)state.method_11654((class_2769)AGE) >= 4;
    }

    public void method_9514(class_2680 state, @NotNull class_3218 world, @NotNull class_2338 pos, @NotNull class_5819 random) {
        int i = (Integer)state.method_11654((class_2769)AGE);
        if (i < 3 && random.method_43048(5) == 0 && world.method_22335(pos.method_10084(), 0) >= 9) {
            class_2680 blockState = (class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(i + 1));
            world.method_8652(pos, blockState, 2);
            world.method_43276((class_6880)class_5712.field_28733, pos, class_5712.class_7397.method_43287((class_2680)blockState));
        }
    }

    @NotNull
    protected class_9062 method_55765(@NotNull class_1799 stack, class_2680 state, @NotNull class_1937 world, @NotNull class_2338 pos, @NotNull class_1657 player, @NotNull class_1268 hand, @NotNull class_3965 hit) {
        int i = (Integer)state.method_11654((class_2769)AGE);
        boolean bl = i == 4;
        return !bl && stack.method_31574(class_1802.field_8324) ? class_9062.field_47732 : super.method_55765(stack, state, world, pos, player, hand, hit);
    }

    @NotNull
    public class_1269 method_55766(class_2680 state, @NotNull class_1937 world, @NotNull class_2338 pos, @NotNull class_1657 player, @NotNull class_3965 hit) {
        int i = (Integer)state.method_11654((class_2769)AGE);
        if (i > 3) {
            int j = 1 + world.field_9229.method_43048(4);
            class_3830.method_9577((class_1937)world, (class_2338)pos, (class_1799)new class_1799(TCOTS_Items.CROWS_EYE, j));
            world.method_8396(null, pos, TCOTS_Sounds.getSoundEvent("ingredient_pops"), class_3419.field_15245, 1.0f, 0.8f + world.field_9229.method_43057() * 0.4f);
            class_2680 ageState = (class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(3));
            world.method_8652(pos, ageState, 2);
            world.method_43276((class_6880)class_5712.field_28733, pos, class_5712.class_7397.method_43286((class_1297)player, (class_2680)ageState));
            if (CrowsEyeFern.isLowerHalf(state)) {
                world.method_8652(pos.method_10084(), (class_2680)ageState.method_11657((class_2769)field_10929, (Comparable)class_2756.field_12609), 3);
                world.method_43276((class_6880)class_5712.field_28733, pos, class_5712.class_7397.method_43286((class_1297)player, (class_2680)ageState));
            } else {
                world.method_8652(pos.method_10074(), (class_2680)ageState.method_11657((class_2769)field_10929, (Comparable)class_2756.field_12607), 2);
                world.method_43276((class_6880)class_5712.field_28733, pos, class_5712.class_7397.method_43286((class_1297)player, (class_2680)ageState));
            }
            return class_1269.method_29236((boolean)world.field_9236);
        }
        return super.method_55766(state, world, pos, player, hit);
    }

    public boolean method_9651(@NotNull class_4538 world, @NotNull class_2338 pos, @NotNull class_2680 state) {
        LowerHalfContext lowerHalfContext = this.getLowerHalfContext(world, pos, state);
        if (lowerHalfContext == null) {
            return false;
        }
        return this.canGrow(world, lowerHalfContext.pos, lowerHalfContext.state, (Integer)lowerHalfContext.state.method_11654((class_2769)AGE) + 1);
    }

    private static boolean canGrowAt(class_4538 world, class_2338 pos) {
        class_2680 blockState = world.method_8320(pos);
        return blockState.method_26215() || blockState.method_27852(TCOTS_Blocks.CrowsEyeFern());
    }

    private boolean canGrow(class_4538 world, class_2338 pos, class_2680 state, int age) {
        return !this.isFullyGrown(state) && this.method_9558(state, world, pos) && (!CrowsEyeFern.isDoubleTallAtAge(age) || CrowsEyeFern.canGrowAt(world, pos.method_10084()));
    }

    public boolean method_9650(@NotNull class_1937 world, @NotNull class_5819 random, @NotNull class_2338 pos, @NotNull class_2680 state) {
        return true;
    }

    private static boolean isDoubleTallAtAge(int age) {
        return age >= 3;
    }

    private static boolean isLowerHalf(class_2680 state) {
        return state.method_27852(TCOTS_Blocks.CrowsEyeFern()) && state.method_11654((class_2769)field_10929) == class_2756.field_12607;
    }

    @Nullable
    private LowerHalfContext getLowerHalfContext(class_4538 world, class_2338 pos, class_2680 state) {
        if (CrowsEyeFern.isLowerHalf(state)) {
            return new LowerHalfContext(pos, state);
        }
        class_2338 blockPos = pos.method_10074();
        class_2680 blockState = world.method_8320(blockPos);
        if (CrowsEyeFern.isLowerHalf(blockState)) {
            return new LowerHalfContext(blockPos, blockState);
        }
        return null;
    }

    public void method_9652(@NotNull class_3218 world, @NotNull class_5819 random, @NotNull class_2338 pos, @NotNull class_2680 state) {
        LowerHalfContext lowerHalfContext = this.getLowerHalfContext((class_4538)world, pos, state);
        if (lowerHalfContext == null) {
            return;
        }
        this.tryGrow(world, lowerHalfContext.state, lowerHalfContext.pos, 1);
    }

    private void tryGrow(class_3218 world, class_2680 state, class_2338 pos, int amount) {
        int i = Math.min((Integer)state.method_11654((class_2769)AGE) + amount, 4);
        if (!this.canGrow((class_4538)world, pos, state, i)) {
            return;
        }
        class_2680 blockState = (class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(i));
        world.method_8652(pos, blockState, 2);
        if (CrowsEyeFern.isDoubleTallAtAge(i)) {
            world.method_8652(pos.method_10084(), (class_2680)blockState.method_11657((class_2769)field_10929, (Comparable)class_2756.field_12609), 3);
        }
    }

    record LowerHalfContext(class_2338 pos, class_2680 state) {
    }
}

