/*
 * Decompiled with CFR 0.152.
 */
package TCOTS.entity;

import TCOTS.entity.ogroids.AbstractTrollEntity;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_3542;
import net.minecraft.class_4844;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_5996;
import org.slf4j.Logger;

public class TrollGossips {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<UUID, Reputation> entityReputation = Maps.newHashMap();

    @class_5996
    public Map<UUID, Object2IntMap<TrollGossipType>> getEntityReputationAssociatedGossips() {
        HashMap map = Maps.newHashMap();
        this.entityReputation.keySet().forEach(uuid -> {
            Reputation reputation = this.entityReputation.get(uuid);
            map.put(uuid, reputation.associatedReputation);
        });
        return map;
    }

    public void decay() {
        Iterator<Reputation> iterator = this.entityReputation.values().iterator();
        while (iterator.hasNext()) {
            Reputation reputation = iterator.next();
            reputation.decay();
            if (!reputation.isObsolete()) continue;
            iterator.remove();
        }
    }

    private Stream<TrollGossipEntry> entries() {
        return this.entityReputation.entrySet().stream().flatMap(entryKey -> ((Reputation)entryKey.getValue()).entriesFor((UUID)entryKey.getKey()));
    }

    private Collection<TrollGossipEntry> pickGossips(class_5819 random, int count) {
        List<TrollGossipEntry> list = this.entries().toList();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        int[] is = new int[list.size()];
        int i = 0;
        for (int j = 0; j < list.size(); ++j) {
            TrollGossipEntry gossipEntry = list.get(j);
            is[j] = (i += Math.abs(gossipEntry.getValue())) - 1;
        }
        Set set = Sets.newIdentityHashSet();
        for (int k = 0; k < count; ++k) {
            int l = random.method_43048(i);
            int m = Arrays.binarySearch(is, l);
            set.add(list.get(m < 0 ? -m - 1 : m));
        }
        return set;
    }

    private Reputation getReputationFor(UUID target) {
        return this.entityReputation.computeIfAbsent(target, uuid -> new Reputation());
    }

    public void shareGossipsWith(AbstractTrollEntity senderTroll, AbstractTrollEntity receiverTroll) {
        TrollGossips senderGossips = senderTroll.getGossip();
        TrollGossips receiverGossips = receiverTroll.getGossip();
        List<TrollGossipEntry> collectionSender = senderGossips.entries().toList();
        List<TrollGossipEntry> collectionReceiver = receiverGossips.entries().toList();
        ArrayList listKnowPlayersForSender = new ArrayList();
        ArrayList listKnowPlayersForReceiver = new ArrayList();
        collectionSender.forEach(gossip -> {
            if (!listKnowPlayersForSender.contains(gossip.target)) {
                listKnowPlayersForSender.add(gossip.target);
            }
        });
        collectionReceiver.forEach(gossip -> {
            if (!listKnowPlayersForReceiver.contains(gossip.target)) {
                listKnowPlayersForReceiver.add(gossip.target);
            }
        });
        if (!new HashSet(listKnowPlayersForReceiver).containsAll(listKnowPlayersForSender)) {
            AtomicBoolean triggerParticles = new AtomicBoolean(false);
            collectionSender.forEach(gossip -> {
                if (!listKnowPlayersForReceiver.contains(gossip.target)) {
                    int reputation = gossip.reputationValue;
                    int decrement = gossip.type.shareDecrement;
                    receiverGossips.startGossip(gossip.target, gossip.type, reputation - decrement <= 0 ? 1 : reputation - decrement, 0);
                    triggerParticles.set(true);
                }
            });
            if (triggerParticles.get()) {
                receiverTroll.method_37908().method_8421((class_1297)receiverTroll, (byte)14);
            }
        }
    }

    public int getReputationFor(UUID target, Predicate<TrollGossipType> gossipTypeFilter) {
        Reputation reputation = this.entityReputation.get(target);
        return reputation != null ? reputation.getReputationValueFor(gossipTypeFilter) : 0;
    }

    public int getFriendshipFor(UUID target, Predicate<TrollGossipType> gossipTypeFilter) {
        Reputation reputation = this.entityReputation.get(target);
        return reputation != null ? reputation.getFriendshipValueFor(gossipTypeFilter) : 0;
    }

    public void startGossip(UUID target, TrollGossipType type, int reputationValue, int friendshipValue) {
        Reputation reputation = this.getReputationFor(target);
        reputation.associatedReputation.mergeInt((Object)type, reputationValue, (left, right) -> this.mergeReputation(type, left, right));
        reputation.associatedFriendship.mergeInt((Object)type, friendshipValue, (left, right) -> this.mergeFriendship(type, left, right));
        reputation.clamp(type, reputation.associatedReputation, type.maxValue);
        reputation.clamp(type, reputation.associatedFriendship, type.maxFriendshipValue);
        if (reputation.isObsolete()) {
            this.entityReputation.remove(target);
        }
    }

    public void removeGossip(UUID target, TrollGossipType type, int reputationValue, int friendshipValue) {
        this.startGossip(target, type, -reputationValue, -friendshipValue);
    }

    public void remove(UUID target, TrollGossipType type) {
        Reputation reputation = this.entityReputation.get(target);
        if (reputation != null) {
            reputation.remove(type);
            if (reputation.isObsolete()) {
                this.entityReputation.remove(target);
            }
        }
    }

    public void remove(TrollGossipType type) {
        Iterator<Reputation> iterator = this.entityReputation.values().iterator();
        while (iterator.hasNext()) {
            Reputation reputation = iterator.next();
            reputation.remove(type);
            if (!reputation.isObsolete()) continue;
            iterator.remove();
        }
    }

    public <T> T serialize(DynamicOps<T> ops) {
        return (T)TrollGossipEntry.LIST_CODEC.encodeStart(ops, this.entries().toList()).resultOrPartial(error -> LOGGER.warn("Failed to serialize gossips: {}", error)).orElseGet(() -> ops.emptyList());
    }

    public void deserialize(Dynamic<?> dynamic) {
        TrollGossipEntry.LIST_CODEC.decode(dynamic).resultOrPartial(error -> LOGGER.warn("Failed to deserialize gossips: {}", error)).stream().flatMap(pair -> ((List)pair.getFirst()).stream()).forEach(entry -> {
            this.getReputationFor((UUID)entry.target).associatedReputation.put((Object)entry.type, entry.reputationValue);
            this.getReputationFor((UUID)entry.target).associatedFriendship.put((Object)entry.type, entry.friendshipValue);
        });
    }

    private static int max(int left, int right) {
        return Math.max(left, right);
    }

    private int mergeReputation(TrollGossipType type, int left, int right) {
        int i = left + right;
        return i > type.maxValue ? Math.max(type.maxValue, left) : i;
    }

    private int mergeFriendship(TrollGossipType type, int left, int right) {
        int i = left + right;
        return i > type.maxFriendshipValue ? Math.max(type.maxFriendshipValue, left) : i;
    }

    static class Reputation {
        final Object2IntMap<TrollGossipType> associatedReputation = new Object2IntOpenHashMap();
        final Object2IntMap<TrollGossipType> associatedFriendship = new Object2IntOpenHashMap();

        public int getReputationValueFor(Predicate<TrollGossipType> gossipTypeFilter) {
            return this.associatedReputation.object2IntEntrySet().stream().filter(entry -> gossipTypeFilter.test((TrollGossipType)((Object)((Object)entry.getKey())))).mapToInt(entry -> entry.getIntValue() * ((TrollGossipType)((Object)((Object)entry.getKey()))).multiplier).sum();
        }

        public int getFriendshipValueFor(Predicate<TrollGossipType> gossipTypeFilter) {
            return this.associatedFriendship.object2IntEntrySet().stream().filter(entry -> gossipTypeFilter.test((TrollGossipType)((Object)((Object)entry.getKey())))).mapToInt(entry -> entry.getIntValue() * ((TrollGossipType)((Object)((Object)entry.getKey()))).multiplier).sum();
        }

        public Stream<TrollGossipEntry> entriesFor(UUID target) {
            return this.associatedReputation.object2IntEntrySet().stream().map(entry -> new TrollGossipEntry(target, (TrollGossipType)((Object)((Object)entry.getKey())), entry.getIntValue(), this.associatedFriendship.getInt(entry.getKey())));
        }

        public void decay() {
            ObjectIterator reputationIterator = this.associatedReputation.object2IntEntrySet().iterator();
            ObjectIterator friendshipIterator = this.associatedFriendship.object2IntEntrySet().iterator();
            while (reputationIterator.hasNext() && friendshipIterator.hasNext()) {
                Object2IntMap.Entry repEntry = (Object2IntMap.Entry)reputationIterator.next();
                int repValue = repEntry.getIntValue() - ((TrollGossipType)((Object)repEntry.getKey())).decay;
                if (repEntry.getIntValue() > 0) {
                    repEntry.setValue(repValue);
                }
                if (repEntry.getIntValue() < 0) {
                    repEntry.setValue(0);
                }
                Object2IntMap.Entry friendEntry = (Object2IntMap.Entry)friendshipIterator.next();
                int friendValue = friendEntry.getIntValue() - ((TrollGossipType)((Object)friendEntry.getKey())).friendshipDecay;
                if (friendEntry.getIntValue() > 0) {
                    friendEntry.setValue(friendValue);
                }
                if (friendEntry.getIntValue() < 0) {
                    friendEntry.setValue(0);
                }
                if (repValue > 0 || friendValue > 0) continue;
                reputationIterator.remove();
                friendshipIterator.remove();
            }
        }

        public boolean isObsolete() {
            return this.associatedReputation.isEmpty();
        }

        public void clamp(TrollGossipType gossipType, Object2IntMap<TrollGossipType> map, int maxValue) {
            int i = map.getInt((Object)gossipType);
            if (i > maxValue) {
                map.put((Object)gossipType, maxValue);
            }
        }

        public void remove(TrollGossipType gossipType) {
            this.associatedReputation.removeInt((Object)gossipType);
        }
    }

    record TrollGossipEntry(UUID target, TrollGossipType type, int reputationValue, int friendshipValue) {
        public static final Codec<TrollGossipEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_4844.field_25122.fieldOf("Target").forGetter(TrollGossipEntry::target), (App)TrollGossipType.CODEC.fieldOf("Type").forGetter(TrollGossipEntry::type), (App)class_5699.field_33441.fieldOf("Reputation").forGetter(TrollGossipEntry::reputationValue), (App)class_5699.field_33441.fieldOf("zFriendship").forGetter(TrollGossipEntry::friendshipValue)).apply((Applicative)instance, TrollGossipEntry::new));
        public static final Codec<List<TrollGossipEntry>> LIST_CODEC = CODEC.listOf();

        public int getValue() {
            return this.reputationValue * this.type.multiplier;
        }
    }

    public static enum TrollGossipType implements class_3542
    {
        BARTERING("bartering", 1, 20, 20, 2, 2, 15),
        FEEDING("feeding", 1, 50, 200, 10, 0, 20),
        DEFENDING("defending", 1, 150, 200, 1, 0, 10),
        KILL_TROLL("kill_troll", -1, 200, 200, 10, 5, 5),
        HURT("hurt", -1, 200, 200, 20, 10, 10);

        public final String key;
        public final int multiplier;
        public final int maxValue;
        public final int maxFriendshipValue;
        public final int friendshipDecay;
        public final int decay;
        public final int shareDecrement;
        public static final Codec<TrollGossipType> CODEC;

        private TrollGossipType(String key, int multiplier, int maxReputation, int maxFriendshipValue, int decay, int friendshipDecay, int shareDecrement) {
            this.key = key;
            this.multiplier = multiplier;
            this.maxValue = maxReputation;
            this.decay = decay;
            this.friendshipDecay = friendshipDecay;
            this.shareDecrement = shareDecrement;
            this.maxFriendshipValue = maxFriendshipValue;
        }

        public String method_15434() {
            return this.key;
        }

        static {
            CODEC = class_3542.method_28140(TrollGossipType::values);
        }
    }
}

