/*
 * Decompiled with CFR 0.152.
 */
package TCOTS.entity.geo.model;

import TCOTS.utils.GeoControllersUtil;
import net.minecraft.class_1308;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public abstract class BipedGeoModelBase<T extends GeoAnimatable>
extends GeoModel<T> {
    protected float getLegsSpeed(T entity) {
        return 0.5f;
    }

    protected float getLegsAmount(T entity) {
        return 0.8f;
    }

    protected float getArmsSpeed(T entity) {
        return this.getLegsSpeed(entity);
    }

    protected float getArmsAmount(T entity) {
        return 0.6f;
    }

    protected float getHeadExtraInAttacking(T entity) {
        return 10.0f;
    }

    protected boolean hasNormalHead(T entity) {
        return true;
    }

    protected boolean hasArmZMovement(T entity) {
        return true;
    }

    public void setCustomAnimations(T entity, long instanceId, AnimationState<T> animationState) {
        if (entity instanceof class_1308) {
            class_1308 mob = (class_1308)entity;
            GeoBone head = this.hasNormalHead(entity) ? this.getAnimationProcessor().getBone("head") : null;
            GeoBone left_leg = this.getAnimationProcessor().getBone("left_leg_swing");
            GeoBone right_leg = this.getAnimationProcessor().getBone("right_leg_swing");
            GeoBone left_arm = this.getAnimationProcessor().getBone("left_arm_swing");
            GeoBone right_arm = this.getAnimationProcessor().getBone("right_arm_swing");
            if (head != null) {
                EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
                if (animationState.isMoving() && mob.method_6510()) {
                    head.setRotX((entityData.headPitch() + this.getHeadExtraInAttacking(entity)) * ((float)Math.PI / 180));
                    head.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
                } else {
                    head.setRotX(entityData.headPitch() * ((float)Math.PI / 180));
                    head.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
                }
                head.setRotZ(0.0f);
            }
            if (left_arm != null && right_arm != null && left_leg != null && right_leg != null && !mob.field_6252) {
                left_leg.setRotX((float)(-(Math.sin(animationState.getLimbSwing() * this.getLegsSpeed(entity)) * (double)(animationState.getLimbSwingAmount() * this.getLegsAmount(entity)))));
                right_leg.setRotX((float)(Math.sin(animationState.getLimbSwing() * this.getLegsSpeed(entity)) * (double)(animationState.getLimbSwingAmount() * this.getLegsAmount(entity))));
                left_arm.setRotX(GeoControllersUtil.getLimbSwing(animationState, -0.9f, 0.5f, this.getArmsSpeed(entity), this.getArmsAmount(entity), false));
                right_arm.setRotX(GeoControllersUtil.getLimbSwing(animationState, -0.5f, 0.9f, this.getArmsSpeed(entity), this.getArmsAmount(entity), true));
                if (this.hasArmZMovement(entity)) {
                    right_arm.setRotZ(GeoControllersUtil.getLimbSwing(animationState, -0.0f, 0.2f, this.getArmsSpeed(entity), this.getArmsAmount(entity), false));
                    left_arm.setRotZ(GeoControllersUtil.getLimbSwing(animationState, -0.2f, 0.0f, this.getArmsSpeed(entity), this.getArmsAmount(entity), true));
                } else {
                    right_arm.setRotZ(0.0f);
                    left_arm.setRotZ(0.0f);
                }
            }
        }
    }
}

