/*
 * Decompiled with CFR 0.152.
 */
package TCOTS.entity.geo.model;

import TCOTS.entity.geo.model.BipedGeoModelBase;
import TCOTS.entity.ogroids.AbstractTrollEntity;
import TCOTS.entity.ogroids.RockTrollEntity;
import TCOTS.utils.GeoControllersUtil;
import net.minecraft.class_3532;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.data.EntityModelData;

public abstract class TrollGeoModelBase<T extends AbstractTrollEntity>
extends BipedGeoModelBase<T> {
    @Override
    protected boolean hasArmZMovement(T troll) {
        return false;
    }

    @Override
    protected boolean hasNormalHead(T troll) {
        return false;
    }

    @Override
    public void setCustomAnimations(T troll, long instanceId, AnimationState<T> animationState) {
        GeoBone head = this.getAnimationProcessor().getBone("head");
        GeoBone left_leg = this.getAnimationProcessor().getBone("left_leg_swing");
        GeoBone right_leg = this.getAnimationProcessor().getBone("right_leg_swing");
        GeoBone left_arm = this.getAnimationProcessor().getBone("left_arm_swing");
        GeoBone right_arm = this.getAnimationProcessor().getBone("right_arm_swing");
        GeoBone left_hand = this.getAnimationProcessor().getBone("left_hand");
        GeoBone right_hand = this.getAnimationProcessor().getBone("right_hand");
        GeoBone low_jaw = this.getAnimationProcessor().getBone("lowJaw");
        if (head != null && low_jaw != null) {
            RockTrollEntity rockTroll;
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            if (((AbstractTrollEntity)((Object)troll)).hasBarteringItem()) {
                head.setRotX(-0.38397244f);
                head.setRotY((float)(troll.method_5961() ? -1 : 1) * 0.20943952f);
                head.setRotZ(-0.17453292f);
                low_jaw.setRotX(0.0f);
            } else if (troll instanceof RockTrollEntity && (rockTroll = (RockTrollEntity)((Object)troll)).isTrollBlocking()) {
                head.setRotX(-0.2617994f);
                head.setRotY(-0.3926991f);
                head.setRotZ(0.0f);
                low_jaw.setRotX(0.0f);
            } else if (((AbstractTrollEntity)((Object)troll)).getEatingTime() != -1) {
                head.setRotX(this.getAnimationProgress((AbstractTrollEntity)((Object)troll), animationState.getPartialTick()));
                head.setRotY((float)(troll.method_5961() ? -1 : 1) * 0.17453292f);
                head.setRotZ(0.0f);
                low_jaw.setRotX(this.getAnimationProgress((AbstractTrollEntity)((Object)troll), animationState.getPartialTick()) * 2.8f);
            } else if (animationState.isMoving() && troll.method_6510()) {
                head.setRotX((entityData.headPitch() + this.getHeadExtraInAttacking(troll)) * ((float)Math.PI / 180));
                head.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
                head.setRotZ(0.0f);
                low_jaw.setRotX(0.0f);
            } else {
                head.setRotX(entityData.headPitch() * ((float)Math.PI / 180));
                head.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
                head.setRotZ(0.0f);
                low_jaw.setRotX(0.0f);
            }
        }
        if (left_arm != null && right_arm != null && left_leg != null && right_leg != null && left_hand != null && right_hand != null) {
            if (!((AbstractTrollEntity)((Object)troll)).field_6252 && !((AbstractTrollEntity)((Object)troll)).hasBarteringItem() && ((AbstractTrollEntity)((Object)troll)).getEatingTime() == -1) {
                left_leg.setRotX((float)(-(Math.sin(animationState.getLimbSwing() * this.getLegsSpeed(troll)) * (double)(animationState.getLimbSwingAmount() * this.getLegsAmount(troll)))));
                right_leg.setRotX((float)(Math.sin(animationState.getLimbSwing() * this.getLegsSpeed(troll)) * (double)(animationState.getLimbSwingAmount() * this.getLegsAmount(troll))));
                left_arm.setRotX(GeoControllersUtil.getLimbSwing(animationState, -0.9f, 0.5f, this.getArmsSpeed(troll), this.getArmsAmount(troll), false));
                right_arm.setRotX(GeoControllersUtil.getLimbSwing(animationState, -0.5f, 0.9f, this.getArmsSpeed(troll), this.getArmsAmount(troll), true));
                if (this.hasArmZMovement(troll)) {
                    right_arm.setRotZ(GeoControllersUtil.getLimbSwing(animationState, -0.0f, 0.2f, this.getArmsSpeed(troll), this.getArmsAmount(troll), false));
                    left_arm.setRotZ(GeoControllersUtil.getLimbSwing(animationState, -0.2f, 0.0f, this.getArmsSpeed(troll), this.getArmsAmount(troll), true));
                } else {
                    right_arm.setRotZ(0.0f);
                    left_arm.setRotZ(0.0f);
                }
                left_hand.setRotX(0.0f);
                left_hand.setRotY(0.0f);
                left_hand.setRotZ(0.0f);
                right_hand.setRotX(0.0f);
                right_hand.setRotY(0.0f);
                right_hand.setRotZ(0.0f);
            } else if (((AbstractTrollEntity)((Object)troll)).hasBarteringItem()) {
                left_arm.setRotX(troll.method_5961() ? 0.0f : 0.715585f);
                left_arm.setRotY(troll.method_5961() ? 0.0f : -0.19198622f);
                left_arm.setRotZ(troll.method_5961() ? 0.0f : 0.2268928f);
                right_arm.setRotX(troll.method_5961() ? 0.715585f : 0.0f);
                right_arm.setRotY(troll.method_5961() ? 0.19198622f : 0.0f);
                right_arm.setRotZ(troll.method_5961() ? -0.2268928f : 0.0f);
                left_leg.setRotX(0.0f);
                left_leg.setRotY(0.0f);
                left_leg.setRotZ(0.0f);
                right_leg.setRotX(0.0f);
                right_leg.setRotY(0.0f);
                right_leg.setRotZ(0.0f);
                left_hand.setRotX(0.0f);
                left_hand.setRotY(0.0f);
                left_hand.setRotZ(0.0f);
                right_hand.setRotX(0.0f);
                right_hand.setRotY(0.0f);
                right_hand.setRotZ(0.0f);
            } else if (((AbstractTrollEntity)((Object)troll)).getEatingTime() != -1) {
                left_arm.setRotX(troll.method_5961() ? 0.0f : 1.2217305f + this.getAnimationProgress((AbstractTrollEntity)((Object)troll), animationState.getPartialTick()));
                left_arm.setRotY(troll.method_5961() ? 0.0f : -0.2617994f);
                left_arm.setRotZ(troll.method_5961() ? 0.0f : 0.2268928f);
                right_arm.setRotX(troll.method_5961() ? 1.2217305f + this.getAnimationProgress((AbstractTrollEntity)((Object)troll), animationState.getPartialTick()) : 0.0f);
                right_arm.setRotY(troll.method_5961() ? 0.2617994f : 0.0f);
                right_arm.setRotZ(troll.method_5961() ? 0.2268928f : 0.0f);
                left_leg.setRotX(0.0f);
                left_leg.setRotY(0.0f);
                left_leg.setRotZ(0.0f);
                right_leg.setRotX(0.0f);
                right_leg.setRotY(0.0f);
                right_leg.setRotZ(0.0f);
                left_hand.setRotX(troll.method_5961() ? 0.0f : this.getAnimationProgress((AbstractTrollEntity)((Object)troll), animationState.getPartialTick()));
                left_hand.setRotY(0.0f);
                left_hand.setRotZ(0.0f);
                right_hand.setRotX(troll.method_5961() ? this.getAnimationProgress((AbstractTrollEntity)((Object)troll), animationState.getPartialTick()) : 0.0f);
                right_hand.setRotY(0.0f);
                right_hand.setRotZ(0.0f);
            }
        }
    }

    protected float getAnimationProgress(AbstractTrollEntity troll, float partialTick) {
        float g = class_3532.method_16439((float)partialTick, (float)troll.prevEatingProgress, (float)troll.eatingProgress);
        float h = class_3532.method_16439((float)partialTick, (float)troll.prevMaxEatingDeviation, (float)troll.maxEatingDeviation);
        return (class_3532.method_15374((float)g) + 1.0f) * h;
    }
}

