/*
 * Decompiled with CFR 0.152.
 */
package TCOTS.entity.goals;

import TCOTS.entity.interfaces.ExcavatorMob;
import TCOTS.entity.interfaces.LungeMob;
import java.util.EnumSet;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;

public class LungeAttackGoal
extends class_1352 {
    private final class_1314 mob;
    private final LungeMob lungeMob;
    private final ExcavatorMob excavatorMob;
    private final int cooldownBetweenLungesAttacks;
    private final double SpeedLungeMultiplier;
    private final int minDistance;
    private final int maxDistance;
    int randomExtra;

    public LungeAttackGoal(class_1314 mob, int cooldownBetweenLungesAttacks, double lungeImpulse, int minDistance, int maxDistance) {
        this.mob = mob;
        this.excavatorMob = mob instanceof ExcavatorMob ? (ExcavatorMob)mob : null;
        if (!(mob instanceof LungeMob)) {
            throw new IllegalArgumentException("LungeAttackGoal requires Mob implements LungeMob");
        }
        this.lungeMob = (LungeMob)mob;
        this.cooldownBetweenLungesAttacks = cooldownBetweenLungesAttacks;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18407));
        this.SpeedLungeMultiplier = lungeImpulse;
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
    }

    public boolean method_6264() {
        class_1309 target = this.mob.method_5968();
        if (target != null) {
            return this.lungeMob.getNotCooldownBetweenLunges() && this.mob.method_6510() && this.mob.method_5858((class_1297)target) > (double)this.minDistance && this.mob.method_5858((class_1297)target) < (double)this.maxDistance && this.mob.method_5968().method_23318() - this.mob.method_23318() <= 1.0 && this.isExcavator();
        }
        return false;
    }

    private boolean isExcavator() {
        if (this.excavatorMob != null) {
            return !this.excavatorMob.getIsEmerging() && !this.excavatorMob.getInGround();
        }
        return true;
    }

    public boolean method_38846() {
        return true;
    }

    public void method_6269() {
        this.mob.method_5942().method_6340();
    }

    public void method_6268() {
        class_1309 livingEntity = this.mob.method_5968();
        if (livingEntity != null) {
            this.LungeAttack(livingEntity);
        }
    }

    @NotNull
    private class_243 getVec3d(class_1309 target) {
        double dXtoTarget = target.method_23317() - this.mob.method_33571().field_1352;
        double dYtoTarget = target.method_23318() - this.mob.method_33571().field_1351;
        double dZtoTarget = target.method_23321() - this.mob.method_33571().field_1350;
        double length = Math.sqrt(dXtoTarget * dXtoTarget + dYtoTarget * dYtoTarget + dZtoTarget * dZtoTarget);
        return new class_243(dXtoTarget / length * this.SpeedLungeMultiplier, dYtoTarget / length, dZtoTarget / length * this.SpeedLungeMultiplier);
    }

    private void LungeAttack(class_1309 target) {
        if (this.lungeMob.getNotCooldownBetweenLunges()) {
            this.randomExtra = this.mob.method_59922().method_43048(51);
            class_243 vec3D_lunge = this.getVec3d(target).method_1029();
            if (this.lungeMob instanceof GeoEntity) {
                ((GeoEntity)this.lungeMob).triggerAnim("LungeController", "lunge");
            }
            this.mob.method_18799(this.mob.method_18798().method_1031(vec3D_lunge.field_1352, 0.35, vec3D_lunge.field_1350));
            this.mob.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
            if (this.lungeMob.getLungeSound() != null) {
                this.mob.method_5783(this.lungeMob.getLungeSound(), 1.0f, 1.0f);
            }
            this.lungeMob.setLungeTicks(this.cooldownBetweenLungesAttacks + this.randomExtra);
            this.lungeMob.setCooldownBetweenLunges(true);
        }
    }
}

