/*
 * Decompiled with CFR 0.152.
 */
package TCOTS.entity.interfaces;

import TCOTS.entity.misc.DrownerPuddleEntity;
import TCOTS.registry.TCOTS_Sounds;
import java.util.List;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public interface ExcavatorMob {
    public static final RawAnimation DIGGING_OUT = RawAnimation.begin().thenPlayAndHold("special.diggingOut");
    public static final RawAnimation DIGGING_IN = RawAnimation.begin().thenPlayAndHold("special.diggingIn");

    default public class_238 groundBox(class_1308 mob) {
        return new class_238(mob.method_23317() - 0.39, mob.method_23318() + 0.1, mob.method_23321() - 0.39, mob.method_23317() + 0.39, mob.method_23318(), mob.method_23321() + 0.39);
    }

    default public DrownerPuddleEntity DetectOwnPuddle(class_1308 mob) {
        List list = mob.method_37908().method_8390(DrownerPuddleEntity.class, new class_238(mob.method_23317() + 2.0, mob.method_23318() + 2.0, mob.method_23321() + 2.0, mob.method_23317() - 2.0, mob.method_23318() - 2.0, mob.method_23321() - 2.0), T -> true);
        if (!list.isEmpty()) {
            for (DrownerPuddleEntity puddleEntity : list) {
                if (puddleEntity.getOwnerUUID() == null || !puddleEntity.getOwnerUUID().equals(mob.method_5667())) continue;
                return puddleEntity;
            }
        }
        return null;
    }

    default public <T extends GeoAnimatable> PlayState animationEmergingPredicate(AnimationState<T> state) {
        if (this.getIsEmerging()) {
            state.setAnimation(this.getEmergingAnimation());
            return PlayState.CONTINUE;
        }
        state.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    default public RawAnimation getEmergingAnimation() {
        return DIGGING_OUT;
    }

    default public RawAnimation getDiggingAnimation() {
        return DIGGING_IN;
    }

    default public <T extends GeoAnimatable> PlayState animationDiggingPredicate(AnimationState<T> state) {
        if (this.getInGround() && !this.getIsEmerging()) {
            state.setAnimation(this.getDiggingAnimation());
            return PlayState.CONTINUE;
        }
        state.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    default public DrownerPuddleEntity getPuddle() {
        return null;
    }

    default public void setPuddle(DrownerPuddleEntity puddle) {
    }

    default public class_3414 getEmergingSound() {
        return TCOTS_Sounds.getSoundEvent("monster_emerging");
    }

    default public class_3414 getDiggingSound() {
        return TCOTS_Sounds.getSoundEvent("monster_digging");
    }

    default public boolean getSpawnedPuddleDataTracker() {
        return false;
    }

    default public void setSpawnedPuddleDataTracker(boolean puddleSpawned) {
    }

    public int getAnimationParticlesTicks();

    public void setAnimationParticlesTicks(int var1);

    default public void tickExcavator(class_1309 entity) {
        if (this.getAnimationParticlesTicks() > 0 && this.getInGround() && !this.getIsEmerging()) {
            this.spawnGroundParticles(entity);
            this.setAnimationParticlesTicks(this.getAnimationParticlesTicks() - 1);
        } else if (this.getAnimationParticlesTicks() == 0) {
            this.setInvisibleData(true);
            this.setAnimationParticlesTicks(-1);
        }
        if (!this.getInGround() && !this.getIsEmerging()) {
            this.setAnimationParticlesTicks(36);
        }
        if (this.getIsEmerging()) {
            this.spawnGroundParticles(entity);
        }
    }

    default public void tickPuddle(class_1308 mob) {
        if (this.getPuddle() == null) {
            this.setPuddle(this.DetectOwnPuddle(mob));
        }
    }

    public boolean getInGround();

    public void setInGround(boolean var1);

    public boolean getIsEmerging();

    public void setIsEmerging(boolean var1);

    default public void spawnGroundParticles(@NotNull class_1309 entity) {
        class_2680 blockState = entity.method_25936();
        if (blockState.method_26217() != class_2464.field_11455) {
            for (int i = 0; i < 11; ++i) {
                double d = entity.method_23317() + (double)class_3532.method_32750((class_5819)entity.method_59922(), (float)-0.7f, (float)0.7f);
                double e = entity.method_23318();
                double f = entity.method_23321() + (double)class_3532.method_32750((class_5819)entity.method_59922(), (float)-0.7f, (float)0.7f);
                entity.method_37908().method_8406((class_2394)new class_2388(class_2398.field_11217, blockState), d, e, f, 0.0, 0.0, 0.0);
            }
        }
    }

    public int getReturnToGround_Ticks();

    public void setReturnToGround_Ticks(int var1);

    public boolean getInvisibleData();

    public void setInvisibleData(boolean var1);

    default public void mobTickExcavator(@Nullable List<class_6862<class_2248>> blockTags, @Nullable List<class_2248> blocks, class_1308 mob) {
        if (this.getReturnToGround_Ticks() > 0 && !this.getIsEmerging() && !mob.method_6510()) {
            this.setReturnToGround_Ticks(this.getReturnToGround_Ticks() - 1);
        } else if (this.getReturnToGround_Ticks() == 0 && this.checkBlocks(blockTags, blocks, mob)) {
            this.setInGround(true);
        }
    }

    private boolean checkBlocks(@Nullable List<class_6862<class_2248>> blockTags, @Nullable List<class_2248> blocks, class_1308 mob) {
        class_2338 entityPos = new class_2338((int)mob.method_23317(), (int)mob.method_23318(), (int)mob.method_23321());
        class_2338 entityDown = entityPos.method_10074();
        class_1937 world = mob.method_37908();
        if (blockTags != null) {
            for (class_6862<class_2248> tags : blockTags) {
                if (!world.method_8320(entityDown).method_26164(tags)) continue;
                return true;
            }
        }
        if (blocks != null) {
            for (class_2248 block : blocks) {
                if (!world.method_8320(entityDown).method_27852(block)) continue;
                return true;
            }
        }
        return false;
    }
}

