/*
 * Decompiled with CFR 0.152.
 */
package TCOTS.entity.misc;

import TCOTS.entity.ogroids.IceGiantEntity;
import TCOTS.items.weapons.GiantAnchorItem;
import TCOTS.registry.TCOTS_DamageTypes;
import TCOTS.registry.TCOTS_Entities;
import TCOTS.registry.TCOTS_Sounds;
import TCOTS.utils.EntitiesUtil;
import TCOTS.utils.GeoControllersUtil;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3483;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AnchorProjectileEntity
extends class_1676
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected static final class_2940<Float> FALLING_DISTANCE = class_2945.method_12791(AnchorProjectileEntity.class, (class_2941)class_2943.field_13320);
    protected static final class_2940<Boolean> ENCHANTED = class_2945.method_12791(AnchorProjectileEntity.class, (class_2941)class_2943.field_13323);
    public class_1665.class_1666 pickupType = class_1665.class_1666.field_7592;
    @Nullable
    private class_2680 inBlockState;
    protected boolean inGround;
    protected int inGroundTime;
    public int shake;
    private double damage = 8.0;
    private class_3414 sound = this.getHitSound();
    public boolean dealtDamage;
    public float bodyYaw;
    public float prevBodyYaw;
    private static final byte FALLING_PARTICLES = 42;

    public AnchorProjectileEntity(class_1299<? extends class_1676> entityType, class_1937 world) {
        super(entityType, world);
    }

    public AnchorProjectileEntity(class_1309 thrower, class_1937 world) {
        this(TCOTS_Entities.AnchorProjectile(), world);
        this.method_7432((class_1297)thrower);
        this.method_5814(thrower.method_23317(), thrower.method_23320(), thrower.method_23321());
        this.pickupType = class_1665.class_1666.field_7592;
    }

    public void setSound(class_3414 sound) {
        this.sound = sound;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(FALLING_DISTANCE, (Object)Float.valueOf(this.field_6017));
        builder.method_56912(ENCHANTED, (Object)false);
    }

    public void setFallingDistance(float fallingDistance) {
        this.field_6011.method_12778(FALLING_DISTANCE, (Object)Float.valueOf(fallingDistance));
    }

    public float getFallingDistance() {
        return ((Float)this.field_6011.method_12789(FALLING_DISTANCE)).floatValue();
    }

    public void setEnchanted(boolean enchanted) {
        this.field_6011.method_12778(ENCHANTED, (Object)enchanted);
    }

    public boolean isEnchanted() {
        return (Boolean)this.field_6011.method_12789(ENCHANTED);
    }

    public void method_7485(double x, double y, double z, float speed, float divergence) {
        super.method_7485(x, y, z, speed, divergence);
    }

    public void method_5750(double x, double y, double z) {
        super.method_5750(x, y, z);
    }

    private void returnToOwnerLogic() {
        class_1297 class_12972;
        if (this.method_24921() == null || !((class_12972 = this.method_24921()) instanceof class_1309)) {
            return;
        }
        class_1309 owner = (class_1309)class_12972;
        if (this.method_5739((class_1297)owner) > 20.0f) {
            GiantAnchorItem.retrieveAnchor(owner);
        }
        if (!(owner.method_6047().method_7909() instanceof GiantAnchorItem) && !(owner.method_6079().method_7909() instanceof GiantAnchorItem) && owner.method_24515().method_46558() != this.method_24515().method_46558()) {
            GiantAnchorItem.retrieveAnchor(owner);
        }
        if (this.method_5739((class_1297)owner) > 8.0f && this.method_24828()) {
            GiantAnchorItem.retrieveAnchor(owner);
        }
    }

    public void method_5773() {
        class_243 vec3d2;
        class_265 voxelShape;
        List ownerDetection;
        if (this.method_24921() != null && !(this.method_24921() instanceof IceGiantEntity)) {
            this.setDamage(this.method_5869() ? 12.0 : 8.0);
        }
        if (!this.method_37908().field_9236 && (this.method_24921() == null || this.method_24921() != null && !this.method_24921().method_5805())) {
            this.method_31472();
        }
        if (this.method_24921() != null && this.pickupType.equals((Object)class_1665.class_1666.field_7593) && !(ownerDetection = this.method_37908().method_8390(class_1309.class, this.method_5829().method_1009(0.5, 0.5, 0.5), entity -> entity == this.method_24921() && !(entity instanceof IceGiantEntity))).isEmpty()) {
            this.method_31472();
        }
        this.setFallingDistance(this.field_6017);
        if (!this.method_24828() || this.method_18798().method_37268() > (double)1.0E-5f) {
            this.method_5784(class_1313.field_6308, this.method_18798());
        }
        this.returnToOwnerLogic();
        if (this.inGroundTime > 4) {
            this.dealtDamage = true;
        }
        super.method_5773();
        class_243 vec3d = this.method_18798();
        if (this.field_6004 == 0.0f && this.field_5982 == 0.0f) {
            double d = vec3d.method_37267();
            this.method_36456((float)(class_3532.method_15349((double)vec3d.field_1352, (double)vec3d.field_1350) * 57.2957763671875));
            this.method_36457((float)(class_3532.method_15349((double)vec3d.field_1351, (double)d) * 57.2957763671875));
            this.field_5982 = this.method_36454();
            this.field_6004 = this.method_36455();
        }
        class_2338 blockPos = this.method_24515();
        class_2680 blockState = this.method_37908().method_8320(blockPos);
        if (!blockState.method_26215() && !(voxelShape = blockState.method_26220((class_1922)this.method_37908(), blockPos)).method_1110()) {
            vec3d2 = this.method_19538();
            for (class_238 box : voxelShape.method_1090()) {
                if (!box.method_996(blockPos).method_1006(vec3d2)) continue;
                this.inGround = true;
                break;
            }
        }
        if (this.shake > 0) {
            --this.shake;
        }
        if (this.inGround) {
            if (this.inBlockState != blockState && this.shouldContinueFall()) {
                this.fall();
            }
            ++this.inGroundTime;
            return;
        }
        this.inGroundTime = 0;
        class_243 vec3d3 = this.method_19538();
        vec3d2 = vec3d3.method_1019(vec3d);
        class_3965 hitResult = this.method_37908().method_17742(new class_3959(vec3d3, vec3d2, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
        if (hitResult.method_17783() != class_239.class_240.field_1333) {
            vec3d2 = hitResult.method_17784();
        }
        while (!this.method_31481()) {
            class_3966 entityHitResult = this.getEntityCollision(vec3d3, vec3d2);
            if (entityHitResult != null) {
                hitResult = entityHitResult;
            }
            if (hitResult != null && hitResult.method_17783() == class_239.class_240.field_1331 && hitResult instanceof class_3966) {
                class_1297 entity2 = ((class_3966)hitResult).method_17782();
                class_1297 entity22 = this.method_24921();
                if (entity2 instanceof class_1657 && entity22 instanceof class_1657 && !((class_1657)entity22).method_7256((class_1657)entity2)) {
                    hitResult = null;
                    entityHitResult = null;
                }
            }
            if (hitResult != null) {
                this.method_7488((class_239)hitResult);
                this.field_6007 = true;
            }
            if (entityHitResult == null) break;
            hitResult = null;
        }
        vec3d = this.method_18798();
        double e = vec3d.field_1352;
        double f = vec3d.field_1351;
        double g = vec3d.field_1350;
        double h = this.method_23317() + e;
        double j = this.method_23318() + f;
        double k = this.method_23321() + g;
        double l = vec3d.method_37267();
        this.method_36456((float)(class_3532.method_15349((double)e, (double)g) * 57.2957763671875));
        this.method_36457((float)(class_3532.method_15349((double)f, (double)l) * 57.2957763671875));
        this.method_36457(class_1665.method_26960((float)this.field_6004, (float)this.method_36455()));
        this.method_36456(class_1665.method_26960((float)this.field_5982, (float)this.method_36454()));
        float m = 0.99f;
        if (this.method_5799()) {
            for (int o = 0; o < 4; ++o) {
                float p = 0.25f;
                this.method_37908().method_8406((class_2394)class_2398.field_11247, h - e * (double)p, j - f * (double)p, k - g * (double)p, e, f, g);
            }
            m = this.getDragInWater();
        }
        this.method_18799(vec3d.method_1021((double)m));
        if (!this.method_5740()) {
            class_243 vec3d4 = this.method_18798();
            this.method_18800(vec3d4.field_1352, vec3d4.field_1351 - (double)0.05f, vec3d4.field_1350);
        }
        this.method_5814(h, j, k);
        this.method_5852();
        this.prevBodyYaw = this.bodyYaw;
        while (this.bodyYaw - this.prevBodyYaw < -180.0f) {
            this.prevBodyYaw -= 360.0f;
        }
        while (this.bodyYaw - this.prevBodyYaw >= 180.0f) {
            this.prevBodyYaw += 360.0f;
        }
    }

    private boolean shouldContinueFall() {
        return this.inGround && this.method_37908().method_18026(new class_238(this.method_19538(), this.method_19538()).method_1014(0.06));
    }

    private void fall() {
        this.inGround = false;
        class_243 vec3d = this.method_18798();
        this.method_18799(vec3d.method_18805((double)(this.field_5974.method_43057() * 0.2f), (double)(this.field_5974.method_43057() * 0.2f), (double)(this.field_5974.method_43057() * 0.2f)));
    }

    public void method_5784(@NotNull class_1313 movementType, @NotNull class_243 movement) {
        super.method_5784(movementType, movement);
        if (movementType != class_1313.field_6308 && this.shouldContinueFall()) {
            this.fall();
        }
    }

    protected void method_7454(class_3966 entityHitResult) {
        class_1297 entity = entityHitResult.method_17782();
        class_1297 entity2 = this.method_24921();
        class_1282 damageSource = TCOTS_DamageTypes.anchorDamage(this.method_37908(), (class_1297)this, (class_1297)(entity2 == null ? this : entity2));
        this.dealtDamage = true;
        if (entity.method_5643(damageSource, this.getDamage())) {
            if (entity.method_5864() == class_1299.field_6091) {
                return;
            }
            class_1937 class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                class_1890.method_60619((class_3218)serverWorld, (class_1297)entity, (class_1282)damageSource, (class_1799)this.method_59958());
            }
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                this.knockback(livingEntity, damageSource);
                this.onHit(livingEntity);
            }
        } else if (entity.method_5864().method_20210(class_3483.field_48286)) {
            this.deflect();
            return;
        }
        this.method_5783(TCOTS_Sounds.getSoundEvent("anchor_impact"), 1.0f, 1.0f);
    }

    public void deflect() {
        float f = this.field_5974.method_43057() * 360.0f;
        this.method_18799(this.method_18798().method_1024(f * ((float)Math.PI / 180)).method_1021(0.5));
        this.method_36456(this.method_36454() + f);
        this.field_5982 += f;
    }

    protected void method_24920(class_3965 blockHitResult) {
        this.inBlockState = this.method_37908().method_8320(blockHitResult.method_17777());
        super.method_24920(blockHitResult);
        class_243 vec3d = blockHitResult.method_17784().method_1023(this.method_23317(), this.method_23318(), this.method_23321());
        this.method_18799(vec3d);
        class_243 vec3d2 = vec3d.method_1029().method_1021((double)0.05f);
        this.method_23327(this.method_23317() - vec3d2.field_1352, this.method_23318() - vec3d2.field_1351, this.method_23321() - vec3d2.field_1350);
        this.method_5783(this.getSound(), 1.0f, 1.2f / (this.field_5974.method_43057() * 0.2f + 0.9f));
        this.inGround = true;
        this.shake = 7;
        this.setSound(TCOTS_Sounds.getSoundEvent("anchor_impact"));
    }

    private void groundAttack() {
        if (this.method_37908().field_9236 || !this.method_24828() || this.dealtDamage) {
            return;
        }
        this.method_18799(class_243.field_1353);
        EntitiesUtil.pushAndDamageEntities((class_1297)this, Math.min(this.getDamage() + this.getFallingDistance() * 0.5f, 50.0f), (double)(0.8f + this.getFallingDistance() * 0.5f), 3.0, 1.5, TCOTS_DamageTypes.anchorDamage(this.method_37908(), (class_1297)this, (class_1297)(this.method_24921() == null ? this : this.method_24921())), AnchorProjectileEntity.class, this.method_24921().getClass());
        this.method_5783(TCOTS_Sounds.getSoundEvent("big_impact"), 1.0f, 1.0f);
        this.method_37908().method_8421((class_1297)this, (byte)42);
        this.dealtDamage = true;
    }

    public void method_38785() {
        this.groundAttack();
        super.method_38785();
    }

    public void method_5711(byte status) {
        if (status == 42) {
            double radius = 0.8f + this.getFallingDistance() * 0.5f;
            EntitiesUtil.spawnImpactParticles((class_1297)this, radius, this.getFallingDistance(), Math.max((double)(20.0f + this.getFallingDistance()), Math.PI * 2 * radius));
        } else {
            super.method_5711(status);
        }
    }

    protected class_3414 getHitSound() {
        return TCOTS_Sounds.getSoundEvent("anchor_impact");
    }

    protected final class_3414 getSound() {
        return this.sound;
    }

    protected void knockback(class_1309 target, class_1282 source) {
    }

    protected void onHit(class_1309 target) {
    }

    @Nullable
    protected class_3966 getEntityCollision(class_243 currentPosition, class_243 nextPosition) {
        if (this.dealtDamage) {
            return null;
        }
        return class_1675.method_18077((class_1937)this.method_37908(), (class_1297)this, (class_243)currentPosition, (class_243)nextPosition, (class_238)this.method_5829().method_18804(this.method_18798()).method_1014(1.0), this::method_26958);
    }

    protected boolean method_26958(@NotNull class_1297 entity) {
        return super.method_26958(entity);
    }

    public void method_5652(@NotNull class_2487 nbt) {
        super.method_5652(nbt);
        if (this.inBlockState != null) {
            nbt.method_10566("inBlockState", (class_2520)class_2512.method_10686((class_2680)this.inBlockState));
        }
        nbt.method_10567("shake", (byte)this.shake);
        nbt.method_10556("inGround", this.inGround);
        nbt.method_10549("damage", this.damage);
        nbt.method_10582("SoundEvent", Objects.requireNonNull(class_7923.field_41172.method_10221((Object)this.sound)).toString());
        nbt.method_10556("DealtDamage", this.dealtDamage);
        nbt.method_10567("pickup", (byte)this.pickupType.ordinal());
        nbt.method_10556("IsEnchanted", this.isEnchanted());
    }

    public void method_5749(@NotNull class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10573("inBlockState", 10)) {
            this.inBlockState = class_2512.method_10681((class_7871)this.method_37908().method_45448(class_7924.field_41254), (class_2487)nbt.method_10562("inBlockState"));
        }
        this.shake = nbt.method_10571("shake") & 0xFF;
        this.inGround = nbt.method_10577("inGround");
        if (nbt.method_10573("damage", 99)) {
            this.damage = nbt.method_10574("damage");
        }
        if (nbt.method_10573("SoundEvent", 8)) {
            this.sound = class_7923.field_41172.method_17966(class_2960.method_60654((String)nbt.method_10558("SoundEvent"))).orElse(this.getHitSound());
        }
        this.dealtDamage = nbt.method_10577("DealtDamage");
        this.pickupType = class_1665.class_1666.method_7458((int)nbt.method_10571("pickup"));
        this.setEnchanted(nbt.method_10577("IsEnchanted"));
    }

    public void method_7432(@Nullable class_1297 entity) {
        super.method_7432(entity);
        this.setPlayerAnchor(this);
    }

    private void setPlayerAnchor(@Nullable AnchorProjectileEntity anchor) {
        class_1297 class_12972;
        if (this.method_24921() == null || !((class_12972 = this.method_24921()) instanceof class_1309)) {
            return;
        }
        class_1309 livingEntity = (class_1309)class_12972;
        livingEntity.theConjunctionOfTheSpheres$setAnchor((Object)anchor);
    }

    public void method_36209() {
        this.setPlayerAnchor(null);
    }

    public void method_5650(@NotNull class_1297.class_5529 reason) {
        this.setPlayerAnchor(null);
        super.method_5650(reason);
    }

    public void method_5694(@NotNull class_1657 player) {
        if (this.method_37908().field_9236 || !this.inGround || this.shake > 0) {
            return;
        }
        if (this.method_24921() == player) {
            player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), TCOTS_Sounds.getSoundEvent("anchor_chain"), player.method_5634(), 1.0f, 1.0f);
            this.method_31472();
        }
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28630;
    }

    public void setDamage(double damage) {
        this.damage = damage;
    }

    public float getDamage() {
        return (float)this.damage;
    }

    public boolean method_5732() {
        return false;
    }

    protected float getDragInWater() {
        return 0.8f;
    }

    public boolean method_5727(double cameraX, double cameraY, double cameraZ) {
        return true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(GeoControllersUtil.genericIdleController(this));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

