/*
 * Decompiled with CFR 0.152.
 */
package TCOTS.entity.necrophages;

import TCOTS.entity.goals.LungeAttackGoal;
import TCOTS.entity.goals.ReturnToNestGoal;
import TCOTS.entity.necrophages.GhoulEntity;
import TCOTS.items.concoctions.bombs.MoonDustBomb;
import TCOTS.registry.TCOTS_Sounds;
import TCOTS.utils.GeoControllersUtil;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1429;
import net.minecraft.class_1430;
import net.minecraft.class_1439;
import net.minecraft.class_1452;
import net.minecraft.class_1472;
import net.minecraft.class_1507;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2743;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3988;
import net.minecraft.class_4760;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5136;
import net.minecraft.class_6053;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AlghoulEntity
extends GhoulEntity
implements GeoEntity {
    public final int GHOUL_REGENERATION_TIME = 300;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final RawAnimation SCREAM = RawAnimation.begin().thenPlay("special.scream");
    protected static final class_2940<Boolean> SPIKED = class_2945.method_12791(AlghoulEntity.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Integer> TIME_FOR_SPIKES = class_2945.method_12791(AlghoulEntity.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Boolean> IS_SCREAMING = class_2945.method_12791(AlghoulEntity.class, (class_2941)class_2943.field_13323);
    private int cooldownForScream;
    boolean hasCooldownForScream = false;
    int counter;

    @Override
    public int getRegenerationTime() {
        return 300;
    }

    public AlghoulEntity(class_1299<? extends AlghoulEntity> entityType, class_1937 world) {
        super((class_1299<? extends GhoulEntity>)entityType, world);
        this.field_6194 = 10;
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1429.method_26828().method_26868(class_5134.field_23716, 30.0).method_26868(class_5134.field_23721, 6.0).method_26868(class_5134.field_23719, (double)0.29f).method_26868(class_5134.field_23718, (double)0.3f);
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new AlghoulSpikedRegeneration(this, 500, 300, 0.5f, 60, 1200));
        this.field_6201.method_6277(2, (class_1352)new AlghoulCall(this, 300, 30));
        this.field_6201.method_6277(3, (class_1352)new LungeAttackGoal((class_1314)this, 200, 1.3, 15, 40));
        this.field_6201.method_6277(4, (class_1352)new GhoulEntity.Ghoul_MeleeAttackGoal((class_1314)this, 1.2, false));
        this.field_6201.method_6277(5, (class_1352)new GhoulEntity.GhoulGoForFlesh(this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new ReturnToNestGoal((class_1314)this, 0.75));
        this.field_6201.method_6277(7, (class_1352)new class_1379((class_1314)this, 0.75, 80));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(0, (class_1352)new class_1399((class_1314)this, new Class[]{GhoulEntity.class}));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1642.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_5136.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1507.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_3988.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
        this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, class_4760.class, true));
        this.field_6185.method_6277(5, (class_1352)new class_1400((class_1308)this, class_1430.class, true));
        this.field_6185.method_6277(5, (class_1352)new class_1400((class_1308)this, class_1452.class, true));
        this.field_6185.method_6277(5, (class_1352)new class_1400((class_1308)this, class_1472.class, true));
        this.field_6185.method_6277(6, (class_1352)new class_1400((class_1308)this, class_6053.class, true));
    }

    @Override
    public boolean method_5810() {
        if (this.getIsInvokingRegen() || this.getIsScreaming()) {
            return false;
        }
        return super.method_5810();
    }

    @Override
    protected void method_5693(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(SPIKED, (Object)Boolean.FALSE);
        builder.method_56912(TIME_FOR_SPIKES, (Object)0);
        builder.method_56912(IS_SCREAMING, (Object)Boolean.FALSE);
    }

    public void setCooldownForScream(int cooldownForRegen) {
        this.cooldownForScream = cooldownForRegen;
    }

    public int getCooldownForScream() {
        return this.cooldownForScream;
    }

    public boolean hasCooldownForScream() {
        return this.hasCooldownForScream;
    }

    public void setHasCooldownForScream(boolean hasCooldownForRegen) {
        this.hasCooldownForScream = hasCooldownForRegen;
    }

    public boolean getIsSpiked() {
        return (Boolean)this.field_6011.method_12789(SPIKED);
    }

    public void setIsSpiked(boolean isSpiked) {
        this.field_6011.method_12778(SPIKED, (Object)isSpiked);
    }

    protected void setTimeForSpikes(int timeForSpikes) {
        this.field_6011.method_12778(TIME_FOR_SPIKES, (Object)timeForSpikes);
    }

    protected int getTimeForSpikes() {
        return (Integer)this.field_6011.method_12789(TIME_FOR_SPIKES);
    }

    public void setIsScreaming(boolean isScreaming) {
        this.field_6011.method_12778(IS_SCREAMING, (Object)isScreaming);
    }

    public boolean getIsScreaming() {
        return (Boolean)this.field_6011.method_12789(IS_SCREAMING);
    }

    public boolean method_5679(@NotNull class_1282 damageSource) {
        return super.method_5679(damageSource) || this.getIsInvokingRegen();
    }

    @Override
    public void method_5652(@NotNull class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("Spiked", this.getIsSpiked());
        nbt.method_10569("SpikedTime", this.getTimeForSpikes());
        nbt.method_10569("ScreamCooldown", this.getCooldownForScream());
        nbt.method_10556("CooldownScreamActive", this.hasCooldownForScream());
    }

    @Override
    public void method_5749(@NotNull class_2487 nbt) {
        super.method_5749(nbt);
        this.setIsSpiked(nbt.method_10577("Spiked"));
        this.setTimeForSpikes(nbt.method_10550("SpikedTime"));
        this.setCooldownForScream(nbt.method_10550("ScreamCooldown"));
        this.setHasCooldownForScream(nbt.method_10577("CooldownScreamActive"));
    }

    @Override
    public void method_5773() {
        if (this.getIsSpiked() && MoonDustBomb.checkEffectAndSplinters((class_1309)this)) {
            this.setIsSpiked(false);
        }
        if (this.counter > 0) {
            this.counter = 0;
        }
        this.tickTimersAlghoul();
        if (this.getIsInvokingRegen()) {
            this.spawnSmokeParticles(this.counter);
        }
        if (this.getIsScreaming()) {
            this.spawnSmokeParticles(this.counter);
        }
        super.method_5773();
    }

    private void tickTimersAlghoul() {
        if (this.getCooldownForScream() > 0) {
            this.setCooldownForScream(this.getCooldownForScream() - 1);
        } else if (this.hasCooldownForScream()) {
            this.setHasCooldownForScream(false);
        }
        if (this.getTimeForSpikes() > 0) {
            this.setTimeForSpikes(this.getTimeForSpikes() - 1);
        } else if (this.getIsSpiked()) {
            if (!this.method_5701()) {
                this.method_5783(TCOTS_Sounds.getSoundEvent("alghoul_spikes"), 1.0f, 1.0f);
            }
            this.setIsSpiked(false);
        }
    }

    private void spawnSmokeParticles(int counter) {
        class_243 vec3d = this.method_5829().method_1005();
        while (counter < 20) {
            double d = this.field_5974.method_43059() * 0.2;
            double e = this.field_5974.method_43059() * 0.2;
            double f = this.field_5974.method_43059() * 0.2;
            this.method_37908().method_8406((class_2394)class_2398.field_46911, vec3d.field_1352, vec3d.field_1351, vec3d.field_1350, d, e, f);
            ++counter;
        }
    }

    @Override
    protected void spawnItemParticles(class_1799 stack) {
        for (int i = 0; i < 5; ++i) {
            class_243 vec3dVelocity = new class_243(((double)this.field_5974.method_43057() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).method_1037(-this.method_36455() * ((float)Math.PI / 180)).method_1024(-this.method_36454() * ((float)Math.PI / 180));
            class_243 vec3dPos = new class_243(((double)this.field_5974.method_43057() - 0.5) * 0.1, (double)(-this.field_5974.method_43057()) * 0.01, 1.2 + ((double)this.field_5974.method_43057() - 0.5) * 0.1).method_1024(-this.field_6283 * ((float)Math.PI / 180)).method_1031(this.method_23317(), this.method_23320() - 0.15, this.method_23321());
            this.method_37908().method_8406((class_2394)new class_2392(class_2398.field_11218, stack), vec3dPos.field_1352, vec3dPos.field_1351, vec3dPos.field_1350, vec3dVelocity.field_1352, vec3dVelocity.field_1351 + 0.05, vec3dVelocity.field_1350);
        }
    }

    public boolean method_5643(@NotNull class_1282 source, float amount) {
        class_1297 class_12972;
        if (this.getIsSpiked() && source.method_5529() != null && (class_12972 = source.method_5529()) instanceof class_1309) {
            class_1309 attacker = (class_1309)class_12972;
            if (!(source.method_5526() instanceof class_1676) && !(source.method_5526() instanceof class_1665) && amount > 0.0f) {
                float mirrorDamage = amount * 0.6f < 18.0f ? amount * 0.6f : 18.0f;
                attacker.method_5643(attacker.method_48923().method_48818((class_1297)this), mirrorDamage);
                this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14663, this.method_5634(), 1.0f, 1.0f);
            }
        }
        return super.method_5643(source, amount);
    }

    @Override
    protected int getTotalEatingTime() {
        return 10 + this.method_59922().method_39332(0, 8);
    }

    @Override
    @Nullable
    protected class_3414 method_6011(@NotNull class_1282 source) {
        return TCOTS_Sounds.getSoundEvent("alghoul_hurt");
    }

    @Override
    @Nullable
    protected class_3414 method_6002() {
        return TCOTS_Sounds.getSoundEvent("alghoul_death");
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "Idle/Walk", 5, GeoControllersUtil::idleWalkRunController));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "AttackController", 1, state -> PlayState.STOP).triggerableAnim("attack1", GeoControllersUtil.ATTACK1).triggerableAnim("attack2", GeoControllersUtil.ATTACK2));
        this.lungeAnimationController(this, controllerRegistrar);
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "RegenController", 1, state -> {
            state.setControllerSpeed(0.5f);
            return PlayState.STOP;
        }).triggerableAnim("start_regen", START_REGEN));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "ScreamController", 1, state -> PlayState.STOP).triggerableAnim("scream", SCREAM));
    }

    @Override
    @Nullable
    protected class_3414 method_5994() {
        return TCOTS_Sounds.getSoundEvent("alghoul_idle");
    }

    @Override
    @Nullable
    public class_3414 getLungeSound() {
        return TCOTS_Sounds.getSoundEvent("alghoul_lunge");
    }

    @Override
    @Nullable
    protected class_3414 getAttackSound() {
        return TCOTS_Sounds.getSoundEvent("alghoul_attack");
    }

    @Override
    protected class_3414 getScreamSound() {
        return TCOTS_Sounds.getSoundEvent("alghoul_scream");
    }

    @Override
    public class_3414 getRegeneratingSound() {
        return TCOTS_Sounds.getSoundEvent("alghoul_regen");
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private static class AlghoulSpikedRegeneration
    extends GhoulEntity.GhoulRegeneration {
        private final int TimeForSpikes;
        private final AlghoulEntity mob;

        public AlghoulSpikedRegeneration(AlghoulEntity mob, int CooldownBetweenRegens, int TimeForRegen, float HealthPercentageToStart, int stopTicks, int TimeForSpikes) {
            super(mob, 0, CooldownBetweenRegens, TimeForRegen, HealthPercentageToStart, stopTicks);
            this.TimeForSpikes = TimeForSpikes;
            this.mob = mob;
        }

        @Override
        public void method_6270() {
            if (!this.mob.getIsSpiked()) {
                this.mob.setIsSpiked(true);
                if (!this.mob.method_5701()) {
                    this.mob.method_5783(TCOTS_Sounds.getSoundEvent("alghoul_spikes"), 1.0f, 1.0f);
                }
            }
            this.mob.setTimeForSpikes(this.TimeForSpikes);
            this.mob.setHasCooldownForScream(true);
            this.mob.setCooldownForScream(50);
            super.method_6270();
        }

        @Override
        public void method_6269() {
            super.method_6269();
            this.pushEntities(5.0, 2.0, 5.0, 1.0);
        }

        @Override
        public void method_6268() {
            this.pushEntities(3.0, 1.0, 3.0, 0.1);
            super.method_6268();
        }

        private void pushEntities(double xExpansion, double yExpansion, double zExpansion, double knockbackStrength) {
            List listMobs = this.mob.method_37908().method_8390(class_1309.class, this.mob.method_5829().method_1009(xExpansion, yExpansion, zExpansion), livingEntity -> !(livingEntity instanceof GhoulEntity));
            for (class_1309 entity : listMobs) {
                double d = this.mob.method_23317() - entity.method_23317();
                double e = this.mob.method_23321() - entity.method_23321();
                entity.method_6005(knockbackStrength, d, e);
                if (!(entity instanceof class_3222) || ((class_3222)entity).method_7337()) continue;
                ((class_3222)entity).field_13987.method_52391((class_2596)new class_2743((class_1297)entity), null);
            }
        }

        @Override
        protected boolean canStartRegen() {
            return !this.mob.getIsRegenerating() && this.mob.method_6032() < this.mob.method_6063() * this.healthPercentage && this.mob.method_24828() && !this.mob.hasCooldownForRegen() && !MoonDustBomb.checkEffectAndSplinters((class_1309)this.mob);
        }
    }

    private static class AlghoulCall
    extends class_1352 {
        private final AlghoulEntity alghoul;
        private final int cooldownForScream;
        private final int stopTicks;
        private int StoppedTicks;

        public AlghoulCall(AlghoulEntity alghoul, int cooldownForScream, int stopTicks) {
            this.alghoul = alghoul;
            this.cooldownForScream = cooldownForScream;
            this.stopTicks = stopTicks;
        }

        public boolean method_6264() {
            List<GhoulEntity> listGhouls = this.generateGhoulList();
            return (this.alghoul.getIsSpiked() || this.alghoul.method_6510()) && !listGhouls.isEmpty() && !this.alghoul.hasCooldownForScream() && this.alghoul.method_24828() && !MoonDustBomb.checkEffectAndSplinters((class_1309)this.alghoul);
        }

        public boolean method_6266() {
            List<GhoulEntity> listGhouls = this.generateGhoulList();
            return !listGhouls.isEmpty() && !this.alghoul.hasCooldownForScream() && !MoonDustBomb.checkEffectAndSplinters((class_1309)this.alghoul);
        }

        public boolean method_38846() {
            return true;
        }

        public void method_6269() {
            this.StoppedTicks = this.stopTicks;
            this.alghoul.method_5942().method_6340();
            this.alghoul.method_5783(this.alghoul.getScreamSound(), 1.0f, 1.0f);
            this.alghoul.setIsScreaming(true);
            this.pushEntities();
            this.alghoul.triggerAnim("ScreamController", "scream");
            super.method_6269();
        }

        public void method_6270() {
            this.alghoul.setCooldownForScream(this.cooldownForScream);
            this.alghoul.setHasCooldownForScream(true);
            this.StoppedTicks = this.stopTicks;
            this.alghoul.setIsScreaming(false);
        }

        public void method_6268() {
            if (this.StoppedTicks > 0) {
                this.alghoul.method_5942().method_6340();
                --this.StoppedTicks;
            } else {
                this.method_6270();
            }
            List<GhoulEntity> listGhouls = this.generateGhoulList();
            for (GhoulEntity ghoul : listGhouls) {
                ghoul.setTimeForRegen(200);
                ghoul.setIsRegenerating(!MoonDustBomb.checkEffectAndSplinters((class_1309)ghoul));
                if (ghoul.method_5701()) continue;
                this.alghoul.method_37908().method_8421((class_1297)ghoul, (byte)99);
            }
            super.method_6268();
        }

        private void pushEntities() {
            List listMobs = this.alghoul.method_37908().method_8390(class_1309.class, this.alghoul.method_5829().method_1009(5.0, 2.0, 5.0), livingEntity -> !(livingEntity instanceof GhoulEntity));
            for (class_1309 entity : listMobs) {
                double d = this.alghoul.method_23317() - entity.method_23317();
                double e = this.alghoul.method_23321() - entity.method_23321();
                entity.method_6005(0.5, d, e);
                if (!(entity instanceof class_3222) || ((class_3222)entity).method_7337()) continue;
                ((class_3222)entity).field_13987.method_52391((class_2596)new class_2743((class_1297)entity), null);
            }
        }

        private List<GhoulEntity> generateGhoulList() {
            return this.alghoul.method_37908().method_8390(GhoulEntity.class, this.alghoul.method_5829().method_1009(5.0, 2.0, 5.0), ghoul -> !(ghoul instanceof AlghoulEntity) && !ghoul.getIsRegenerating());
        }
    }
}

