/*
 * Decompiled with CFR 0.152.
 */
package TCOTS.entity.necrophages;

import TCOTS.entity.misc.FoglingEntity;
import TCOTS.entity.necrophages.NecrophageMonster;
import TCOTS.items.concoctions.bombs.MoonDustBomb;
import TCOTS.registry.TCOTS_Entities;
import TCOTS.registry.TCOTS_Particles;
import TCOTS.registry.TCOTS_Sounds;
import TCOTS.utils.GeoControllersUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1429;
import net.minecraft.class_1439;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2404;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3726;
import net.minecraft.class_3730;
import net.minecraft.class_3988;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FogletEntity
extends NecrophageMonster
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final RawAnimation IDLE = RawAnimation.begin().thenLoop("idle");
    public static final RawAnimation WALKING = RawAnimation.begin().thenLoop("move.walking");
    public static final RawAnimation TRIGGER_FOG = RawAnimation.begin().thenPlay("special.fog");
    protected static final class_2940<Boolean> ACTIVATES_FOG = class_2945.method_12791(FogletEntity.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Float> ALPHA_VALUE = class_2945.method_12791(FogletEntity.class, (class_2941)class_2943.field_13320);
    List<FoglingEntity> foglingsList = new ArrayList<FoglingEntity>();
    private int AnimationTicks = -1;
    List<FogletEntity> fogletList = new ArrayList<FogletEntity>();
    List<FogletEntity> fogletLeader = new ArrayList<FogletEntity>();
    boolean leader;
    protected boolean canGenerateFog = true;

    public FogletEntity(class_1299<? extends FogletEntity> entityType, class_1937 world) {
        super((class_1299<? extends NecrophageMonster>)entityType, world);
        this.method_5941(class_7.field_18, 0.2f);
        this.field_6194 = 8;
    }

    public int method_5986() {
        return 50;
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new Foglet_Swim((class_1308)this));
        this.field_6201.method_6277(1, new Foglet_AttackWithFog<FogletEntity>(this, 1.0, false, 100));
        this.field_6201.method_6277(2, (class_1352)new class_1379((class_1314)this, 0.75, 20));
        this.field_6201.method_6277(3, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(0, (class_1352)new class_1399((class_1314)this, new Class[]{FogletEntity.class}));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_3988.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1429.method_26828().method_26868(class_5134.field_23716, 25.0).method_26868(class_5134.field_23721, 4.0).method_26868(class_5134.field_23719, (double)0.21f).method_26868(class_5134.field_23718, (double)0.3f);
    }

    @Override
    public boolean method_6049(class_1293 effect) {
        return effect.method_5579() != class_1294.field_5905 && super.method_6049(effect);
    }

    public int getAnimationTicks() {
        return this.AnimationTicks;
    }

    public void setAnimationTicks(int animationTicks) {
        this.AnimationTicks = animationTicks;
    }

    protected void spawnFogParticlesItself() {
        if (this.field_6012 % 12 == 0) {
            double d = this.method_23317() + (double)class_3532.method_32750((class_5819)this.method_59922(), (float)-0.8f, (float)0.8f);
            double e = this.method_23320() - 0.5 + (double)class_3532.method_32750((class_5819)this.method_59922(), (float)-1.0f, (float)1.0f);
            double f = this.method_23321() + (double)class_3532.method_32750((class_5819)this.method_59922(), (float)-0.8f, (float)0.8f);
            this.method_37908().method_8406((class_2394)TCOTS_Particles.FogletFog(), d, e, f, 0.0, 0.0, 0.0);
        }
    }

    private void spawnFogParticlesAround() {
        if (this.field_6012 % 8 == 0) {
            double d = this.method_23317() + (double)class_3532.method_32750((class_5819)this.method_59922(), (float)-10.0f, (float)10.0f);
            double e = this.method_23320() - 0.5 + (double)class_3532.method_32750((class_5819)this.method_59922(), (float)-1.0f, (float)1.0f);
            double f = this.method_23321() + (double)class_3532.method_32750((class_5819)this.method_59922(), (float)-10.0f, (float)10.0f);
            this.method_37908().method_8406((class_2394)TCOTS_Particles.FogletFogAround(), d, e, f, 0.0, 0.0, 0.0);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "Idle/Walk/Run", 5, state -> {
            if (this.method_6510() && state.isMoving()) {
                state.setControllerSpeed(1.0f);
                return state.setAndContinue(WALKING);
            }
            if (state.isMoving()) {
                state.setControllerSpeed(0.5f);
                return state.setAndContinue(WALKING);
            }
            state.setControllerSpeed(1.0f);
            return state.setAndContinue(IDLE);
        }));
        controllers.add(new AnimationController((GeoAnimatable)this, "AttackController", 1, state -> PlayState.STOP).triggerableAnim("attack1", GeoControllersUtil.ATTACK1).triggerableAnim("attack2", GeoControllersUtil.ATTACK2));
        controllers.add(new AnimationController((GeoAnimatable)this, "FogController", 1, state -> {
            if (this.getIsFog()) {
                return state.setAndContinue(TRIGGER_FOG);
            }
            state.getController().forceAnimationReset();
            return PlayState.CONTINUE;
        }));
    }

    private void getOtherFoglet() {
        if (this.canGenerateFog && this.method_6510()) {
            this.fogletList.clear();
            this.fogletList = this.method_37908().method_8390(FogletEntity.class, this.method_5829().method_1009(20.0, 20.0, 20.0), foglet -> foglet != this);
            this.fogletList.forEach(fogletEntity -> {
                fogletEntity.canGenerateFog = false;
            });
            this.leader = true;
        }
    }

    private void getFogletLeader() {
        if (!this.canGenerateFog && this.method_6510()) {
            this.fogletLeader.clear();
            this.fogletLeader = this.method_37908().method_8390(FogletEntity.class, this.method_5829().method_1009(20.0, 20.0, 20.0), foglet -> foglet.leader && foglet != this);
            if (this.fogletLeader.isEmpty()) {
                this.canGenerateFog = true;
            }
        }
    }

    public void method_5773() {
        if (this.method_5767()) {
            this.spawnFogParticlesItself();
        }
        if (this.getIsFog() && MoonDustBomb.checkEffectAndSplinters((class_1309)this)) {
            this.setIsFog(false);
        }
        if (!(this instanceof FoglingEntity)) {
            this.getOtherFoglet();
            this.getFogletLeader();
            this.getFoglings();
            if ((this.method_37908().field_9236 || !MoonDustBomb.checkEffectAndSplinters((class_1309)this)) && this.method_37908().field_9236 && this.method_6510() && this.canGenerateFog) {
                this.spawnFogParticlesAround();
            }
        }
        if (this.getIsFog() && this.getAlphaValue() > 0.0f) {
            this.setAlphaValue(this.getAlphaValue() - 0.05f);
        } else if (!this.getIsFog() && (double)this.getAlphaValue() < 0.9) {
            this.setAlphaValue(this.getAlphaValue() + 0.1f);
        }
        if (this.getIsFog() && !this.method_6510()) {
            this.setIsFog(false);
        }
        if (this.getAnimationTicks() > 0 && !this.method_6510()) {
            this.setAnimationTicks(-1);
        }
        this.updateFloating();
        this.method_5852();
        super.method_5773();
    }

    private void getFoglings() {
        if (this.method_6510() && this.foglingsList.isEmpty()) {
            this.foglingsList = this.method_37908().method_8390(FoglingEntity.class, this.method_5829().method_1009(20.0, 20.0, 20.0), fogling -> fogling.method_24921() != null && fogling.method_24921().method_5667() == this.method_5667());
        }
    }

    public final boolean getIsFog() {
        return (Boolean)this.field_6011.method_12789(ACTIVATES_FOG);
    }

    public final void setIsFog(boolean wasFog) {
        this.field_6011.method_12778(ACTIVATES_FOG, (Object)wasFog);
    }

    public float getAlphaValue() {
        return ((Float)this.field_6011.method_12789(ALPHA_VALUE)).floatValue();
    }

    public void setAlphaValue(float AlphaValue) {
        this.field_6011.method_12778(ALPHA_VALUE, (Object)Float.valueOf(AlphaValue));
    }

    protected void method_5693(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ACTIVATES_FOG, (Object)Boolean.FALSE);
        builder.method_56912(ALPHA_VALUE, (Object)Float.valueOf(1.0f));
    }

    public void method_5652(@NotNull class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("InFog", ((Boolean)this.field_6011.method_12789(ACTIVATES_FOG)).booleanValue());
        nbt.method_10548("AlphaValue", ((Float)this.field_6011.method_12789(ALPHA_VALUE)).floatValue());
    }

    public void method_5749(class_2487 nbt) {
        this.setIsFog(nbt.method_10577("InFog"));
        this.setAlphaValue(nbt.method_10583("AlphaValue"));
        super.method_5749(nbt);
    }

    protected class_3414 method_5994() {
        return TCOTS_Sounds.getSoundEvent("foglet_idle");
    }

    public boolean method_26319(class_3610 state) {
        return (state.method_15767(class_3486.field_15518) || state.method_15767(class_3486.field_15517)) && this.getIsFog();
    }

    protected void updateFloating() {
        if ((this.method_5771() || this.method_5799()) && this.getIsFog()) {
            class_3726 shapeContext = class_3726.method_16195((class_1297)this);
            if (!shapeContext.method_16192(class_2404.field_24412, this.method_24515(), true) || this.method_37908().method_8316(this.method_24515().method_10084()).method_15767(class_3486.field_15518) || this.method_37908().method_8316(this.method_24515().method_10084()).method_15767(class_3486.field_15517)) {
                this.method_18799(this.method_18798().method_1021(0.5).method_1031(0.0, 0.05, 0.0));
            } else {
                this.method_24830(true);
            }
        }
    }

    public boolean method_5799() {
        return !this.field_5953 && this.field_5964.getDouble((Object)class_3486.field_15517) > 0.0;
    }

    public boolean method_5753() {
        return super.method_5753() || this.getIsFog();
    }

    @NotNull
    protected class_3414 method_6011(@NotNull class_1282 source) {
        return TCOTS_Sounds.getSoundEvent("foglet_hurt");
    }

    @NotNull
    protected class_3414 method_6002() {
        return TCOTS_Sounds.getSoundEvent("foglet_death");
    }

    @Override
    protected class_3414 getAttackSound() {
        return TCOTS_Sounds.getSoundEvent("foglet_attack");
    }

    public boolean method_5643(@NotNull class_1282 source, float amount) {
        if (this.getIsFog()) {
            amount /= 8.0f;
        }
        return super.method_5643(source, amount);
    }

    public void method_6078(@NotNull class_1282 damageSource) {
        if (!this.foglingsList.isEmpty()) {
            this.foglingsList.forEach(foglingEntity -> foglingEntity.method_5643(this.method_48923().method_48831(), 10.0f));
        }
        super.method_6078(damageSource);
    }

    public boolean method_5679(@NotNull class_1282 damageSource) {
        return this.getAnimationTicks() > 0 || this.getIsFog() || super.method_5679(damageSource);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected static class Foglet_Swim
    extends class_1347 {
        FogletEntity foglet;

        public Foglet_Swim(class_1308 mob) {
            super(mob);
            this.foglet = (FogletEntity)mob;
        }

        public boolean method_6264() {
            return super.method_6264() && !this.foglet.getIsFog();
        }

        public boolean method_6266() {
            return super.method_6266() && !this.foglet.getIsFog();
        }
    }

    protected static class Foglet_AttackWithFog<T extends class_1309>
    extends class_1352 {
        private final T actor;
        private final class_1314 mob;
        private double targetX;
        private double targetY;
        private double targetZ;
        private int updateCountdownTicks;
        private int cooldown;
        public final double speed;
        private final boolean pauseWhenMobIdle;
        private final int ticksBeforeSummon;
        private int TicksBeforeFoglings = -1;
        int tickBeforeFog = 40;
        private boolean attack = false;
        private int ticksBeforeAttack = 40;

        public Foglet_AttackWithFog(T actor, double speed, boolean pauseWhenMobIdle, int ticksBeforeSummon) {
            this.actor = actor;
            this.mob = (class_1314)actor;
            this.pauseWhenMobIdle = pauseWhenMobIdle;
            this.speed = speed;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
            this.ticksBeforeSummon = ticksBeforeSummon;
        }

        public boolean method_6264() {
            return ((class_1308)this.actor).method_5968() != null;
        }

        public boolean method_6266() {
            return this.method_6264() || !((class_1308)this.actor).method_5942().method_6357();
        }

        public void method_6269() {
            super.method_6269();
            ((class_1308)this.actor).method_19540(true);
            this.tickBeforeFog = 40;
        }

        public void method_6270() {
            super.method_6270();
            ((class_1308)this.actor).method_19540(false);
            ((FogletEntity)((Object)this.actor)).setIsFog(false);
            if (this.actor.method_5767()) {
                this.actor.method_5648(false);
            }
            if (((FogletEntity)((Object)this.actor)).getAnimationTicks() > 0) {
                ((FogletEntity)((Object)this.actor)).setAnimationTicks(-1);
            }
            if (!((FogletEntity)((Object)this.actor)).foglingsList.isEmpty()) {
                ((FogletEntity)((Object)this.actor)).foglingsList.forEach(foglingEntity -> foglingEntity.method_5643(this.actor.method_48923().method_48831(), 10.0f));
            }
            ((FogletEntity)((Object)this.actor)).foglingsList.clear();
            this.TicksBeforeFoglings = -1;
        }

        public boolean method_38846() {
            return true;
        }

        public void method_6268() {
            class_1309 livingEntity = ((class_1308)this.actor).method_5968();
            if (livingEntity == null) {
                return;
            }
            if (!(this.actor instanceof FoglingEntity)) {
                for (int i = 0; i < ((FogletEntity)((Object)this.actor)).foglingsList.size(); ++i) {
                    if (((FogletEntity)((Object)this.actor)).foglingsList.get(i).method_5805()) continue;
                    ((FogletEntity)((Object)this.actor)).foglingsList.remove(i);
                }
                if (((FogletEntity)((Object)this.actor)).foglingsList.size() == 2) {
                    this.TicksBeforeFoglings = this.ticksBeforeSummon;
                }
                this.TicksBeforeFoglings = this.TicksBeforeFoglings > 0 ? --this.TicksBeforeFoglings : -1;
            }
            if (!MoonDustBomb.checkEffectAndSplinters(this.actor)) {
                this.generatesFog(livingEntity);
            }
            if ((this.actor.method_5767() || this.attack) && this.tickBeforeFog <= -1 || MoonDustBomb.checkEffectAndSplinters(this.actor)) {
                this.meleeAttack(livingEntity);
            }
            if (this.attack) {
                --this.ticksBeforeAttack;
            } else if (this.tickBeforeFog == -2) {
                this.tickBeforeFog = 20;
            }
            if (this.ticksBeforeAttack == 0) {
                this.attack = false;
            }
        }

        private double getSpeed() {
            if (((FogletEntity)((Object)this.actor)).getIsFog()) {
                return this.speed * 1.5;
            }
            return this.speed;
        }

        private void generatesFog(class_1309 livingEntity) {
            if (this.tickBeforeFog > 0) {
                ((class_1308)this.actor).method_5962().method_6243(-0.5f, 0.0f);
                ((class_1308)this.actor).method_5951((class_1297)livingEntity, 30.0f, 30.0f);
            }
            if (this.tickBeforeFog > 0) {
                --this.tickBeforeFog;
            }
            if (this.tickBeforeFog == 0) {
                ((FogletEntity)((Object)this.actor)).setIsFog(true);
                this.actor.method_5783(TCOTS_Sounds.getSoundEvent("foglet_fog"), 1.0f, 1.0f);
                ((FogletEntity)((Object)this.actor)).setAnimationTicks(24);
                this.tickBeforeFog = -1;
            }
            if (((FogletEntity)((Object)this.actor)).getAnimationTicks() > 0) {
                ((FogletEntity)((Object)this.actor)).setAnimationTicks(((FogletEntity)((Object)this.actor)).getAnimationTicks() - 1);
            } else if (((FogletEntity)((Object)this.actor)).getAnimationTicks() == 0) {
                if (!(this.actor instanceof FoglingEntity) && this.TicksBeforeFoglings == -1) {
                    this.generateFoglings();
                }
                this.actor.method_5648(true);
                ((FogletEntity)((Object)this.actor)).setAnimationTicks(-1);
            }
        }

        private void generateFoglings() {
            class_3218 serverWorld = (class_3218)this.actor.method_37908();
            if (((FogletEntity)((Object)this.actor)).foglingsList.size() < 2) {
                for (int j = ((FogletEntity)((Object)this.actor)).foglingsList.size(); j < 2; ++j) {
                    class_2338 blockPos = this.actor.method_24515().method_10069(-2 + this.actor.method_59922().method_43048(5), 0, -2 + this.actor.method_59922().method_43048(5));
                    FoglingEntity foglingEntity = (FoglingEntity)TCOTS_Entities.Fogling().method_5883(this.actor.method_37908());
                    if (foglingEntity == null) continue;
                    foglingEntity.method_5725(blockPos, 0.0f, 0.0f);
                    foglingEntity.method_5943((class_5425)serverWorld, this.actor.method_37908().method_8404(blockPos), class_3730.field_16471, null);
                    foglingEntity.setOwner((class_1308)this.actor);
                    serverWorld.method_30771((class_1297)foglingEntity);
                    ((FogletEntity)((Object)this.actor)).foglingsList.add(foglingEntity);
                }
            }
        }

        private void meleeAttack(class_1309 livingEntity) {
            this.mob.method_5988().method_6226((class_1297)livingEntity, 30.0f, 30.0f);
            double d = this.mob.method_5858((class_1297)livingEntity);
            this.updateCountdownTicks = Math.max(this.updateCountdownTicks - 1, 0);
            if ((this.pauseWhenMobIdle || this.mob.method_5985().method_6369((class_1297)livingEntity)) && this.updateCountdownTicks <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || livingEntity.method_5649(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.mob.method_59922().method_43057() < 0.05f)) {
                this.targetX = livingEntity.method_23317();
                this.targetY = livingEntity.method_23318();
                this.targetZ = livingEntity.method_23321();
                this.updateCountdownTicks = 4 + this.mob.method_59922().method_43048(7);
                if (d > 1024.0) {
                    this.updateCountdownTicks += 10;
                } else if (d > 256.0) {
                    this.updateCountdownTicks += 5;
                }
                if (!this.mob.method_5942().method_6335((class_1297)livingEntity, this.getSpeed())) {
                    this.updateCountdownTicks += 15;
                }
                this.updateCountdownTicks = this.method_38847(this.updateCountdownTicks);
            }
            this.cooldown = Math.max(this.cooldown - 1, 0);
            this.attack(livingEntity, d);
        }

        protected void attack(class_1309 target, double squaredDistance) {
            double d = this.getSquaredMaxAttackDistance(target);
            if (squaredDistance <= d && this.cooldown <= 0) {
                this.resetCooldown();
                this.mob.method_6104(class_1268.field_5808);
                class_1314 class_13142 = this.mob;
                if (class_13142 instanceof GeoEntity) {
                    GeoEntity geo = (GeoEntity)class_13142;
                    int randomAttack = this.mob.method_59922().method_39332(0, 1);
                    if (randomAttack == 0) {
                        geo.triggerAnim("AttackController", "attack1");
                    } else {
                        geo.triggerAnim("AttackController", "attack2");
                    }
                }
                this.mob.method_6121((class_1297)target);
                ((FogletEntity)((Object)this.actor)).setIsFog(false);
                this.actor.method_5648(false);
                this.attack = true;
                if (this.ticksBeforeAttack == 0) {
                    this.ticksBeforeAttack = 40;
                }
                this.tickBeforeFog = -2;
            }
        }

        protected double getSquaredMaxAttackDistance(class_1309 entity) {
            return this.mob.method_17681() * 2.0f * (this.mob.method_17681() * 2.0f) + entity.method_17681();
        }

        protected void resetCooldown() {
            this.cooldown = this.method_38847(20);
        }
    }
}

