/*
 * Decompiled with CFR 0.152.
 */
package TCOTS.entity.necrophages;

import TCOTS.entity.goals.AttackOwnerAttackerTarget;
import TCOTS.entity.goals.AttackOwnerEnemyTarget;
import TCOTS.entity.goals.FollowMonsterOwnerGoal;
import TCOTS.entity.goals.LungeAttackGoal;
import TCOTS.entity.goals.MeleeAttackGoal_Animated;
import TCOTS.entity.goals.ReturnToNestGoal;
import TCOTS.entity.interfaces.GuardNestMob;
import TCOTS.entity.interfaces.LungeMob;
import TCOTS.entity.necrophages.AlghoulEntity;
import TCOTS.entity.necrophages.NecrophageMonster;
import TCOTS.items.concoctions.bombs.MoonDustBomb;
import TCOTS.registry.TCOTS_Entities;
import TCOTS.registry.TCOTS_Sounds;
import TCOTS.utils.EntitiesUtil;
import TCOTS.utils.GeoControllersUtil;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_11;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1430;
import net.minecraft.class_1439;
import net.minecraft.class_1452;
import net.minecraft.class_1472;
import net.minecraft.class_1507;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1839;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3988;
import net.minecraft.class_4174;
import net.minecraft.class_4760;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5136;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6053;
import net.minecraft.class_8046;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GhoulEntity
extends NecrophageMonster
implements GeoEntity,
LungeMob,
class_8046,
GuardNestMob {
    public static final byte GHOUL_REGENERATING = 99;
    public final int GHOUL_REGENERATION_TIME = 200;
    private static final class_2940<class_2338> NEST_POS = class_2945.method_12791(GhoulEntity.class, (class_2941)class_2943.field_13324);
    protected static final class_2940<Boolean> CAN_HAVE_NEST = class_2945.method_12791(GhoulEntity.class, (class_2941)class_2943.field_13323);
    @Nullable
    private class_1308 owner;
    @Nullable
    private UUID ownerUuid;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final RawAnimation START_REGEN = RawAnimation.begin().thenPlay("special.regen");
    protected static final class_2940<Boolean> LUGGING = class_2945.method_12791(GhoulEntity.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Boolean> REGENERATING = class_2945.method_12791(GhoulEntity.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Boolean> INVOKING_REGENERATING = class_2945.method_12791(GhoulEntity.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Integer> TIME_FOR_REGEN = class_2945.method_12791(GhoulEntity.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Integer> EATING_TIME = class_2945.method_12791(GhoulEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2382 ITEM_PICKUP_RANGE_EXPANDER = new class_2382(1, 1, 1);
    boolean hasCooldownForRegen = false;
    public boolean cooldownBetweenLunges = false;
    private int cooldownForRegen;
    public int LungeTicks;

    public int getRegenerationTime() {
        return 200;
    }

    public GhoulEntity(class_1299<? extends GhoulEntity> entityType, class_1937 world) {
        super((class_1299<? extends NecrophageMonster>)entityType, world);
        this.method_5952(true);
    }

    public int method_5986() {
        return 50;
    }

    protected void method_5693(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(LUGGING, (Object)Boolean.FALSE);
        builder.method_56912(REGENERATING, (Object)Boolean.FALSE);
        builder.method_56912(INVOKING_REGENERATING, (Object)Boolean.FALSE);
        builder.method_56912(TIME_FOR_REGEN, (Object)0);
        builder.method_56912(NEST_POS, (Object)class_2338.field_10980);
        builder.method_56912(CAN_HAVE_NEST, (Object)Boolean.FALSE);
        builder.method_56912(EATING_TIME, (Object)-1);
    }

    public int method_5978() {
        return 15;
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new GhoulRegeneration(this, 60, 400, 200, 0.5f, 35));
        this.field_6201.method_6277(2, (class_1352)new LungeAttackGoal((class_1314)this, 100, 1.2, 10, 30));
        this.field_6201.method_6277(3, (class_1352)new Ghoul_MeleeAttackGoal((class_1314)this, 1.2, false));
        this.field_6201.method_6277(4, (class_1352)new GhoulGoForFlesh(this, 1.0));
        this.field_6201.method_6277(5, (class_1352)new ReturnToNestGoal((class_1314)this, 0.75));
        this.field_6201.method_6277(6, (class_1352)new FollowMonsterOwnerGoal((class_1314)this, 0.75));
        this.field_6201.method_6277(7, (class_1352)new class_1379((class_1314)this, 0.75, 80));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(0, (class_1352)new AttackOwnerAttackerTarget((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new AttackOwnerEnemyTarget((class_1308)this));
        this.field_6185.method_6277(2, (class_1352)new class_1399((class_1314)this, new Class[]{GhoulEntity.class}));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1642.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_5136.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1507.class, true));
        this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, class_3988.class, true));
        this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
        this.field_6185.method_6277(5, (class_1352)new class_1400((class_1308)this, class_4760.class, true));
        this.field_6185.method_6277(6, (class_1352)new class_1400((class_1308)this, class_1430.class, true));
        this.field_6185.method_6277(6, (class_1352)new class_1400((class_1308)this, class_1452.class, true));
        this.field_6185.method_6277(6, (class_1352)new class_1400((class_1308)this, class_1472.class, true));
        this.field_6185.method_6277(7, (class_1352)new class_1400((class_1308)this, class_6053.class, true));
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1429.method_26828().method_26868(class_5134.field_23716, 18.0).method_26868(class_5134.field_23721, 4.0).method_26868(class_5134.field_23719, (double)0.29f);
    }

    @Override
    public boolean getExtraReasonToNotGoToNest() {
        List listFlesh = this.method_37908().method_8390(class_1542.class, this.method_5829().method_1009(8.0, 2.0, 8.0), itemEntity -> GhoulEntity.isEdibleMeat(itemEntity.method_6983()));
        return this.method_24921() == null && listFlesh.isEmpty();
    }

    @Override
    public class_2338 getNestPos() {
        return (class_2338)this.field_6011.method_12789(NEST_POS);
    }

    @Override
    public void setNestPos(class_2338 pos) {
        this.field_6011.method_12778(NEST_POS, (Object)pos);
    }

    @Override
    public boolean canHaveNest() {
        return (Boolean)this.field_6011.method_12789(CAN_HAVE_NEST);
    }

    @Override
    public void setCanHaveNest(boolean canHaveNest) {
        this.field_6011.method_12778(CAN_HAVE_NEST, (Object)canHaveNest);
    }

    @NotNull
    protected class_2382 method_42646() {
        return ITEM_PICKUP_RANGE_EXPANDER;
    }

    protected int getTotalEatingTime() {
        return 20 + this.method_59922().method_39332(0, 10);
    }

    public void setEatingTime(int eatingTime) {
        this.field_6011.method_12778(EATING_TIME, (Object)eatingTime);
    }

    public int getEatingTime() {
        return (Integer)this.field_6011.method_12789(EATING_TIME);
    }

    public void addEatingTime() {
        this.setEatingTime(this.getEatingTime() + 1);
    }

    public boolean method_20820(@NotNull class_1799 stack) {
        return this.method_37908().method_8450().method_8355(class_1928.field_19388) && GhoulEntity.isEdibleMeat(stack) && this.method_5998(class_1268.field_5808).method_31574(class_1799.field_8037.method_7909());
    }

    private static boolean isEdibleMeat(class_1799 stack) {
        return stack.method_31574(class_1802.field_8511) || stack.method_31574(class_1802.field_8046) || stack.method_31574(class_1802.field_8389) || stack.method_31574(class_1802.field_8748);
    }

    protected void method_5949(@NotNull class_1542 item) {
        this.method_29499(item);
        this.handleItemFromGround(item);
    }

    private void handleItemFromGround(class_1542 item) {
        this.method_6103((class_1297)item, 1);
        class_1799 itemStack = EntitiesUtil.getItemFromStack(item);
        this.method_6122(class_1268.field_5808, itemStack);
        this.setEatingTime(0);
    }

    private void tickEatingItem() {
        if (this.getEatingTime() < this.getTotalEatingTime() && this.getEatingTime() != -1) {
            class_1799 foodStack = this.method_5998(class_1268.field_5808);
            this.addEatingTime();
            if (foodStack.method_7976() == class_1839.field_8950 && this.getEatingTime() % 5 == 0) {
                this.spawnItemParticles(foodStack);
                this.method_5783(this.method_18869(foodStack), 0.5f + 0.5f * (float)this.field_5974.method_43048(2), (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
            }
        } else if (this.getEatingTime() == this.getTotalEatingTime()) {
            this.handleEndsFeed(this.method_5998(class_1268.field_5808));
        }
    }

    private void handleEndsFeed(class_1799 foodStack) {
        if (!this.method_37908().field_9236) {
            if (foodStack.method_57826(class_9334.field_50075)) {
                this.method_6025((float)Objects.requireNonNull((class_4174)foodStack.method_57824(class_9334.field_50075)).comp_2491() / 2.0f);
            }
            this.method_6122(class_1268.field_5808, class_1799.field_8037);
            this.setEatingTime(-1);
        }
    }

    public boolean method_5810() {
        if (this.getIsInvokingRegen()) {
            return false;
        }
        return super.method_5810();
    }

    public static boolean canSpawnGhoul(class_1299<? extends NecrophageMonster> type, class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        if (spawnReason == class_3730.field_16469) {
            return world.method_8407() != class_1267.field_5801;
        }
        return world.method_8407() != class_1267.field_5801 && class_1588.method_20679((class_5425)world, (class_2338)pos, (class_5819)random) && class_1588.method_20636(type, (class_1936)world, (class_3730)spawnReason, (class_2338)pos, (class_5819)random) && pos.method_10264() >= 0;
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, @NotNull class_1266 difficulty, @NotNull class_3730 spawnReason, @Nullable class_1315 entityData) {
        AlghoulEntity alghoul;
        class_5819 random = world.method_8409();
        if (spawnReason != class_3730.field_16465 && spawnReason != class_3730.field_16474 && random.method_43054() % 5 == 0 && (alghoul = (AlghoulEntity)TCOTS_Entities.Alghoul().method_5883(this.method_37908())) != null) {
            alghoul.method_5808(this.method_23317(), this.method_23318(), this.method_23321(), this.method_36454(), 0.0f);
            this.method_37908().method_8649((class_1297)alghoul);
        }
        if (spawnReason == class_3730.field_16469 || spawnReason == class_3730.field_16474) {
            this.setCanHaveNest(true);
        }
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "Idle/Walk", 5, GeoControllersUtil::idleWalkRunController));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "AttackController", 1, state -> PlayState.STOP).triggerableAnim("attack1", GeoControllersUtil.ATTACK1).triggerableAnim("attack2", GeoControllersUtil.ATTACK2));
        this.lungeAnimationController(this, controllerRegistrar);
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "RegenController", 1, state -> PlayState.STOP).triggerableAnim("start_regen", START_REGEN));
    }

    @Nullable
    public class_1297 method_24921() {
        class_1297 entity;
        if (this.owner == null && this.ownerUuid != null && this.method_37908() instanceof class_3218 && (entity = ((class_3218)this.method_37908()).method_14190(this.ownerUuid)) instanceof class_1309) {
            this.owner = (class_1308)entity;
        }
        return this.owner;
    }

    public void setOwner(@Nullable class_1308 owner) {
        this.owner = owner;
        this.ownerUuid = owner == null ? null : owner.method_5667();
    }

    public boolean hasCooldownForRegen() {
        return this.hasCooldownForRegen;
    }

    public void setHasCooldownForRegen(boolean hasCooldownForRegen) {
        this.hasCooldownForRegen = hasCooldownForRegen;
    }

    protected void spawnItemParticles(class_1799 stack) {
        for (int i = 0; i < 5; ++i) {
            class_243 vec3dVelocity = new class_243(((double)this.field_5974.method_43057() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).method_1037(-this.method_36455() * ((float)Math.PI / 180)).method_1024(-this.method_36454() * ((float)Math.PI / 180));
            class_243 vec3dPos = new class_243(((double)this.field_5974.method_43057() - 0.5) * 0.1, (double)(-this.field_5974.method_43057()) * 0.01, 0.95 + ((double)this.field_5974.method_43057() - 0.5) * 0.1).method_1024(-this.field_6283 * ((float)Math.PI / 180)).method_1031(this.method_23317(), this.method_23320() - 0.15, this.method_23321());
            this.method_37908().method_8406((class_2394)new class_2392(class_2398.field_11218, stack), vec3dPos.field_1352, vec3dPos.field_1351, vec3dPos.field_1350, vec3dVelocity.field_1352, vec3dVelocity.field_1351 + 0.05, vec3dVelocity.field_1350);
        }
    }

    public void method_5773() {
        if (this.getIsRegenerating() && MoonDustBomb.checkEffectAndSplinters((class_1309)this)) {
            this.setIsRegenerating(false);
        }
        this.tickLunge();
        if (this.getIsRegenerating() && this.field_6012 % 10 == 0 && this.method_6032() < this.method_6063()) {
            this.method_6025(1.0f);
        }
        this.timersTick();
        this.tickGuardNest((class_1314)this);
        this.tickEatingItem();
        super.method_5773();
    }

    protected void method_5958() {
        List list;
        super.method_5958();
        if (!(this instanceof AlghoulEntity) && this.method_24921() == null && !(list = this.method_37908().method_8390(AlghoulEntity.class, this.method_5829().method_1009(10.0, 10.0, 10.0), alghoul -> true)).isEmpty()) {
            this.setOwner((class_1308)list.getFirst());
        }
        if (this.method_24921() != null && !this.method_24921().method_5805()) {
            this.setOwner(null);
        }
    }

    private void timersTick() {
        if (this.getTimeForRegen() > 0) {
            this.setTimeForRegen(this.getTimeForRegen() - 1);
        } else if (this.getIsRegenerating()) {
            this.setIsRegenerating(false);
        }
        if (this.getCooldownForRegen() > 0) {
            this.setCooldownForRegen(this.getCooldownForRegen() - 1);
        } else if (this.hasCooldownForRegen()) {
            this.setHasCooldownForRegen(false);
        }
    }

    @Override
    public boolean getNotCooldownBetweenLunges() {
        return !this.cooldownBetweenLunges;
    }

    @Override
    public void setCooldownBetweenLunges(boolean cooldownBetweenLunges) {
        this.cooldownBetweenLunges = cooldownBetweenLunges;
    }

    public boolean getIsRegenerating() {
        return (Boolean)this.field_6011.method_12789(REGENERATING);
    }

    public void setIsRegenerating(boolean isRegenerating) {
        this.field_6011.method_12778(REGENERATING, (Object)isRegenerating);
    }

    public boolean getIsInvokingRegen() {
        return (Boolean)this.field_6011.method_12789(INVOKING_REGENERATING);
    }

    public void setIsInvokingRegen(boolean isRegenerating) {
        this.field_6011.method_12778(INVOKING_REGENERATING, (Object)isRegenerating);
    }

    public void setCooldownForRegen(int cooldownForRegen) {
        this.cooldownForRegen = cooldownForRegen;
    }

    public int getCooldownForRegen() {
        return this.cooldownForRegen;
    }

    protected void setTimeForRegen(int timeForRegen) {
        this.field_6011.method_12778(TIME_FOR_REGEN, (Object)timeForRegen);
    }

    protected int getTimeForRegen() {
        return (Integer)this.field_6011.method_12789(TIME_FOR_REGEN);
    }

    public void method_5652(@NotNull class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("Regeneration", this.getIsRegenerating());
        nbt.method_10569("CooldownRegen", this.getCooldownForRegen());
        nbt.method_10556("CooldownRegenActive", this.hasCooldownForRegen);
        nbt.method_10569("RegenerationTime", this.getTimeForRegen());
        if (this.ownerUuid != null) {
            nbt.method_25927("Owner", this.ownerUuid);
        }
        nbt.method_10569("EatingTime", this.getEatingTime());
        this.writeNbtGuardNest(nbt);
    }

    public void method_5749(@NotNull class_2487 nbt) {
        super.method_5749(nbt);
        this.setIsRegenerating(nbt.method_10577("Regeneration"));
        this.setCooldownForRegen(nbt.method_10550("CooldownRegen"));
        this.setTimeForRegen(nbt.method_10550("RegenerationTime"));
        this.setHasCooldownForRegen(nbt.method_10577("CooldownRegenActive"));
        if (nbt.method_25928("Owner")) {
            this.ownerUuid = nbt.method_25926("Owner");
        }
        this.setEatingTime(nbt.method_10550("EatingTime"));
        this.readNbtGuardNest(nbt);
    }

    @Nullable
    protected class_3414 method_6011(@NotNull class_1282 source) {
        return TCOTS_Sounds.getSoundEvent("ghoul_hurt");
    }

    @Nullable
    protected class_3414 method_6002() {
        return TCOTS_Sounds.getSoundEvent("ghoul_death");
    }

    @Nullable
    protected class_3414 method_5994() {
        return TCOTS_Sounds.getSoundEvent("ghoul_idle");
    }

    @Override
    public class_3414 getLungeSound() {
        return TCOTS_Sounds.getSoundEvent("ghoul_lunge");
    }

    @Override
    protected class_3414 getAttackSound() {
        return TCOTS_Sounds.getSoundEvent("ghoul_attack");
    }

    protected class_3414 getScreamSound() {
        return TCOTS_Sounds.getSoundEvent("ghoul_scream");
    }

    public class_3414 getRegeneratingSound() {
        return TCOTS_Sounds.getSoundEvent("ghoul_regen");
    }

    @Override
    public int getLungeTicks() {
        return this.LungeTicks;
    }

    @Override
    public void setLungeTicks(int lungeTicks) {
        this.LungeTicks = lungeTicks;
    }

    public void method_5990() {
        if (this.method_37908().field_9236) {
            class_2680 blockState = this.method_25936();
            if (blockState.method_26217() != class_2464.field_11455) {
                for (int i = 0; i < 40; ++i) {
                    double d = this.method_23317() + (double)class_3532.method_32750((class_5819)this.field_5974, (float)-0.7f, (float)0.7f);
                    double e = this.method_23318() + 0.5;
                    double f = this.method_23321() + (double)class_3532.method_32750((class_5819)this.field_5974, (float)-0.7f, (float)0.7f);
                    this.method_37908().method_8406((class_2394)new class_2388(class_2398.field_11217, blockState), d, e, f, 0.0, 0.0, 0.0);
                }
            }
        } else {
            this.method_37908().method_8421((class_1297)this, (byte)20);
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected static class GhoulRegeneration
    extends class_1352 {
        private final int ticksAttackedBeforeRegen;
        private final int CooldownBetweenRegens;
        private final int TimeForRegen;
        private final GhoulEntity mob;
        private final int stopTicks;
        protected final float healthPercentage;
        private int StoppedTicks;

        public GhoulRegeneration(GhoulEntity mob, int ticksAttackedBeforeRegen, int CooldownBetweenRegens, int TimeForRegen, float HealthPercentageToStart, int stopTicks) {
            this.ticksAttackedBeforeRegen = ticksAttackedBeforeRegen;
            this.mob = mob;
            this.CooldownBetweenRegens = CooldownBetweenRegens;
            this.TimeForRegen = TimeForRegen;
            this.healthPercentage = HealthPercentageToStart;
            this.stopTicks = stopTicks;
        }

        public boolean method_6264() {
            return this.canStartRegen() && !MoonDustBomb.checkEffectAndSplinters((class_1309)this.mob);
        }

        public boolean method_6266() {
            return !this.mob.getIsRegenerating() && !MoonDustBomb.checkEffectAndSplinters((class_1309)this.mob);
        }

        public void method_6269() {
            this.StoppedTicks = this.stopTicks;
            this.mob.setIsInvokingRegen(true);
            this.mob.method_5942().method_6340();
            this.mob.method_5783(this.mob.getScreamSound(), 1.0f, 1.0f);
            this.mob.triggerAnim("RegenController", "start_regen");
        }

        public void method_6270() {
            this.mob.setIsRegenerating(!MoonDustBomb.checkEffectAndSplinters((class_1309)this.mob));
            this.mob.setTimeForRegen(this.TimeForRegen);
            if (!this.mob.method_5701()) {
                this.mob.method_37908().method_8421((class_1297)this.mob, (byte)99);
            }
            this.mob.setHasCooldownForRegen(true);
            this.mob.setCooldownForRegen(this.CooldownBetweenRegens);
            this.StoppedTicks = this.stopTicks;
            this.mob.setIsInvokingRegen(false);
        }

        public void method_6268() {
            if (this.StoppedTicks > 0) {
                this.mob.method_5942().method_6340();
                --this.StoppedTicks;
            } else {
                this.method_6270();
            }
        }

        public boolean method_38846() {
            return true;
        }

        protected boolean canStartRegen() {
            return this.mob.method_6117() + this.ticksAttackedBeforeRegen < this.mob.field_6012 && !this.mob.getIsRegenerating() && this.mob.method_6032() < this.mob.method_6063() * this.healthPercentage && this.mob.method_24828() && !this.mob.hasCooldownForRegen();
        }
    }

    protected static class Ghoul_MeleeAttackGoal
    extends MeleeAttackGoal_Animated {
        public Ghoul_MeleeAttackGoal(class_1314 mob, double speed, boolean pauseWhenMobIdle) {
            super(mob, speed, pauseWhenMobIdle, 2);
        }

        @Override
        public boolean method_6266() {
            return super.method_6266() && !((GhoulEntity)this.mob).getIsInvokingRegen();
        }

        @Override
        public boolean method_6264() {
            return super.method_6264() && !((GhoulEntity)this.mob).getIsInvokingRegen();
        }
    }

    protected static class GhoulGoForFlesh
    extends class_1352 {
        private final GhoulEntity ghoul;
        private final double speed;

        public GhoulGoForFlesh(GhoulEntity ghoul, double speed) {
            this.ghoul = ghoul;
            this.speed = speed;
        }

        public boolean method_6264() {
            List<class_1542> list = this.searchFleshList();
            return !list.isEmpty() && this.ghoul.method_5998(class_1268.field_5808).method_31574(class_1799.field_8037.method_7909()) && this.ghoul.method_37908().method_8450().method_8355(class_1928.field_19388);
        }

        public boolean method_6266() {
            List<class_1542> list = this.searchFleshList();
            return !list.isEmpty() && this.ghoul.method_5998(class_1268.field_5808).method_31574(class_1799.field_8037.method_7909()) && this.ghoul.method_37908().method_8450().method_8355(class_1928.field_19388);
        }

        public void method_6269() {
            List<class_1542> list = this.searchFleshList();
            if (!list.isEmpty() && this.ghoul.method_5998(class_1268.field_5808).method_31574(class_1799.field_8037.method_7909()) && this.ghoul.method_37908().method_8450().method_8355(class_1928.field_19388)) {
                this.startMovingTo(this.ghoul.method_5942(), (class_1297)list.getFirst(), this.speed);
            }
        }

        public void method_6268() {
            List<class_1542> list = this.searchFleshList();
            if (!list.isEmpty() && this.ghoul.method_5998(class_1268.field_5808).method_31574(class_1799.field_8037.method_7909())) {
                this.startMovingTo(this.ghoul.method_5942(), (class_1297)list.getFirst(), this.speed);
                this.ghoul.method_5988().method_6226((class_1297)list.getFirst(), 30.0f, 30.0f);
            }
        }

        public void startMovingTo(class_1408 navigation, class_1297 entity, double speed) {
            class_11 path = navigation.method_6349(entity, 0);
            if (path != null) {
                navigation.method_6334(path, speed);
            }
        }

        private List<class_1542> searchFleshList() {
            return this.ghoul.method_37908().method_8390(class_1542.class, this.ghoul.method_5829().method_1009(8.0, 2.0, 8.0), itemEntity -> GhoulEntity.isEdibleMeat(itemEntity.method_6983()));
        }
    }
}

