/*
 * Decompiled with CFR 0.152.
 */
package TCOTS.entity.necrophages;

import TCOTS.entity.necrophages.NecrophageMonster;
import TCOTS.registry.TCOTS_Particles;
import TCOTS.registry.TCOTS_Sounds;
import TCOTS.utils.GeoControllersUtil;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_11;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1429;
import net.minecraft.class_1439;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3988;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GraveHagEntity
extends NecrophageMonster
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final RawAnimation ATTACK_TONGUE = RawAnimation.begin().thenPlay("attack.tongue2");
    public static final RawAnimation ATTACK_RUN = RawAnimation.begin().thenPlay("attack.run");
    protected static final class_2940<Boolean> TONGUE_ATTACK = class_2945.method_12791(GraveHagEntity.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Boolean> RUNNING = class_2945.method_12791(GraveHagEntity.class, (class_2941)class_2943.field_13323);
    boolean cooldownTongueAttack = false;
    boolean cooldownRunningAttack = false;
    int tongueAttackCooldownTicks;
    int runningAttackCooldownTicks;

    public GraveHagEntity(class_1299<? extends GraveHagEntity> entityType, class_1937 world) {
        super((class_1299<? extends NecrophageMonster>)entityType, world);
        this.field_6194 = 10;
    }

    public int method_5986() {
        return 70;
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new GraveHag_MeleeAttackGoal(this, 1.2, false, 200, 6.0f, 300, 1.8f));
        this.field_6201.method_6277(3, (class_1352)new class_1379((class_1314)this, 0.75, 20));
        this.field_6201.method_6277(4, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(0, (class_1352)new class_1399((class_1314)this, new Class[]{GraveHagEntity.class}));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_3988.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1429.method_26828().method_26868(class_5134.field_23716, 30.0).method_26868(class_5134.field_23721, 6.0).method_26868(class_5134.field_23719, (double)0.2f).method_26868(class_5134.field_23718, 0.5).method_26868(class_5134.field_23724, 4.0);
    }

    protected void method_5693(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(TONGUE_ATTACK, (Object)Boolean.FALSE);
        builder.method_56912(RUNNING, (Object)Boolean.FALSE);
    }

    public final boolean getTongueAttack() {
        return (Boolean)this.field_6011.method_12789(TONGUE_ATTACK);
    }

    public final void setTongueAttack(boolean wasAttacking) {
        this.field_6011.method_12778(TONGUE_ATTACK, (Object)wasAttacking);
    }

    public final boolean getIsRunning() {
        return (Boolean)this.field_6011.method_12789(RUNNING);
    }

    public final void setIsRunning(boolean wasRunning) {
        this.field_6011.method_12778(RUNNING, (Object)wasRunning);
    }

    public void method_5652(@NotNull class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("TongueAttack", ((Boolean)this.field_6011.method_12789(TONGUE_ATTACK)).booleanValue());
        nbt.method_10569("TongueAttackCooldown", this.tongueAttackCooldownTicks);
        nbt.method_10556("Running", ((Boolean)this.field_6011.method_12789(RUNNING)).booleanValue());
        nbt.method_10569("RunningAttackCooldown", this.runningAttackCooldownTicks);
    }

    public void method_5749(class_2487 nbt) {
        this.setTongueAttack(nbt.method_10577("TongueAttack"));
        this.tongueAttackCooldownTicks = nbt.method_10550("TongueAttackCooldown");
        this.setIsRunning(nbt.method_10577("Running"));
        this.runningAttackCooldownTicks = nbt.method_10550("RunningAttackCooldown");
        super.method_5749(nbt);
    }

    public int method_5978() {
        return this.getIsRunning() ? 1 : 40;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "Idle/Walk/Run", 1, state -> {
            if (this.getIsRunning()) {
                return state.setAndContinue(ATTACK_RUN);
            }
            if (state.isMoving()) {
                return state.setAndContinue(WALKING);
            }
            return state.setAndContinue(IDLE);
        }));
        controllers.add(new AnimationController((GeoAnimatable)this, "AttackController", 1, state -> PlayState.STOP).triggerableAnim("attack1", GeoControllersUtil.ATTACK1).triggerableAnim("attack2", GeoControllersUtil.ATTACK2));
        controllers.add(new AnimationController((GeoAnimatable)this, "TongueAttack", 1, state -> PlayState.STOP).triggerableAnim("tongue", ATTACK_TONGUE));
    }

    private void spawnGroundParticles() {
        class_2680 blockState = this.method_25936();
        if (blockState.method_26217() != class_2464.field_11455) {
            for (int i = 0; i < 8; ++i) {
                double d = this.method_23317() + (double)class_3532.method_32750((class_5819)this.field_5974, (float)-0.7f, (float)0.7f);
                double e = this.method_23318();
                double f = this.method_23321() + (double)class_3532.method_32750((class_5819)this.field_5974, (float)-0.7f, (float)0.7f);
                this.method_37908().method_8406((class_2394)new class_2388(class_2398.field_11217, blockState), d, e, f, 0.0, 0.0, 0.0);
            }
        }
    }

    public void method_5773() {
        if (this.getTongueAttack()) {
            class_243 vec3dCenter = this.method_5829().method_1005();
            for (int var3_5 = 0; var3_5 < 20; ++var3_5) {
                double xOffset = Math.cos(this.field_6255);
                double zOffset = Math.sin(this.field_6255);
                this.method_37908().method_8406((class_2394)TCOTS_Particles.GraveHagGreenSaliva(), vec3dCenter.field_1352, this.method_23320() - 0.2, vec3dCenter.field_1350, xOffset, 0.0, zOffset);
            }
        }
        if (this.tongueAttackCooldownTicks > 0) {
            --this.tongueAttackCooldownTicks;
        } else {
            this.cooldownTongueAttack = false;
        }
        if (this.getIsRunning()) {
            this.spawnGroundParticles();
        }
        if (this.runningAttackCooldownTicks > 0) {
            --this.runningAttackCooldownTicks;
        } else {
            this.cooldownRunningAttack = false;
        }
        super.method_5773();
    }

    protected class_3414 method_5994() {
        return TCOTS_Sounds.getSoundEvent("grave_hag_idle");
    }

    @NotNull
    protected class_3414 method_6011(@NotNull class_1282 source) {
        return TCOTS_Sounds.getSoundEvent("grave_hag_hurt");
    }

    @NotNull
    protected class_3414 method_6002() {
        return TCOTS_Sounds.getSoundEvent("grave_hag_death");
    }

    @Override
    protected class_3414 getAttackSound() {
        return TCOTS_Sounds.getSoundEvent("grave_hag_attack");
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private static class GraveHag_MeleeAttackGoal
    extends class_1352 {
        private final int timeBetweenTongueAttacks;
        private final float damageWithTongue;
        private final int timeBetweenRunningAttacks;
        protected final GraveHagEntity graveHag;
        private final double speed;
        private final boolean pauseWhenMobIdle;
        private class_11 path;
        private double targetX;
        private double targetY;
        private double targetZ;
        private int updateCountdownTicks;
        private int cooldown;
        private long lastUpdateTime;
        int AnimationTicks = 5;
        float speedMultiplierBase = 1.0f;
        private final float speedMultiplier;
        boolean tongueTriggered = false;
        boolean runTriggered = false;

        public GraveHag_MeleeAttackGoal(GraveHagEntity graveHag, double speed, boolean pauseWhenMobIdle, int timeBetweenTongueAttacks, float damageWithTongue, int timeBetweenRunningAttacks, float speedMultiplierWhenRun) {
            this.graveHag = graveHag;
            this.speed = speed;
            this.pauseWhenMobIdle = pauseWhenMobIdle;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
            this.timeBetweenTongueAttacks = timeBetweenTongueAttacks;
            this.damageWithTongue = damageWithTongue;
            this.timeBetweenRunningAttacks = timeBetweenRunningAttacks;
            this.speedMultiplier = speedMultiplierWhenRun;
        }

        public boolean method_6264() {
            long l = this.graveHag.method_37908().method_8510();
            if (l - this.lastUpdateTime < 20L) {
                return false;
            }
            this.lastUpdateTime = l;
            class_1309 livingEntity = this.graveHag.method_5968();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.method_5805()) {
                return false;
            }
            this.path = this.graveHag.method_5942().method_6349((class_1297)livingEntity, 0);
            if (this.path != null) {
                return true;
            }
            return this.getSquaredMaxAttackDistance(livingEntity) >= this.graveHag.method_5649(livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321());
        }

        public boolean method_6266() {
            class_1309 livingEntity = this.graveHag.method_5968();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.method_5805()) {
                return false;
            }
            if (!this.pauseWhenMobIdle) {
                return !this.graveHag.method_5942().method_6357();
            }
            if (!this.graveHag.method_18407(livingEntity.method_24515())) {
                return false;
            }
            return !(livingEntity instanceof class_1657) || !livingEntity.method_7325() && !((class_1657)livingEntity).method_7337();
        }

        public void method_6269() {
            this.graveHag.method_5942().method_6334(this.path, this.speed * (double)this.speedMultiplierBase);
            this.graveHag.method_19540(true);
            this.updateCountdownTicks = 0;
            this.cooldown = 0;
        }

        public void method_6270() {
            if (this.graveHag.getTongueAttack()) {
                this.graveHag.setTongueAttack(false);
            }
            if (this.graveHag.getIsRunning()) {
                this.graveHag.setIsRunning(false);
            }
            this.speedMultiplierBase = 1.0f;
            this.runTriggered = false;
            class_1309 livingEntity = this.graveHag.method_5968();
            if (!class_1301.field_6156.test(livingEntity)) {
                this.graveHag.method_5980(null);
            }
            this.graveHag.method_19540(false);
            this.graveHag.method_5942().method_6340();
        }

        public boolean method_38846() {
            return true;
        }

        public void tickO(class_1309 livingEntity) {
            if (livingEntity == null) {
                return;
            }
            this.graveHag.method_5988().method_6226((class_1297)livingEntity, 30.0f, 30.0f);
            double d = this.graveHag.method_5858((class_1297)livingEntity);
            this.updateCountdownTicks = Math.max(this.updateCountdownTicks - 1, 0);
            if ((this.pauseWhenMobIdle || this.graveHag.method_5985().method_6369((class_1297)livingEntity)) && this.updateCountdownTicks <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || livingEntity.method_5649(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.graveHag.method_59922().method_43057() < 0.05f)) {
                this.targetX = livingEntity.method_23317();
                this.targetY = livingEntity.method_23318();
                this.targetZ = livingEntity.method_23321();
                this.updateCountdownTicks = 4 + this.graveHag.method_59922().method_43048(7);
                if (d > 1024.0) {
                    this.updateCountdownTicks += 10;
                } else if (d > 256.0) {
                    this.updateCountdownTicks += 5;
                }
                if (!this.graveHag.method_5942().method_6335((class_1297)livingEntity, this.speed * (double)this.speedMultiplierBase)) {
                    this.updateCountdownTicks += 15;
                }
                this.updateCountdownTicks = this.method_38847(this.updateCountdownTicks);
            }
            this.cooldown = Math.max(this.cooldown - 1, 0);
            this.attack(livingEntity, d);
        }

        protected void attack(class_1309 target, double squaredDistance) {
            double d = this.getSquaredMaxAttackDistance(target);
            if (squaredDistance <= d && this.cooldown <= 0) {
                this.resetCooldown();
                this.graveHag.method_6104(class_1268.field_5808);
                int randomAttack = this.graveHag.method_59922().method_39332(0, 1);
                if (randomAttack == 0) {
                    this.graveHag.triggerAnim("AttackController", "attack1");
                } else {
                    this.graveHag.triggerAnim("AttackController", "attack2");
                }
                this.graveHag.method_6121((class_1297)target);
            }
        }

        public void method_6268() {
            class_1309 target = this.graveHag.method_5968();
            double d = this.graveHag.method_5858((class_1297)target);
            this.tongue_attack(d);
            this.running_attack(d);
            this.tickO(target);
        }

        private void tongue_attack(double d) {
            if (!this.graveHag.cooldownTongueAttack && this.AnimationTicks == 5 && d < 5.0) {
                this.graveHag.method_5942().method_6340();
                this.graveHag.triggerAnim("TongueAttack", "tongue");
                if (this.graveHag.method_5805()) {
                    List listTargets = this.graveHag.method_37908().method_8390(class_1309.class, this.graveHag.method_5829().method_1014(2.0), livingEntity -> livingEntity.method_5805() && !(livingEntity instanceof GraveHagEntity));
                    for (class_1309 livingEntity2 : listTargets) {
                        if (!(livingEntity2 instanceof NecrophageMonster)) {
                            livingEntity2.method_5643(this.graveHag.method_48923().method_48812((class_1309)this.graveHag), this.damageWithTongue);
                            if (livingEntity2.method_6039() && livingEntity2 instanceof class_1657) {
                                class_1657 player = (class_1657)livingEntity2;
                                player.method_7284();
                            }
                        }
                        this.knockBack((class_1297)livingEntity2);
                    }
                }
                this.graveHag.method_5783(TCOTS_Sounds.getSoundEvent("grave_hag_tongue_attack"), 1.5f, 1.0f);
                --this.AnimationTicks;
                this.tongueTriggered = true;
            }
            if (this.AnimationTicks > 0 && !this.graveHag.cooldownTongueAttack && this.tongueTriggered) {
                this.graveHag.method_5942().method_6340();
                --this.AnimationTicks;
            } else if (this.AnimationTicks == 0) {
                this.AnimationTicks = 5;
                this.tongueTriggered = false;
                this.graveHag.tongueAttackCooldownTicks = this.timeBetweenTongueAttacks;
                this.graveHag.cooldownTongueAttack = true;
            }
        }

        private boolean heightBoolean() {
            return this.heightBoolean(1.5f);
        }

        private boolean heightBoolean(float distance) {
            return this.graveHag.method_5968() != null && this.graveHag.method_5968().method_23318() - this.graveHag.method_23318() <= (double)distance;
        }

        private void running_attack(double d) {
            if (!this.graveHag.cooldownRunningAttack && d > 40.0 && !this.runTriggered && this.heightBoolean()) {
                this.graveHag.setIsRunning(true);
                this.speedMultiplierBase = this.speedMultiplier;
                this.graveHag.method_5783(TCOTS_Sounds.getSoundEvent("grave_hag_run"), 1.0f, 1.0f);
                this.runTriggered = true;
            }
            if (this.runTriggered && (d < 8.0 || !this.heightBoolean(4.0f))) {
                this.graveHag.cooldownRunningAttack = true;
                this.graveHag.runningAttackCooldownTicks = this.timeBetweenRunningAttacks;
                this.speedMultiplierBase = 1.0f;
                this.runTriggered = false;
                this.graveHag.setIsRunning(false);
            }
        }

        private void knockBack(class_1297 entity) {
            double d = entity.method_23317() - this.graveHag.method_23317();
            double e = entity.method_23321() - this.graveHag.method_23321();
            double f = Math.max(d * d + e * e, 0.001);
            entity.method_5762(d / f * 0.5, 0.1, e / f * 0.5);
        }

        protected void resetCooldown() {
            this.cooldown = this.method_38847(20);
        }

        protected double getSquaredMaxAttackDistance(class_1309 entity) {
            return this.graveHag.method_17681() * 2.0f * (this.graveHag.method_17681() * 2.0f) + entity.method_17681();
        }
    }
}

